package com.com2us.hive.adkit.sample.normal

import android.content.Intent
import android.os.Bundle
import android.view.View
import android.widget.TextView
import androidx.appcompat.app.AppCompatActivity
import com.com2us.hive.adkit.AppOpenAd
import com.com2us.hive.adkit.EventHandlers

class AppOpenActivityKT : AppCompatActivity() {
    var callbackStatus: TextView? = null
    var appOpen: AppOpenAd? = null
    override fun onCreate(savedInstanceState: Bundle?) {
        super.onCreate(savedInstanceState)
        setContentView(R.layout.activity_appopen)
        callbackStatus = findViewById(R.id.appopenCallbackStatus)

        findViewById<View>(R.id.destroyAppOpen).setOnClickListener { v: View? ->
            if(appOpen != null && appOpen!!.IsInitialzed()) {
                appOpen?.Destroy()
                appOpen = null
            }
            else finish()
        }
        findViewById<View>(R.id.goBackGround).setOnClickListener { v: View? ->
            val intent = Intent()
            intent.action = Intent.ACTION_MAIN
            intent.addCategory(Intent.CATEGORY_HOME)
            startActivity(intent)
        }

        appOpen = AppOpenAd.Initialize(this, "33906f96-dae8-4790-8ce4-d1f287ba00b2", object : EventHandlers() {
            override fun onAdLoaded() {
                super.onAdLoaded()
                callbackStatus?.append("onAdLoaded() Called\n")
            }

            override fun onAdOpening() {
                super.onAdOpening()
                callbackStatus?.append("onAdOpening() Called\n")
            }

            override fun onAdClosed() {
                super.onAdClosed()
                callbackStatus?.append("onAdClosed() Called\n")
            }

            override fun onAdFailed() {
                super.onAdFailed()
                callbackStatus?.append("onAdFailed() Called\n")
            }
        })

        appOpen?.LoadAd("load")
    }

    override fun onDestroy() {
        super.onDestroy()
        if(appOpen != null) appOpen!!.Destroy()
        appOpen = null
    }
}