package com.com2us.hive.adkit.sample.normal

import android.graphics.Point
import android.os.Bundle
import android.view.View
import android.widget.SeekBar
import android.widget.TextView
import androidx.appcompat.app.AppCompatActivity
import com.com2us.hive.adkit.AdaptiveBanner
import com.com2us.hive.adkit.EventHandlers

class BannerActivityKT : AppCompatActivity() {
    var callbackStatus: TextView? = null
    var adaptiveBanner: AdaptiveBanner? = null
    var eventHandlers: EventHandlers? = null
    override fun onCreate(savedInstanceState: Bundle?) {
        super.onCreate(savedInstanceState)
        setContentView(R.layout.activity_banner)
        callbackStatus = findViewById(R.id.bannerCallbackStatus)
        eventHandlers = object : EventHandlers() {
            override fun onAdLoaded() {
                callbackStatus?.append("onLoadAd() Called\n")
            }

            override fun onAdFailed() {
                callbackStatus?.append("onFailedAd() Called\n")
            }

            override fun onAdClick() {
                callbackStatus?.append("onClickAd() Called\n")
            }

            override fun onAdClosed() {
                callbackStatus?.append("onAdClosed() Called\n")
            }
        }
        adaptiveBanner = AdaptiveBanner.Initialize(this, "944fe870-fa3a-4d1b-9cc2-38e50b2aed43", AdaptiveBanner.BannerPosition.Bottom, eventHandlers)


        findViewById<View>(R.id.loadBanner).setOnClickListener { view: View? ->
            if (!adaptiveBanner!!.isLoaded) adaptiveBanner!!.LoadAd("load")
        }

        findViewById<View>(R.id.destroyBanner).setOnClickListener { view: View? ->
            if (adaptiveBanner!!.isLoaded) adaptiveBanner?.Destroy()
        }

        findViewById<View>(R.id.bannerTop).setOnClickListener { view: View? ->
            adaptiveBanner!!.setPosition(AdaptiveBanner.BannerPosition.Top)
        }
        findViewById<View>(R.id.bannerBottom).setOnClickListener { view: View? ->
            adaptiveBanner!!.setPosition(AdaptiveBanner.BannerPosition.Bottom)
        }

        findViewById<View>(R.id.bannerYPos).setOnClickListener { view: View? ->
            if (adaptiveBanner!!.isLoaded()) {
                adaptiveBanner!!.Destroy()
            }
            if (adaptiveBanner != null) adaptiveBanner = null
            adaptiveBanner = AdaptiveBanner.Initialize(this, "944fe870-fa3a-4d1b-9cc2-38e50b2aed43", 100, eventHandlers)
        }


        val size = Point()
        windowManager.defaultDisplay.getRealSize(size)
        val moveY = (size.y / resources.displayMetrics.density).toInt() / 100

        val seekBar = findViewById<SeekBar>(R.id.bannerSeekBar)
        seekBar.setOnSeekBarChangeListener(object : SeekBar.OnSeekBarChangeListener {
            override fun onProgressChanged(seekBar: SeekBar, progress: Int, fromUser: Boolean) {
                adaptiveBanner!!.setPosition(progress * moveY)
            }

            override fun onStartTrackingTouch(seekBar: SeekBar) {}
            override fun onStopTrackingTouch(seekBar: SeekBar) {}
        })
    }

    override fun onResume() {
        super.onResume()
        adaptiveBanner?.onResume()
    }

    override fun onPause() {
        super.onPause()
        adaptiveBanner?.onPause()
    }
}