package com.com2us.hive.adkit.sample.normal

import android.os.Bundle
import android.view.View
import android.widget.TextView
import androidx.appcompat.app.AppCompatActivity
import com.com2us.hive.adkit.RewardVideo
import com.com2us.hive.adkit.EventHandlers
import com.com2us.hive.adkit.AdaptiveBanner
import androidx.appcompat.widget.AppCompatSeekBar
import com.com2us.hive.adkit.Interstitial

class InterstitialActivityKT : AppCompatActivity() {
    var callbackStatus: TextView? = null
    override fun onCreate(savedInstanceState: Bundle?) {
        super.onCreate(savedInstanceState)
        setContentView(R.layout.activity_interstitial)
        callbackStatus = findViewById(R.id.interstitialCallbackStatus)

        //Require
        val interstitial = Interstitial.Initialize(this, "e9acd7fc-a962-40e4-aaad-9feab1b4f821", object : EventHandlers() {
            override fun onAdLoaded() {
                super.onAdLoaded()
                callbackStatus?.append("onAdLoaded() Called\n")
            }

            override fun onAdOpening() {
                super.onAdOpening()
                callbackStatus?.append("onAdOpening() Called\n")
            }

            override fun onAdClosed() {
                super.onAdClosed()
                callbackStatus?.append("onAdClosed() Called\n")
            }

            override fun onAdFailed() {
                super.onAdFailed()
                callbackStatus?.append("onAdFailed() Called\n")
            }

            override fun onAdClick() {
                super.onAdClick()
                callbackStatus?.append("onAdClick() Called\n")
            }
        })
        findViewById<View>(R.id.loadIntersitial).setOnClickListener { v: View? ->
            if (!interstitial.isLoaded) {
                interstitial.LoadAd("load")
            }
        }
        findViewById<View>(R.id.showIntersitial).setOnClickListener { v: View? ->
            if (interstitial.isLoaded) {
                interstitial.Show("show")
            }
        }
    }
}