package com.com2us.hive.adkit.sample.normal

import android.content.Intent
import android.os.Bundle
import android.util.Log
import android.widget.ArrayAdapter
import android.widget.Button
import android.widget.EditText
import androidx.appcompat.app.AlertDialog
import androidx.appcompat.app.AppCompatActivity
import androidx.appcompat.widget.AppCompatSpinner
import com.adop.sdk.Common
import com.com2us.hive.adkit.AdKit
import org.json.JSONException
import org.json.JSONObject
import java.util.*

class MainActivityKT : AppCompatActivity() {

    override fun onCreate(savedInstanceState: Bundle?) {
        Log.d("HIVEAdKit", "MainActivityKT onCreate")
        super.onCreate(savedInstanceState)
        setContentView(R.layout.activity_main)
        val deviceList = findViewById<AppCompatSpinner>(R.id.deviceList)
        val initAdKitGDPR = findViewById<Button>(R.id.initAdKitGDPR)

        val edtAdditionalInfo = findViewById<EditText>(R.id.extraInfoEdit)
        val btnShuffleInfo = findViewById<Button>(R.id.btnShuffleInfo)
        val btnSetAdditionalInfo = findViewById<Button>(R.id.btnSetAdditionalInfo)

        val showBanner = findViewById<Button>(R.id.goBannerSample)

        val showInterstitial = findViewById<Button>(R.id.goInterstitialSample)

        val showRewardVideo = findViewById<Button>(R.id.goRewardSample)

        val showAppOpen = findViewById<Button>(R.id.goAppOpenSample)

        val deviceNameList = arrayOf("테스트기기 선택", "갤럭시노트8", "갤럭시S9플러스", "갤럭시노트9", "갤럭시S10")
        val deviceGDPRTestDeviceIds = arrayOf(null, "D3A8A59D60495B231348403855E583DD", "BD94332389A60AB4CA71896CBC11DDF4", "FBE7646C13B9FB114243A2A102B54561", "635205665C48EE46B78AEC256576C0B6")
        val deviceAdmobTestDeviceIds = arrayOf(null, "D3A8A59D60495B231348403855E583DD", "BD94332389A60AB4CA71896CBC11DDF4", "FBE7646C13B9FB114243A2A102B54561", "635205665C48EE46B78AEC256576C0B6")

        deviceList.adapter = ArrayAdapter(this, android.R.layout.simple_spinner_dropdown_item, deviceNameList)
        initAdKitGDPR.setOnClickListener {
            deviceList.isEnabled = false
            val index = deviceList.selectedItemPosition
            val gdprTestDeviceId = deviceGDPRTestDeviceIds[index]
            val admobTestDeviceId = deviceAdmobTestDeviceIds[index]

            AdKit.InitializeWithShowGDPRConsent(this@MainActivityKT, true, gdprTestDeviceId, true, admobTestDeviceId) {
                /*
                동의 = 1,
                비동의 = 0,
                알수없음 = -1,
                필요없음 = -2
                 */
                Log.d("HIVEAdKit", "InitializeWithShowGDPRConsent onComplete consentState : $it")
            }
        }
        btnShuffleInfo.setOnClickListener {
            val sample = JSONObject()
            try {
                sample.put("level", Random().nextInt(100))
                sample.put("gold", Random().nextInt(100000))
            } catch (e: JSONException) {
                e.printStackTrace()
            }
            edtAdditionalInfo.setText(sample.toString())
        }
        btnSetAdditionalInfo.setOnClickListener {
            try {
                val data = JSONObject(edtAdditionalInfo.text.toString())
                AdKit.SetAdditionalInfo(data)
            } catch (e: JSONException) {
                AlertDialog.Builder(this@MainActivityKT)
                        .setTitle("SetAdditionInfo fail")
                        .setMessage("""
    Check Text : 
    ${edtAdditionalInfo.text}
    """.trimIndent())
                        .create()
                        .show()
            }
        }
        showBanner.setOnClickListener {
            val i = Intent(this@MainActivityKT, BannerActivityKT::class.java)
            startActivity(i)
        }
        showInterstitial.setOnClickListener {
            val i = Intent(this@MainActivityKT, InterstitialActivityKT::class.java)
            startActivity(i)
        }
        showRewardVideo.setOnClickListener {
            val i = Intent(this@MainActivityKT, RewardActivityKT::class.java)
            startActivity(i)
        }
        showAppOpen.setOnClickListener {
            val i = Intent(this@MainActivityKT, AppOpenActivityKT::class.java)
            startActivity(i)
        }

        Common.setDebugging(true) // print log for test
    }
}