package com.com2us.hive.adkit.sample.normal

import android.os.Bundle
import android.view.View
import android.widget.TextView
import androidx.appcompat.app.AppCompatActivity
import com.com2us.hive.adkit.RewardVideo
import com.com2us.hive.adkit.EventHandlers
import com.com2us.hive.adkit.AdaptiveBanner
import androidx.appcompat.widget.AppCompatSeekBar

class RewardActivityKT : AppCompatActivity() {
    var callbackStatus: TextView? = null
    override fun onCreate(savedInstanceState: Bundle?) {
        super.onCreate(savedInstanceState)
        setContentView(R.layout.activity_reward)
        callbackStatus = findViewById(R.id.rewardCallbackStatus)
        val rewardVideo = RewardVideo.Initialize(this, "7d9a2c9e-5755-4022-85f1-6d4fc79e4418", object : EventHandlers() {
            override fun onAdLoaded() {
                super.onAdLoaded()
                callbackStatus?.append("onAdLoaded() Called\n")
            }

            override fun onAdOpening() {
                super.onAdOpening()
                callbackStatus?.append("onAdOpening() Called\n")
            }

            override fun onAdClosed() {
                super.onAdClosed()
                callbackStatus?.append("onAdClosed() Called\n")
            }

            override fun onAdFailed() {
                super.onAdFailed()
                callbackStatus?.append("onAdFailed() Called\n")
            }

            override fun onAdReward() {
                super.onAdReward()
                callbackStatus?.append("onAdReward() Called\n")
            }

            override fun onAdClick() {
                super.onAdClick()
                callbackStatus?.append("onAdClick() Called\n")
            }
        })

        //Option(Use when needed)
//        mReward.setChildDirected(true); //COPPA
//        mReward.setCUID("YOUR ENCRYPTED CUID"); //Encrypt the identifier and send it to Bidmad.
//        mReward.setMute(true); //Only some networks are supported
        findViewById<View>(R.id.loadReward).setOnClickListener { v: View? ->
            if (!rewardVideo.isLoaded) {
                rewardVideo.LoadAd("load")
            }
        }
        findViewById<View>(R.id.showReward).setOnClickListener { v: View? ->
            if (rewardVideo.isLoaded) {
                rewardVideo.Show("show")
            }
        }
    }
}