#import "AppOpenAdViewController.h"
@import AdKit;

@interface AppOpenAdViewController () <EventHandler> {
    AppOpen *appOpen;
}
@end

@implementation AppOpenAdViewController

- (void)viewDidLoad {
    [super viewDidLoad];
    
    [self MakeAppOpen];
}

-(void)MakeAppOpen {
    if( appOpen == nil ) {
        NSString* zoneId = @"0ddd6401-0f19-49ee-b1f9-63e910f92e77";
        appOpen = [AppOpen initializeWithVc:self adUnitId:zoneId eventHandler:self];
    }
}

-(void)RemoveAppOpen {
    if( appOpen ) {
        [appOpen Destroy];
        appOpen = nil;
    }
}

-(IBAction)loadAppOpen:(UIButton*)sender{
    [self MakeAppOpen];
}

-(IBAction)destroyAppOpen:(UIButton*)sender{
    [self RemoveAppOpen];
}

- (IBAction)backButtonPressed:(id)sender {
    [self RemoveAppOpen];
    [self dismissViewControllerAnimated:YES completion:^{}];
}

#pragma mark AppOpenAd Delegate Methods

- (void)onAdLoaded {
    NSLog(@"onAdLoaded");
    [[self appOpenAdCallbackDisplay] setText:@"onAdLoaded"];
}

- (void)onAdOpening {
    NSLog(@"onAdOpening");
    [[self appOpenAdCallbackDisplay] setText:@"onAdOpening"];
}

- (void)onAdClosed {
    NSLog(@"onAdClosed");
    [[self appOpenAdCallbackDisplay] setText:@"onAdClosed"];
}

- (void)onAdFailed {
    NSLog(@"onAdFailed");
    [[self appOpenAdCallbackDisplay] setText:@"onAdFailed"];
}

- (void)onAdClick {
    NSLog(@"onAdClick");
    [[self appOpenAdCallbackDisplay] setText:@"onAdClick"];
}

@end
