#import "BannerViewController.h"
@import AdKit;

@interface BannerViewController () <EventHandler> {
    AdaptiveBanner *bannerAd;
}
@end

@implementation BannerViewController

// viewDidLoad에서 시작하면 현재 view의 크기를 알지 못하여 safearea 상관없이 가장 아래에 붙음
//- (void)viewDidLoad {
//    [super viewDidLoad];
//
//    NSString *zoneID = @"1c3e3085-333f-45af-8427-2810c26a72fc";
//
//    bannerAd = [AdaptiveBanner initializeWithVc:self adUnitId:zoneID yPos:0 eventHandler:self];
//}

- (void)viewDidAppear:(BOOL)animated {
    [super viewDidAppear:animated];

    NSString *zoneID = @"1c3e3085-333f-45af-8427-2810c26a72fc";
        
    bannerAd = [AdaptiveBanner initializeWithVc:self adUnitId:zoneID yPos:0 eventHandler:self];
}

- (IBAction)loadBanner:(id)sender {
    [bannerAd LoadAdWithAdPlacementInfo:@"load"];
}

- (IBAction)destroyBanner:(id)sender {
    [bannerAd Destroy];
}

- (IBAction)setPositionTop:(id)sender {
    [bannerAd setPositionWithBannerPosition:BannerPositionTop];
}

- (IBAction)setPositionBottom:(id)sender {
    [bannerAd setPositionWithBannerPosition:BannerPositionBottom];
}

- (IBAction)setPositionY:(UISlider *)sender {
    [bannerAd setPositionWithYPosition: (sender.value) * self.view.frame.size.height];
}

- (IBAction)actionButtonPressend:(UIButton *)sender {

}

#pragma mark Banner Deleagate

- (IBAction)backBtn:(id)sender {
    NSLog(@"Back Button Pressed");
    [self dismissViewControllerAnimated:YES completion:^{ }];
}

- (void)onAdLoaded {
    NSLog(@"onAdLoaded");
    [[self bannerCallbackDisplay] setText:@"onAdLoaded"];
}

- (void)onAdOpening {
    NSLog(@"onAdOpening");
    [[self bannerCallbackDisplay] setText:@"onAdOpening"];
}

- (void)onAdClosed {
    NSLog(@"onAdClosed");
    [[self bannerCallbackDisplay] setText:@"onAdClosed"];
}

- (void)onAdFailed {
    NSLog(@"onAdFailed");
    [[self bannerCallbackDisplay] setText:@"onAdFailed"];
}

- (void)onAdClick {
    NSLog(@"onAdClick");
    [[self bannerCallbackDisplay] setText:@"onAdClick"];
}

@end
