#import "InterstitialViewController.h"
@import AdKit;

@interface InterstitialViewController () <EventHandler> {
    Interstitial* interstitialAd;
}
@end

@implementation InterstitialViewController
- (void)viewDidLoad {
    [super viewDidLoad];
    
    NSString *zoneID = @"228b95a9-6f42-46d8-a40d-60f17f751eb1";
    interstitialAd = [Interstitial initializeWithVc:self adUnitId:zoneID eventHandler:self];
}

-(IBAction)loadInterstitial:(UIButton*)sender{
    [interstitialAd LoadAdWithAdPlacementInfo:@"load"];
}

-(IBAction)showInterstitial:(UIButton*)sender{
    if ([interstitialAd isLoaded])
        [interstitialAd ShowWithAdPlacementInfo:@"show"];
}

- (IBAction)backBtnPressed:(id)sender {
    NSLog(@"Back Button Pressed");
    
    [self dismissViewControllerAnimated:YES completion:^{ }];
}

#pragma mark Interstitial Delegate

- (void)onAdLoaded {
    NSLog(@"onAdLoaded");
    [[self InterstitialCallbackDisplay] setText:@"onAdLoaded"];
}

- (void)onAdOpening {
    NSLog(@"onAdOpening");
    [[self InterstitialCallbackDisplay] setText:@"onAdOpening"];
}

- (void)onAdClosed {
    NSLog(@"onAdClosed");
    [[self InterstitialCallbackDisplay] setText:@"onAdClosed"];
}

- (void)onAdFailed {
    NSLog(@"onAdFailed");
    [[self InterstitialCallbackDisplay] setText:@"onAdFailed"];
}

@end
