#import "RewardViewController.h"
@import AdKit;

@interface RewardViewController () <EventHandler> {
    RewardVideo *rewardAd;
}
@end

@implementation RewardViewController

- (void)viewDidLoad {
  [super viewDidLoad];
        
    NSString *zoneID = @"29e1ef67-98d2-47b3-9fa2-9192327dd75d";
    rewardAd = [RewardVideo initializeWithVc:self adUnitId:zoneID eventHandler:self];
}

-(IBAction)loadReward:(UIButton*)sender{
    [rewardAd LoadAdWithAdPlacementInfo:@"load"];
}

-(IBAction)showReward:(UIButton*)sender{
    if ([rewardAd isLoaded]) {
        [rewardAd ShowWithAdPlacementInfo:@"show"];
    }
}

- (IBAction)backBtnPressed:(id)sender {
    //NSLog(@"Back Button Pressed");
    
    [self dismissViewControllerAnimated:YES completion:^{ }];
}

#pragma mark Reward Delegate

- (void)onAdLoaded {
    NSLog(@"onAdLoaded");
    [[self rewardCallbackDisplay] setText:@"onAdLoaded"];
}

- (void)onAdOpening {
    NSLog(@"onAdOpening");
    [[self rewardCallbackDisplay] setText:@"onAdOpening"];
}

- (void)onAdClosed {
    NSLog(@"onAdClosed");
    [[self rewardCallbackDisplay] setText:@"onAdClosed"];
}

- (void)onAdFailed {
    NSLog(@"onAdFailed");
    [[self rewardCallbackDisplay] setText:@"onAdFailed"];
}

- (void)onAdReward {
    NSLog(@"onAdReward");
    [[self rewardCallbackDisplay] setText:@"onAdReward"];
}

- (void)onAdClick {
    NSLog(@"onAdClick");
    [[self rewardCallbackDisplay] setText:@"onAdClick"];
}

@end
