// Copyright (C) 2024 Com2uS Platform Corporation

#include "HIVEConfigAndroidSettings.h"


UHIVEConfigAndroidSettings::UHIVEConfigAndroidSettings(const FObjectInitializer& ObjectInitializer)
: Super(ObjectInitializer)
{
    ConfigFilePath = TEXT("Plugins/HIVESDK/Source/HiveSDKAndroid/resource/res/raw/hive_config.xml");
}

void UHIVEConfigAndroidSettings::PostEditChangeProperty(struct FPropertyChangedEvent& PropertyChangedEvent)
{
    Super::PostEditChangeProperty(PropertyChangedEvent);

    if(ConfigFilePath.IsEmpty())
    {
        UE_LOG(LogTemp, Log, TEXT("UHIVEConfigBaseSettings PostEditChangeProperty ConfigPath Is Empty."));
        return;
    }

    
    FString absoluteConfigPath = FPaths::Combine(*FPaths::ProjectDir(), *ConfigFilePath); 
    ConfigFile.LoadFile(TCHAR_TO_UTF8(*absoluteConfigPath));
    
    if(ConfigFile.NoChildren())
        ConfigFile.Parse(GetBaseXmlChar());
    
    RootNode = ConfigFile.RootElement();


    const FName PropertyName = (PropertyChangedEvent.Property != NULL) ? PropertyChangedEvent.Property->GetFName() : NAME_None;

    if (PropertyName == GET_MEMBER_NAME_CHECKED(UHIVEConfigAndroidSettings, UnsupportedUAShareTypeValues))
    {
        tinyxml2::XMLElement * BeforeUnsupportedUAShareTypeNode = RootNode->FirstChildElement("unsupportedUAShareType");
        if (BeforeUnsupportedUAShareTypeNode != NULL)
        {
            RootNode->DeleteChild(BeforeUnsupportedUAShareTypeNode);
        }

        tinyxml2::XMLElement * UnsupportedUAShareTypeNode = ConfigFile.NewElement("unsupportedUAShareType");

        for(const auto& Value : UnsupportedUAShareTypeValues)
        {
            tinyxml2::XMLElement * NewValueNode = ConfigFile.NewElement("value");
            NewValueNode->SetText(TCHAR_TO_UTF8(*Value));
            UnsupportedUAShareTypeNode->InsertEndChild(NewValueNode);
        }
        RootNode->InsertEndChild(UnsupportedUAShareTypeNode);
    }
    /* providers */
    else if(PropertyChangedEvent.MemberProperty && PropertyChangedEvent.MemberProperty->GetFName() == GET_MEMBER_NAME_CHECKED(UHIVEConfigCommonSettings, ProviderFacebook))
    {
        SetFacebookAndroidManifestOptions();
    }
    else if (PropertyChangedEvent.MemberProperty && PropertyChangedEvent.MemberProperty->GetFName() == GET_MEMBER_NAME_CHECKED(UHIVEConfigCommonSettings, ProviderAirbridge))
    {
        SetAirbridgeOptions();
    }
    else if(PropertyChangedEvent.MemberProperty && PropertyChangedEvent.MemberProperty->GetFName() == GET_MEMBER_NAME_CHECKED(UHIVEConfigAndroidSettings, ProviderGooglePlayGames))
    {
        tinyxml2::XMLElement * ProvidersNode = RootNode->FirstChildElement("providers");

        tinyxml2::XMLElement * GooglePlayGamesNode = ConfigFile.NewElement("googleplaygames");
        GooglePlayGamesNode->SetAttribute("playAppId", TCHAR_TO_UTF8(*(ProviderGooglePlayGames.ID)));
        GooglePlayGamesNode->SetAttribute("serverClientId", TCHAR_TO_UTF8(*(ProviderGooglePlayGames.ServerClientId)));

        if(ProvidersNode != NULL)
        {
            tinyxml2::XMLElement * BeforeGooglePlayGamesNode = ProvidersNode->FirstChildElement("googleplaygames");
            if(BeforeGooglePlayGamesNode != NULL)
            {
                ProvidersNode->DeleteChild(BeforeGooglePlayGamesNode);
            }
            ProvidersNode->InsertEndChild(GooglePlayGamesNode);
        }
        else
        {
            tinyxml2::XMLElement * NewProvidersNode = ConfigFile.NewElement("providers");
            NewProvidersNode->InsertEndChild(GooglePlayGamesNode);
            RootNode->InsertEndChild(NewProvidersNode);
        }
        SetGooglePlayGamesAndroidManifestOptions();
    }
    else if(PropertyChangedEvent.MemberProperty && PropertyChangedEvent.MemberProperty->GetFName() == GET_MEMBER_NAME_CHECKED(UHIVEConfigCommonSettings, ProviderQQ))
    {
        SetQQManifestOptions();
    }
    else if(PropertyChangedEvent.MemberProperty && PropertyChangedEvent.MemberProperty->GetFName() == GET_MEMBER_NAME_CHECKED(UHIVEConfigCommonSettings, ProviderVK))
    {
        SetVKManifestOptions();
    }

    ConfigFile.SaveFile(TCHAR_TO_UTF8(*absoluteConfigPath));
}

tinyxml2::XMLNode* UHIVEConfigAndroidSettings::SerachXMLAttribute(tinyxml2::XMLNode* targetNode, const char* attributeName, const char* attributeValue)
{
    if(targetNode == NULL)
    {
        return NULL;
    }

    for(const tinyxml2::XMLNode * query = targetNode; query ; query = query->NextSibling())
    {
        const tinyxml2::XMLElement * tempElement = query->ToElement();
        if(tempElement)
        {
            if(strcmp(tempElement->Attribute(attributeName, NULL), attributeValue) == 0)
            {
                return (tinyxml2::XMLNode *)query;
            }
        }
    }
    return NULL;
}

void UHIVEConfigAndroidSettings::SetFacebookAndroidManifestOptions()
{
    const char* hiveString =
    "<?xml version=\"1.0\" encoding=\"UTF-8\"?>"
    "<resources>"
    "</resources>";
    tinyxml2::XMLDocument etcHiveStringXml;
    FString SavedConfigFileAD = FPaths::Combine(*FPaths::ProjectDir(), *FString("Plugins/HIVESDK/Source/HiveSDKAndroid/resource/res/values/etc_strings.xml"));
   
    etcHiveStringXml.LoadFile(TCHAR_TO_UTF8(*SavedConfigFileAD));
 
    if(etcHiveStringXml.NoChildren())
    {
        etcHiveStringXml.Parse(hiveString);
    }

    tinyxml2::XMLNode * hiveStringRootElem = etcHiveStringXml.RootElement();
    tinyxml2::XMLNode * stringElement = hiveStringRootElem->FirstChildElement("string");

    tinyxml2::XMLNode * hiveStringFBprovider = SerachXMLAttribute(stringElement, "name", "appFBContentProvider");
    FString fbproviderValue = FString::Printf(TEXT("com.facebook.app.FacebookContentProvider%s"), *(ProviderFacebook.ID));
    if(hiveStringFBprovider != NULL)
    {
        hiveStringFBprovider->ToElement()->SetText(TCHAR_TO_UTF8(*fbproviderValue));
    }
    else
    {
        hiveStringFBprovider = etcHiveStringXml.NewElement("string");
        hiveStringFBprovider->ToElement()->SetAttribute("name", "appFBContentProvider");
        hiveStringFBprovider->ToElement()->SetText(TCHAR_TO_UTF8(*fbproviderValue));
        hiveStringRootElem->InsertEndChild(hiveStringFBprovider);
    }
    
    tinyxml2::XMLNode * hiveStringApplictionID = SerachXMLAttribute(stringElement, "name", "applicationId");
    if(hiveStringApplictionID != NULL)
    {
        hiveStringApplictionID->ToElement()->SetText(TCHAR_TO_UTF8(*(ProviderFacebook.ID)));
    }
    else
    {
        hiveStringApplictionID = etcHiveStringXml.NewElement("string");
        hiveStringApplictionID->ToElement()->SetAttribute("name", "applicationId");
        hiveStringApplictionID->ToElement()->SetText(TCHAR_TO_UTF8(*(ProviderFacebook.ID)));
        hiveStringRootElem->InsertEndChild(hiveStringApplictionID);
    }

    tinyxml2::XMLNode * hiveStringClientToken = SerachXMLAttribute(stringElement, "name", "facebookClientToken");
    if(hiveStringClientToken != NULL)
    {
        hiveStringClientToken->ToElement()->SetText(TCHAR_TO_UTF8(*(ProviderFacebook.ClientToken)));
    }
    else
    {
        hiveStringClientToken = etcHiveStringXml.NewElement("string");
        hiveStringClientToken->ToElement()->SetAttribute("name", "facebookClientToken");
        hiveStringClientToken->ToElement()->SetText(TCHAR_TO_UTF8(*(ProviderFacebook.ClientToken)));
        hiveStringRootElem->InsertEndChild(hiveStringClientToken);
    }

    etcHiveStringXml.SaveFile(TCHAR_TO_UTF8(*SavedConfigFileAD));
}

void UHIVEConfigAndroidSettings::SetAirbridgeOptions()
{
    const char* hiveString =
        "<?xml version=\"1.0\" encoding=\"UTF-8\"?>"
        "<resources>"
        "</resources>";
    tinyxml2::XMLDocument etcHiveStringXml;
    FString SavedConfigFileAD = FPaths::Combine(*FPaths::ProjectDir(), *FString("Plugins/HIVESDK/Source/HiveSDKAndroid/resource/res/values/etc_strings.xml"));

    etcHiveStringXml.LoadFile(TCHAR_TO_UTF8(*SavedConfigFileAD));

    if (etcHiveStringXml.NoChildren())
    {
        etcHiveStringXml.Parse(hiveString);
    }

    tinyxml2::XMLNode* hiveStringRootElem = etcHiveStringXml.RootElement();
    tinyxml2::XMLNode* stringElement = hiveStringRootElem->FirstChildElement("string");

    tinyxml2::XMLNode* hiveStringSchemeType1 = SerachXMLAttribute(stringElement, "name", "airbridgeDeepLinkSchemeType1");

    FString airbridgeSchemeType1 = FString::Printf(TEXT("%s.abr.ge"), *(ProviderAirbridge.AppName));
    if (hiveStringSchemeType1 != NULL)
    {
        hiveStringSchemeType1->ToElement()->SetText(TCHAR_TO_UTF8(*airbridgeSchemeType1));
    }
    else
    {
        hiveStringSchemeType1 = etcHiveStringXml.NewElement("string");
        hiveStringSchemeType1->ToElement()->SetAttribute("name", "airbridgeDeepLinkSchemeType1");
        hiveStringSchemeType1->ToElement()->SetText(TCHAR_TO_UTF8(*airbridgeSchemeType1));
        hiveStringRootElem->InsertEndChild(hiveStringSchemeType1);
    }

    tinyxml2::XMLNode* hiveStringSchemeType2 = SerachXMLAttribute(stringElement, "name", "airbridgeDeepLinkSchemeType2");

    FString airbridgeSchemeType2 = FString::Printf(TEXT("%s.airbridge.io"), *(ProviderAirbridge.AppName));
    if (hiveStringSchemeType2 != NULL)
    {
        hiveStringSchemeType2->ToElement()->SetText(TCHAR_TO_UTF8(*airbridgeSchemeType2));
    }
    else
    {
        hiveStringSchemeType2 = etcHiveStringXml.NewElement("string");
        hiveStringSchemeType2->ToElement()->SetAttribute("name", "airbridgeDeepLinkSchemeType2");
        hiveStringSchemeType2->ToElement()->SetText(TCHAR_TO_UTF8(*airbridgeSchemeType2));
        hiveStringRootElem->InsertEndChild(hiveStringSchemeType2);
    }

    etcHiveStringXml.SaveFile(TCHAR_TO_UTF8(*SavedConfigFileAD));
}

void UHIVEConfigAndroidSettings::SetGooglePlayGamesAndroidManifestOptions()
{
    const char* hiveString =
    "<?xml version=\"1.0\" encoding=\"UTF-8\"?>"
    "<resources>"
    "</resources>";
    tinyxml2::XMLDocument googlePlayAppIDxml;
    FString SavedConfigFileAD = FPaths::Combine(*FPaths::ProjectDir(), *FString("Plugins/HIVESDK/Source/HiveSDKAndroid/resource/res/values/GooglePlayAppID.xml"));
    
    googlePlayAppIDxml.LoadFile(TCHAR_TO_UTF8(*SavedConfigFileAD));
    
    if(googlePlayAppIDxml.NoChildren())
    {
        googlePlayAppIDxml.Parse(hiveString);
    }
    
    tinyxml2::XMLNode * hiveStringRootElem = googlePlayAppIDxml.RootElement();
    tinyxml2::XMLNode * stringElement = hiveStringRootElem->FirstChildElement("string");
    tinyxml2::XMLNode * hiveStringApplictionID = SerachXMLAttribute(stringElement, "name", "app_id");
    if(hiveStringApplictionID != NULL)
    {
        hiveStringApplictionID->ToElement()->SetText(TCHAR_TO_UTF8(*(ProviderGooglePlayGames.ID)));
    }
    else
    {
        hiveStringApplictionID = googlePlayAppIDxml.NewElement("string");
        hiveStringApplictionID->ToElement()->SetAttribute("name", "app_id");
        hiveStringApplictionID->ToElement()->SetText(TCHAR_TO_UTF8(*(ProviderGooglePlayGames.ID)));
        hiveStringRootElem->InsertEndChild(hiveStringApplictionID);
    }
    googlePlayAppIDxml.SaveFile(TCHAR_TO_UTF8(*SavedConfigFileAD));
}

void UHIVEConfigAndroidSettings::SetQQManifestOptions()
{
    const char* hiveString =
    "<?xml version=\"1.0\" encoding=\"UTF-8\"?>"
    "<resources>"
    "</resources>";
    tinyxml2::XMLDocument etcHiveStringXml;
    FString SavedConfigFileAD = FPaths::Combine(*FPaths::ProjectDir(), *FString("Plugins/HIVESDK/Source/HiveSDKAndroid/resource/res/values/etc_strings.xml"));
    
    etcHiveStringXml.LoadFile(TCHAR_TO_UTF8(*SavedConfigFileAD));
    
    if(etcHiveStringXml.NoChildren())
    {
        etcHiveStringXml.Parse(hiveString);
    }
    
    tinyxml2::XMLNode * hiveStringRootElem = etcHiveStringXml.RootElement();
    tinyxml2::XMLNode * stringElement = hiveStringRootElem->FirstChildElement("string");
    
    tinyxml2::XMLNode * hiveStringQQID = SerachXMLAttribute(stringElement, "name", "tencentqqappid");
    FString QQIDValue = FString::Printf(TEXT("tencent%s"), *(ProviderQQ.ID));
    if(hiveStringQQID != NULL)
    {
        hiveStringQQID->ToElement()->SetText(TCHAR_TO_UTF8(*QQIDValue));
    }
    else
    {
        hiveStringQQID = etcHiveStringXml.NewElement("string");
        hiveStringQQID->ToElement()->SetAttribute("name", "tencentqqappid");
        hiveStringQQID->ToElement()->SetText(TCHAR_TO_UTF8(*QQIDValue));
        hiveStringRootElem->InsertEndChild(hiveStringQQID);
    }
    etcHiveStringXml.SaveFile(TCHAR_TO_UTF8(*SavedConfigFileAD));
}

void UHIVEConfigAndroidSettings::SetVKManifestOptions()
{
    const char* hiveString =
    "<?xml version=\"1.0\" encoding=\"UTF-8\"?>"
    "<resources>"
    "</resources>";
    tinyxml2::XMLDocument etcHiveStringXml;
    FString SavedConfigFileAD = FPaths::Combine(*FPaths::ProjectDir(), *FString("Plugins/HIVESDK/Source/HiveSDKAndroid/resource/res/values/etc_strings.xml"));
    
    etcHiveStringXml.LoadFile(TCHAR_TO_UTF8(*SavedConfigFileAD));
    
    if(etcHiveStringXml.NoChildren())
    {
        etcHiveStringXml.Parse(hiveString);
    }
    
    tinyxml2::XMLNode * hiveStringRootElem = etcHiveStringXml.RootElement();
    tinyxml2::XMLNode * stringElement = hiveStringRootElem->FirstChildElement("string");
    
    tinyxml2::XMLNode * hiveStringVKClientId = SerachXMLAttribute(stringElement, "name", "vkClientId");
    FString VKIDValue = FString::Printf(TEXT("vk%s"), *(ProviderVK.AppId));
    if(hiveStringVKClientId != NULL)
    {
        hiveStringVKClientId->ToElement()->SetText(TCHAR_TO_UTF8(*VKIDValue));
    }
    else
    {
        hiveStringVKClientId = etcHiveStringXml.NewElement("string");
        hiveStringVKClientId->ToElement()->SetAttribute("name", "vkClientId");
        hiveStringVKClientId->ToElement()->SetText(TCHAR_TO_UTF8(*VKIDValue));
        hiveStringRootElem->InsertEndChild(hiveStringVKClientId);
    }
    etcHiveStringXml.SaveFile(TCHAR_TO_UTF8(*SavedConfigFileAD));
}