// Copyright (C) 2024 Com2uS Platform Corporation

#include "HIVEConfigCommonSettings.h"

UHIVEConfigCommonSettings::UHIVEConfigCommonSettings(const FObjectInitializer& ObjectInitializer)
: Super(ObjectInitializer)
/* Common */
,AppId(TEXT(""))
,Zone(EHIVEConfigZone::Sandbox)
,UseLog(false)
,AgeGateU13(false)
,Company(TEXT(""))
,Channel(TEXT(""))
,Market(TEXT(""))
,Orientation(EHIVEConfigOrientation::Undefined)
,AgreementDetermineBase(EHIVEConfigAgreementDetermineBase::Device)
,HttpConnectTimeout(TEXT("8"))
,HttpReadTimeout(TEXT("8"))
{ }

void UHIVEConfigCommonSettings::PostEditChangeProperty(struct FPropertyChangedEvent& PropertyChangedEvent)
{
    if(ConfigFilePath.IsEmpty())
    {
        UE_LOG(LogTemp, Log, TEXT("UHIVEConfigBaseSettings PostEditChangeProperty ConfigPath Is Empty."));
        return;
    }

    
    FString absoluteConfigPath = FPaths::Combine(*FPaths::ProjectDir(), *ConfigFilePath); 
    ConfigFile.LoadFile(TCHAR_TO_UTF8(*absoluteConfigPath));
    
    if(ConfigFile.NoChildren())
        ConfigFile.Parse(GetBaseXmlChar());
    
    RootNode = ConfigFile.RootElement();

    const FName MemberPropertyName = (PropertyChangedEvent.MemberProperty != NULL) ? PropertyChangedEvent.MemberProperty->GetFName() : NAME_None;
    if (MemberPropertyName == GET_MEMBER_NAME_CHECKED(UHIVEConfigCommonSettings, AppId))
    {
        AddOrReplaceElement(TEXT("appId"), AppId);
    }
    else if (MemberPropertyName == GET_MEMBER_NAME_CHECKED(UHIVEConfigCommonSettings, Zone))
    {
        FString sZone;
        switch (Zone)
        {
            case EHIVEConfigZone::Sandbox:
                sZone = TEXT("sandbox");
                break;
            case EHIVEConfigZone::Real:
                sZone = TEXT("real");
                break;
            default:
                sZone = TEXT("");
                break;
        }
        AddOrReplaceElement(TEXT("zone"), sZone);
    }
    else if (MemberPropertyName == GET_MEMBER_NAME_CHECKED(UHIVEConfigCommonSettings, UseLog))
    {
        FString sUseLog = UseLog ? TEXT("true") : TEXT("false");
        AddOrReplaceElement(TEXT("useLog"), sUseLog);
    }
    else if (MemberPropertyName == GET_MEMBER_NAME_CHECKED(UHIVEConfigCommonSettings, AgeGateU13))
    {
        FString sAgeGateU13 = UseLog ? TEXT("true") : TEXT("false");
        AddOrReplaceElement(TEXT("ageGateU13"), sAgeGateU13);
    }
    else if (MemberPropertyName == GET_MEMBER_NAME_CHECKED(UHIVEConfigCommonSettings, Company))
    {
        AddOrReplaceElement(TEXT("company"), Company);
    }
    else if (MemberPropertyName == GET_MEMBER_NAME_CHECKED(UHIVEConfigCommonSettings, Channel))
    {
        AddOrReplaceElement(TEXT("channel"), Channel);
    }
    else if (MemberPropertyName == GET_MEMBER_NAME_CHECKED(UHIVEConfigCommonSettings, Market))
    {
        AddOrReplaceElement(TEXT("market"), Market);
    }
    else if (MemberPropertyName == GET_MEMBER_NAME_CHECKED(UHIVEConfigCommonSettings, Orientation))
    {
        FString sOrientation;
        switch (Orientation)
        {
            case EHIVEConfigOrientation::Undefined:
                sOrientation = TEXT("undefined");
                break;
            case EHIVEConfigOrientation::All:
                sOrientation = TEXT("all");
                break;
            case EHIVEConfigOrientation::Portrait:
                sOrientation = TEXT("portrait");
                break;
            case EHIVEConfigOrientation::Landscape:
                sOrientation = TEXT("landscape");
                break;
            default:
                sOrientation = TEXT("");
                break;
        }
        if (!sOrientation.IsEmpty())
        {
            AddOrReplaceElement(TEXT("hiveOrientation"), sOrientation);
        }
    }
    else if (MemberPropertyName == GET_MEMBER_NAME_CHECKED(UHIVEConfigCommonSettings, AgreementDetermineBase))
    {
        FString sAgreementDetermineBase;
        switch (AgreementDetermineBase)
        {
            case EHIVEConfigAgreementDetermineBase::Device:
                sAgreementDetermineBase = TEXT("device");
                break;
            case EHIVEConfigAgreementDetermineBase::Account:
                sAgreementDetermineBase = TEXT("account");
                break;
            default:
                sAgreementDetermineBase = TEXT("");
                break;
        }
        if (!sAgreementDetermineBase.IsEmpty())
        {
            AddOrReplaceElement(TEXT("agreementDetermineBase"), sAgreementDetermineBase);
        }
    }
    else if (MemberPropertyName == GET_MEMBER_NAME_CHECKED(UHIVEConfigCommonSettings, HttpConnectTimeout))
    {
        AddOrReplaceElement(TEXT("httpConnectTimeout"), HttpConnectTimeout);
    }
    else if (MemberPropertyName == GET_MEMBER_NAME_CHECKED(UHIVEConfigCommonSettings, HttpReadTimeout))
    {
        AddOrReplaceElement(TEXT("httpReadTimeout"), HttpReadTimeout);
    }
    /* Provider */
    else if(MemberPropertyName == GET_MEMBER_NAME_CHECKED(UHIVEConfigCommonSettings, ProviderFacebook))
    {
        tinyxml2::XMLElement * ProvidersNode = RootNode->FirstChildElement("providers");

        tinyxml2::XMLElement * FacebookNode = ConfigFile.NewElement("facebook");
        FacebookNode->SetAttribute("id", TCHAR_TO_UTF8(*(ProviderFacebook.ID)));
        FacebookNode->SetAttribute("clientToken", TCHAR_TO_UTF8(*(ProviderFacebook.ClientToken)));

        tinyxml2::XMLElement * PermissionsNode = ConfigFile.NewElement("permissions");
        for(const auto& Permission : ProviderFacebook.Permissions)
        {
            tinyxml2::XMLElement * NewPermissionNode = ConfigFile.NewElement("permission");
            NewPermissionNode->SetAttribute("name", TCHAR_TO_UTF8(*Permission));
            PermissionsNode->InsertEndChild(NewPermissionNode);
        }
        FacebookNode->InsertEndChild(PermissionsNode);

        if(ProvidersNode != NULL)
        {
            tinyxml2::XMLElement * BeforeFacebookNode = ProvidersNode->FirstChildElement("facebook");
            if(BeforeFacebookNode != NULL)
            {
                ProvidersNode->DeleteChild(BeforeFacebookNode);
            }
            ProvidersNode->InsertEndChild(FacebookNode);
        }
        else
        {
            tinyxml2::XMLElement * NewProvidersNode = ConfigFile.NewElement("providers");
            NewProvidersNode->InsertEndChild(FacebookNode);
            RootNode->InsertEndChild(NewProvidersNode);
        }
    }
    else if(MemberPropertyName == GET_MEMBER_NAME_CHECKED(UHIVEConfigCommonSettings, ProviderGoogle))
    {
        tinyxml2::XMLElement* NewProvider = ConfigFile.NewElement("google");
        NewProvider->SetAttribute("playAppId", TCHAR_TO_UTF8(*(ProviderGoogle.ID)));
        NewProvider->SetAttribute("clientId", TCHAR_TO_UTF8(*(ProviderGoogle.ClientId)));
        NewProvider->SetAttribute("serverClientId", TCHAR_TO_UTF8(*(ProviderGoogle.ServerClientId)));
        NewProvider->SetAttribute("reversedClientId", TCHAR_TO_UTF8(*(ProviderGoogle.ReverseClientId)));

        AddOrReplaceInProviders(NewProvider);
    }
    else if(MemberPropertyName == GET_MEMBER_NAME_CHECKED(UHIVEConfigCommonSettings, ProviderWechat))
    {
        tinyxml2::XMLElement* NewProvider = ConfigFile.NewElement("wechat");
        NewProvider->SetAttribute("id", TCHAR_TO_UTF8(*(ProviderWechat.ID)));
        NewProvider->SetAttribute("secret", TCHAR_TO_UTF8(*(ProviderWechat.Secret)));
        NewProvider->SetAttribute("paymentKey", TCHAR_TO_UTF8(*(ProviderWechat.PaymentKey)));
        NewProvider->SetAttribute("univeralLink", TCHAR_TO_UTF8(*(ProviderWechat.UniversalLink)));

        AddOrReplaceInProviders(NewProvider);
    }
    else if(MemberPropertyName == GET_MEMBER_NAME_CHECKED(UHIVEConfigCommonSettings, ProviderQQ))
    {
        tinyxml2::XMLElement* NewProvider = ConfigFile.NewElement("qq");
        NewProvider->SetAttribute("id", TCHAR_TO_UTF8(*(ProviderQQ.ID)));
        
        AddOrReplaceInProviders(NewProvider);
    }
    else if(MemberPropertyName == GET_MEMBER_NAME_CHECKED(UHIVEConfigCommonSettings, ProviderVK))
    {
        tinyxml2::XMLElement* NewProvider = ConfigFile.NewElement("vk");
        NewProvider->SetAttribute("appId", TCHAR_TO_UTF8(*(ProviderVK.AppId)));
        
        AddOrReplaceInProviders(NewProvider);
    }
    else if(MemberPropertyName == GET_MEMBER_NAME_CHECKED(UHIVEConfigCommonSettings, ProviderLine))
    {
        tinyxml2::XMLElement* NewProvider = ConfigFile.NewElement("line");
        NewProvider->SetAttribute("channelId", TCHAR_TO_UTF8(*(ProviderLine.ChannelID)));
        
        AddOrReplaceInProviders(NewProvider);
    }
    else if(MemberPropertyName == GET_MEMBER_NAME_CHECKED(UHIVEConfigCommonSettings, ProviderWeverse))
    {
        tinyxml2::XMLElement* NewProvider = ConfigFile.NewElement("weverse");
        NewProvider->SetAttribute("clientId", TCHAR_TO_UTF8(*(ProviderWeverse.ClientID)));
        
        AddOrReplaceInProviders(NewProvider);
    }
    else if(MemberPropertyName == GET_MEMBER_NAME_CHECKED(UHIVEConfigCommonSettings, ProviderSignInWithApple))
    {
        tinyxml2::XMLElement* NewProvider = ConfigFile.NewElement("signinwithapple");
        NewProvider->SetAttribute("serviceid", TCHAR_TO_UTF8(*(ProviderSignInWithApple.ServiceID)));
        
        AddOrReplaceInProviders(NewProvider);
    }
    else if (MemberPropertyName == GET_MEMBER_NAME_CHECKED(UHIVEConfigCommonSettings, ProviderTelegram))
    {
        tinyxml2::XMLElement* NewProvider = ConfigFile.NewElement("telegram");
        NewProvider->SetAttribute("botId", TCHAR_TO_UTF8(*(ProviderTelegram.BotID)));
        NewProvider->SetAttribute("botDomain", TCHAR_TO_UTF8(*(ProviderTelegram.BotDomain)));

        AddOrReplaceInProviders(NewProvider);
    }
    else if(MemberPropertyName == GET_MEMBER_NAME_CHECKED(UHIVEConfigCommonSettings, ProviderSteam))
    {
        tinyxml2::XMLElement* NewProvider = ConfigFile.NewElement("steam");
        NewProvider->SetAttribute("realm", TCHAR_TO_UTF8(*(ProviderSteam.Realm)));

        AddOrReplaceInProviders(NewProvider);
    } 
    else if(MemberPropertyName == GET_MEMBER_NAME_CHECKED(UHIVEConfigCommonSettings, ProviderX))
    {
        tinyxml2::XMLElement* NewProvider = ConfigFile.NewElement("x");
        NewProvider->SetAttribute("clientId", TCHAR_TO_UTF8(*(ProviderX.ClientId)));

        AddOrReplaceInProviders(NewProvider);
    }
    else if(MemberPropertyName == GET_MEMBER_NAME_CHECKED(UHIVEConfigCommonSettings, ProviderAdjust))
    {
        tinyxml2::XMLElement* NewProvider = ConfigFile.NewElement("Adjust");
        NewProvider->SetAttribute("name", "Adjust");
        NewProvider->SetAttribute("key", TCHAR_TO_UTF8(*(ProviderAdjust.Key)));

        tinyxml2::XMLElement* NewEvents = ConfigFile.NewElement("events");
        for (const auto& Event : ProviderAdjust.Events)
        {
            tinyxml2::XMLElement* NewEvent = ConfigFile.NewElement("event");
            NewEvent->SetAttribute("name", TCHAR_TO_UTF8(*(Event.EventName)));
            NewEvent->SetAttribute("value", TCHAR_TO_UTF8(*(Event.EventValue)));
            NewEvents->InsertEndChild(NewEvent);
        }

        NewProvider->InsertEndChild(NewEvents);
        AddOrReplaceInProviders(NewProvider);
    }
    else if(MemberPropertyName == GET_MEMBER_NAME_CHECKED(UHIVEConfigCommonSettings, ProviderSingular))
    {
        tinyxml2::XMLElement* NewProvider = ConfigFile.NewElement("Singular");
        NewProvider->SetAttribute("name", "Singular");
        NewProvider->SetAttribute("id", TCHAR_TO_UTF8(*(ProviderSingular.ID)));
        NewProvider->SetAttribute("key", TCHAR_TO_UTF8(*(ProviderSingular.Key)));

        tinyxml2::XMLElement* NewEvents = ConfigFile.NewElement("events");
        for (const auto& Event : ProviderSingular.Events)
        {
            tinyxml2::XMLElement* NewEvent = ConfigFile.NewElement("event");
            NewEvent->SetAttribute("name", TCHAR_TO_UTF8(*(Event.EventName)));
            NewEvent->SetAttribute("value", TCHAR_TO_UTF8(*(Event.EventValue)));
            NewEvents->InsertEndChild(NewEvent);
        }

        NewProvider->InsertEndChild(NewEvents);
        AddOrReplaceInProviders(NewProvider);
    }
    else if(MemberPropertyName == GET_MEMBER_NAME_CHECKED(UHIVEConfigCommonSettings, ProviderAppsFlyer))
    {
        tinyxml2::XMLElement* NewProvider = ConfigFile.NewElement("AppsFlyer");
        NewProvider->SetAttribute("name", "AppsFlyer");
        NewProvider->SetAttribute("id", TCHAR_TO_UTF8(*(ProviderAppsFlyer.ID)));
        NewProvider->SetAttribute("key", TCHAR_TO_UTF8(*(ProviderAppsFlyer.Key)));
        NewProvider->SetAttribute("itunesConnectAppId", TCHAR_TO_UTF8(*(ProviderAppsFlyer.ItunesConnectAppId)));

        tinyxml2::XMLElement* NewEvents = ConfigFile.NewElement("events");
        for (const auto& Event : ProviderAppsFlyer.Events)
        {
            tinyxml2::XMLElement* NewEvent = ConfigFile.NewElement("event");
            NewEvent->SetAttribute("name", TCHAR_TO_UTF8(*(Event.EventName)));
            NewEvent->SetAttribute("value", TCHAR_TO_UTF8(*(Event.EventValue)));
            NewEvents->InsertEndChild(NewEvent);
        }

        NewProvider->InsertEndChild(NewEvents);
        AddOrReplaceInProviders(NewProvider);
    }
    else if(MemberPropertyName == GET_MEMBER_NAME_CHECKED(UHIVEConfigCommonSettings, ProviderFirebase))
    {
        tinyxml2::XMLElement* NewProvider = ConfigFile.NewElement("Firebase");
        NewProvider->SetAttribute("name", "Firebase");
        NewProvider->SetAttribute("id", TCHAR_TO_UTF8(*(ProviderFirebase.ID)));
        NewProvider->SetAttribute("key", TCHAR_TO_UTF8(*(ProviderFirebase.Key)));

        tinyxml2::XMLElement* NewEvents = ConfigFile.NewElement("events");
        for (const auto& Event : ProviderFirebase.Events)
        {
            tinyxml2::XMLElement* NewEvent = ConfigFile.NewElement("event");
            NewEvent->SetAttribute("name", TCHAR_TO_UTF8(*(Event.EventName)));
            NewEvent->SetAttribute("value", TCHAR_TO_UTF8(*(Event.EventValue)));
            NewEvents->InsertEndChild(NewEvent);
        }

        NewProvider->InsertEndChild(NewEvents);
        AddOrReplaceInProviders(NewProvider);
    }
    else if(MemberPropertyName == GET_MEMBER_NAME_CHECKED(UHIVEConfigCommonSettings, ProviderAirbridge))
    {
        tinyxml2::XMLElement* NewProvider = ConfigFile.NewElement("Airbridge");
        NewProvider->SetAttribute("name", "Airbridge");
        NewProvider->SetAttribute("id", TCHAR_TO_UTF8(*(ProviderAirbridge.ID)));
        NewProvider->SetAttribute("key", TCHAR_TO_UTF8(*(ProviderAirbridge.Key)));
        NewProvider->SetAttribute("appName", TCHAR_TO_UTF8(*(ProviderAirbridge.AppName)));
        NewProvider->SetAttribute("secretId", TCHAR_TO_UTF8(*(ProviderAirbridge.SecretId)));
        NewProvider->SetAttribute("secret", TCHAR_TO_UTF8(*(ProviderAirbridge.Secret)));

        tinyxml2::XMLElement* NewEvents = ConfigFile.NewElement("events");
        for (const auto& Event : ProviderAirbridge.Events)
        {
            tinyxml2::XMLElement* NewEvent = ConfigFile.NewElement("event");
            NewEvent->SetAttribute("name", TCHAR_TO_UTF8(*(Event.EventName)));
            NewEvent->SetAttribute("value", TCHAR_TO_UTF8(*(Event.EventValue)));
            NewEvents->InsertEndChild(NewEvent);
        }

        NewProvider->InsertEndChild(NewEvents);
        AddOrReplaceInProviders(NewProvider);
    }
    
    ConfigFile.SaveFile(TCHAR_TO_UTF8(*absoluteConfigPath));

    Super::PostEditChangeProperty(PropertyChangedEvent);
}

const char* UHIVEConfigCommonSettings::GetBaseXmlChar()
{
    return "<?xml version=\"1.0\" encoding=\"UTF-8\"?>"
           "<properties>"
           "</properties>";
}

void UHIVEConfigCommonSettings::AddOrReplaceElement(FString key, FString value)
{
    tinyxml2::XMLElement * ChildNode = RootNode->FirstChildElement(TCHAR_TO_UTF8(*key));
    if(value.IsEmpty())
    {
        if(ChildNode != NULL)
        {
            RootNode->DeleteChild(ChildNode);
        }
    }
    else
    {
        if(ChildNode != NULL)
        {
            ChildNode->SetText(TCHAR_TO_UTF8(*value));
        }
        else
        {
            tinyxml2::XMLElement * NewElement = ConfigFile.NewElement(TCHAR_TO_UTF8(*key));
            NewElement->SetText(TCHAR_TO_UTF8(*value));
            RootNode->InsertEndChild(NewElement);
        }
    }
}

void UHIVEConfigCommonSettings::AddOrReplaceInProviders(tinyxml2::XMLElement* Provider)
{
    tinyxml2::XMLElement* Providers = RootNode->FirstChildElement("providers");

    if (Providers == NULL)
    {
        tinyxml2::XMLElement* NewProviders = ConfigFile.NewElement("providers");
        NewProviders->InsertEndChild(Provider);
        RootNode->InsertEndChild(NewProviders);
    }
    else
    {
        tinyxml2::XMLElement* BeforeProvider = Providers->FirstChildElement(Provider->Name());
        if (BeforeProvider != NULL)
        {
            Providers->DeleteChild(BeforeProvider);
        }
        Providers->InsertEndChild(Provider);
    }
}