// Copyright 1998-2016 Epic Games, Inc. All Rights Reserved.

using UnrealBuildTool;

using System.Collections.Generic;
using System.IO;
using System;
using System.Linq;
using System.Text;

#if UE_5_0_OR_LATER
using EpicGames.Core;
#else
using Tools.DotNETCommon;
#endif

public class HIVESDK : ModuleRules
{
	public HIVESDK(ReadOnlyTargetRules Target) : base(Target)
	{
		System.Console.WriteLine("Module Type : " + Type);
		
		// UE 5.6 호환성을 위한 필수 설정
		PCHUsage = ModuleRules.PCHUsageMode.UseExplicitOrSharedPCHs;
		
		// Add search path
		PublicIncludePaths.AddRange(
			new string[] {
				"Runtime/Launch/Public",

				ModuleDirectory + "/Public",                // Plugins/HIVESDK/Source/HIVESDK/Public
				ModuleDirectory + "/Public/CPP",
			}
		);

		PrivateIncludePaths.AddRange(
			new string[] {
				ModuleDirectory + "/Private",
			}
		);

		PublicDependencyModuleNames.AddRange(
			new string[] {
				"Core",             // for argument
				"CoreUObject",
				"Json",
				"JsonUtilities",
				"ApplicationCore",
			}
		);
		
		if (Target.Platform == UnrealTargetPlatform.Win64)
		{

			PublicDependencyModuleNames.AddRange(
			new string[]
			{
				"Core",
				"Projects"
				// ... add other public dependencies that you statically link with here ...
			}
			);
			PrivateDependencyModuleNames.AddRange(
			new string[]
			{
				// ... add private dependencies that you statically link with here ...
				"Core",
				"CoreUObject",
				"Engine",
				"InputCore",
				"Slate", "SlateCore", "Json", "JsonUtilities"
				//"UnrealEd"
			}
			);
			
		}
		
	}
}