#ifdef _WIN32 //|| _WIN64
#define USE_HIVE_EMPTY_SYMBOLS 1
#elif defined(__APPLE__)
//    #include "TargetConditionals.h"
	#if TARGET_OS_MAC && (PLATFORM_ANDROID && !PLATFORM_IOS)
         #define USE_HIVE_EMPTY_SYMBOLS 1
    #endif
    #if PLATFORM_MAC
        #define USE_HIVE_EMPTY_SYMBOLS 1
    #endif
#endif

#if defined(USE_HIVE_EMPTY_SYMBOLS)

#include "CPP/HIVE_CppPlugin.h"
#include "CPP/HIVE_Analytics.h"
#include "CPP/HIVE_Configuration.h"
//#include "HIVE_JniHelper.h"
#include "CPP/HIVE_Logger.h"
#include "CPP/HIVE_PlatformHelper.h"
#include "CPP/HIVE_Promotion.h"
#include "CPP/HIVE_Push.h"
#include "CPP/HIVE_ResultAPI.h"
#include "CPP/HIVE_SocialFacebook.h"
#include "CPP/HIVE_SocialGoogle.h"
#include "CPP/HIVE_SocialHive.h"
#include "CPP/picojson.h"
#include <string>
#include "CPP/HIVE_AuthV4.h"
#include "CPP/HIVE_IAPV4.h"
#include "CPP/HIVE_ProviderApple.h"
#include "CPP/HIVE_ProviderGoogle.h"
#include "CPP/HIVE_PermissionView.h"
#include "CPP/HIVE_SocialV4.h"
#include "CPP/HIVE_DataStore.h"
#include "CPP/HIVE_MatchMaking.h"
#include "CPP/HIVE_Chat.h"

NS_HIVE_BEGIN

#define HIVE_EMPTY_CONSTRUCTOR(cls) cls::cls() {}
#define HIVE_EMPTY_CONSTRUCTOR_PARAM(cls,clsparam) cls::clsparam {}
#define HIVE_EMPTY_DESTRUCTOR(cls) cls::~cls() {}
#define HIVE_EMPTY_IMPL_VOID(cls,func) void cls::func {}
#define HIVE_EMPTY_IMPL_DEFAULT(cls,func,ty) ty cls::func { return static_cast<ty>(0); }
#define HIVE_EMPTY_IMPL_CLASS(cls,func,ty) ty cls::func { ty t; return t; }
#define HIVE_EMPTY_IMPL_NULLABLE(cls,func,ty) ty cls::func { return static_cast<ty>(nullptr); }
#define HIVE_EMPTY_IMPL_STDSTRING(cls,func) std::string cls::func { return ""; }

#if WITH_EDITOR
//Analytics
HIVE_EMPTY_CONSTRUCTOR(AnalyticsAdRevenue)
HIVE_EMPTY_CONSTRUCTOR_PARAM(AnalyticsAdRevenue, AnalyticsAdRevenue(double revenue, std::string adPlatform, std::string adUnitId, std::string adType, std::string adPlacement, std::string currency))
HIVE_EMPTY_IMPL_STDSTRING(AnalyticsAdRevenue,toString() const)
HIVE_EMPTY_IMPL_DEFAULT(Analytics,sendAnalyticsLog(picojson::object & logData), bool)
HIVE_EMPTY_IMPL_VOID(Analytics,setEnableTracker(TrackingType trackingType, bool isEnable))
HIVE_EMPTY_IMPL_VOID(Analytics,setEnableTrackerWithName(std::string name, bool isEnable))

HIVE_EMPTY_IMPL_VOID(Analytics,sendEvent(std::string eventName))
HIVE_EMPTY_IMPL_VOID(Analytics,sendEventWithAttributes(std::string eventName, AnalyticsAttributes const& attributes))
HIVE_EMPTY_IMPL_VOID(Analytics,sendAdRevenueEvent(AnalyticsAdRevenue analyticsAdRevenue))
HIVE_EMPTY_IMPL_VOID(Analytics,sendUserEntryFunnelsLogs(std::string funnelTrack, std::string optionTag))
HIVE_EMPTY_IMPL_VOID(Analytics,executeEngine(picojson::value jsonParam))
HIVE_EMPTY_IMPL_VOID(Analytics,setConsent(std::string providerName,std::map<std::string, std::string> settings))
std::map<std::string, std::string> Analytics::getConsent(std::string providerName) {std::map<std::string, std::string> t; return t;}
HIVE_EMPTY_IMPL_VOID(Analytics,showConsentModeIfRequire(bool checkCmp, ConsentMode* consentMode, onShowConsentMode listener))
HIVE_EMPTY_IMPL_VOID(Analytics,showConsentMode(ConsentMode* consentMode, onShowConsentMode listener))
//Analytics - ConsentStatus
HIVE_EMPTY_CONSTRUCTOR(ConsentStatus)
HIVE_EMPTY_CONSTRUCTOR_PARAM(ConsentStatus, ConsentStatus(picojson::value jsonParam))
HIVE_EMPTY_IMPL_CLASS(ConsentStatus,toJson() const,picojson::object)
HIVE_EMPTY_IMPL_STDSTRING(ConsentStatus,toString() const)
//Analytics - ConsentForm
HIVE_EMPTY_CONSTRUCTOR(ConsentForm)
HIVE_EMPTY_CONSTRUCTOR_PARAM(ConsentForm, ConsentForm(picojson::value jsonParam))
HIVE_EMPTY_IMPL_CLASS(ConsentForm,toJson() const,picojson::object)
HIVE_EMPTY_IMPL_STDSTRING(ConsentForm,toString() const)
//Analytics - ConsentMode
HIVE_EMPTY_CONSTRUCTOR(ConsentMode)
HIVE_EMPTY_CONSTRUCTOR_PARAM(ConsentMode, ConsentMode(picojson::value jsonParam))
ConsentMode::~ConsentMode() {}
HIVE_EMPTY_IMPL_CLASS(ConsentMode,toJson() const,picojson::object)
HIVE_EMPTY_IMPL_STDSTRING(ConsentMode,toString() const)
//Analytics - AnalyticsAttributes
HIVE_EMPTY_CONSTRUCTOR(AnalyticsAttributes)
HIVE_EMPTY_IMPL_VOID(AnalyticsAttributes, addCustomAttribute(const std::string& key, const picojson::value& value))
HIVE_EMPTY_IMPL_VOID(AnalyticsAttributes, addModuleSpecificAttribute(const IAnalyticsSpecific& specific))
HIVE_EMPTY_IMPL_CLASS(AnalyticsAttributes, toJson() const, picojson::object)
HIVE_EMPTY_IMPL_STDSTRING(AnalyticsAttributes, toString() const)

HIVE_EMPTY_CONSTRUCTOR(IAnalyticsSpecific)
HIVE_EMPTY_IMPL_CLASS(IAnalyticsSpecific, toJson() const, picojson::object)
HIVE_EMPTY_IMPL_STDSTRING(IAnalyticsSpecific, toString() const)

HIVE_EMPTY_CONSTRUCTOR(AirbridgeSpecific)
HIVE_EMPTY_IMPL_VOID(AirbridgeSpecific, setSemanticAction(const std::string& value))
HIVE_EMPTY_IMPL_VOID(AirbridgeSpecific, setSemanticLabel(const std::string& value))
HIVE_EMPTY_IMPL_VOID(AirbridgeSpecific, setSemanticValue(const double value))
HIVE_EMPTY_IMPL_VOID(AirbridgeSpecific, addSemanticAttribute(const std::string& key, const picojson::value& value))
HIVE_EMPTY_IMPL_CLASS(AirbridgeSpecific, toJson() const, picojson::object)
HIVE_EMPTY_IMPL_STDSTRING(AirbridgeSpecific, toString() const)

HIVE_EMPTY_IMPL_CLASS(Configuration,getPermissionViewData(HIVELanguage language),PermissionViewData)
HIVE_EMPTY_IMPL_VOID(Configuration,setHivePermissionViewOn(bool isOn))
HIVE_EMPTY_IMPL_VOID(Configuration,setAgeGateU13(bool ageGateU13))
HIVE_EMPTY_IMPL_STDSTRING(Configuration,getConfiguration())
HIVE_EMPTY_IMPL_STDSTRING(Configuration,getHiveSDKVersion())
HIVE_EMPTY_IMPL_STDSTRING(Configuration,getHiveTimeZone())
HIVE_EMPTY_IMPL_STDSTRING(Configuration,getHiveCountry())
HIVE_EMPTY_IMPL_STDSTRING(Configuration,getReferenceSDKVersion())
HIVE_EMPTY_IMPL_STDSTRING(Configuration,getAppId())
HIVE_EMPTY_IMPL_VOID(Configuration,setAppId(std::string appId))
HIVE_EMPTY_IMPL_STDSTRING(Configuration,getHiveCertificationKey())
HIVE_EMPTY_IMPL_VOID(Configuration,setHiveCertificationKey(std::string appKey))
HIVE_EMPTY_IMPL_DEFAULT(Configuration,getZone(),ZoneType)
HIVE_EMPTY_IMPL_VOID(Configuration,setZone(ZoneType zone))
HIVE_EMPTY_IMPL_VOID(Configuration, setTestZone())
HIVE_EMPTY_IMPL_DEFAULT(Configuration, isTestZone(), bool)
HIVE_EMPTY_IMPL_STDSTRING(Configuration,getServerId())
HIVE_EMPTY_IMPL_VOID(Configuration,setServerId(std::string serverId))
HIVE_EMPTY_IMPL_VOID(Configuration,updateServerId(std::string serverId))
HIVE_EMPTY_IMPL_STDSTRING(Configuration,getGameLanguage())
HIVE_EMPTY_IMPL_VOID(Configuration,setGameLanguage(std::string language))
HIVE_EMPTY_IMPL_VOID(Configuration,updateGameLanguage(std::string language))
HIVE_EMPTY_IMPL_DEFAULT(Configuration,getUseLog(),bool)
HIVE_EMPTY_IMPL_VOID(Configuration,setUseLog(bool useLog))
HIVE_EMPTY_IMPL_STDSTRING(Configuration,getCompany())
HIVE_EMPTY_IMPL_VOID(Configuration,setCompany(std::string company))
HIVE_EMPTY_IMPL_STDSTRING(Configuration, getCompanyIndex())
HIVE_EMPTY_IMPL_VOID(Configuration, setCompanyIndex(int companyIndex))
HIVE_EMPTY_IMPL_STDSTRING(Configuration,getChannel())
HIVE_EMPTY_IMPL_VOID(Configuration,setChannel(std::string channel))
HIVE_EMPTY_IMPL_DEFAULT(Configuration,getHttpConnectTimeout(),int)
HIVE_EMPTY_IMPL_VOID(Configuration,setHttpConnectTimeout(int httpConnectTimeout))
HIVE_EMPTY_IMPL_DEFAULT(Configuration,getHttpReadTimeout(),int)
HIVE_EMPTY_IMPL_VOID(Configuration,setHttpReadTimeout(int httpReadTimeout))
HIVE_EMPTY_IMPL_DEFAULT(Configuration,getMaxGameLogSize(),int)
HIVE_EMPTY_IMPL_VOID(Configuration,setMaxGameLogSize(int maxGameLogSize))
HIVE_EMPTY_IMPL_STDSTRING(Configuration,getMarket())
HIVE_EMPTY_IMPL_VOID(Configuration,setMarket(std::string market))
HIVE_EMPTY_IMPL_DEFAULT(Configuration,getAnalyticsSendLimit(),unsigned int)
HIVE_EMPTY_IMPL_VOID(Configuration,setAnalyticsSendLimit(unsigned int limit))
HIVE_EMPTY_IMPL_DEFAULT(Configuration,getAnalyticsQueueLimit(),unsigned int)
HIVE_EMPTY_IMPL_VOID(Configuration,setAnalyticsQueueLimit(unsigned int limit))
HIVE_EMPTY_IMPL_DEFAULT(Configuration,getAnalyticsSendCycleSeconds(),float)
HIVE_EMPTY_IMPL_VOID(Configuration,setAnalyticsSendCycleSeconds(float seconds))
HIVE_EMPTY_IMPL_DEFAULT(Configuration,getHiveTheme(),HiveThemeType)
HIVE_EMPTY_IMPL_DEFAULT(Configuration,getAgeGateU13(),bool)
HIVE_EMPTY_IMPL_VOID(Configuration,executeEngine(picojson::value jsonParam))
HIVE_EMPTY_IMPL_VOID(Configuration,setHiveTheme(HiveThemeType theme))
HIVE_EMPTY_IMPL_VOID(Configuration,setHiveOrientation(std::string orientation))
HIVE_EMPTY_IMPL_VOID(Configuration,setConfigurations(HiveConfigType configType,std::string value))
HIVE_EMPTY_IMPL_VOID(Configuration,getMetaData(std::string key, bool forceReload, onGetMetaData listener))
HIVE_EMPTY_IMPL_VOID(Configuration,setUseHercules(bool enable))
HIVE_EMPTY_IMPL_DEFAULT(Configuration,getAgeGateU16Agree(),bool)
HIVE_EMPTY_IMPL_DEFAULT(Configuration,getLegalGuardianConsentAgree(),bool)
HIVE_EMPTY_IMPL_DEFAULT(Configuration, getCrossPromotionBannerShowing(),bool)
HIVE_EMPTY_IMPL_VOID(Configuration, setCrossPromotionBannerShowing(bool expose))
HIVE_EMPTY_IMPL_DEFAULT(Configuration, getEnableGameController(), bool)
HIVE_EMPTY_IMPL_VOID(Configuration, setEnableGameController(bool enable))
HIVE_EMPTY_IMPL_DEFAULT(Configuration, getChatConnectionTimeout(), int)
HIVE_EMPTY_IMPL_VOID(Configuration, setChatConnectionTimeout(int time))
HIVE_EMPTY_IMPL_VOID(Configuration, setUsePrivateBrowsingForAuth(bool use))
HIVE_EMPTY_IMPL_VOID(Configuration,setHiveCommunityUrl(std::string url))
#endif


//cpp
//HIVE_EMPTY_IMPL_CLASS(HiveCppPlugin,createParam(std::string className, std::string methodName),picojson::object)
//HIVE_EMPTY_IMPL_NULLABLE(HiveCppPlugin,callNative(picojson::object jsonParam),picojson::value)
//HIVE_EMPTY_IMPL_VOID(HiveCppPlugin,callEngine(std::string jsonParamString))

//Logger
HIVE_EMPTY_IMPL_DEFAULT(Logger,isActivateLogging(),bool)
HIVE_EMPTY_IMPL_VOID(Logger,setLoggerListener(onLogger listener))
HIVE_EMPTY_IMPL_VOID(Logger,log(const char * format, ...))
HIVE_EMPTY_IMPL_VOID(Logger,setLogFilter(LogFilter filter))

HIVE_EMPTY_CONSTRUCTOR(LogFilter)
#if WITH_EDITOR
//PlatformHelper
HIVE_EMPTY_IMPL_VOID(PlatformHelper,executeEngine(picojson::value jsonParam))
HIVE_EMPTY_IMPL_VOID(PlatformHelper,requestUserPermissions(std::vector<std::string> requests, onRequestUserPermissionsHandler handler))
HIVE_EMPTY_IMPL_VOID(PlatformHelper,share(PlatformShare platformShare, onHIVEPlatformHelperShareHandler handler))
HIVE_EMPTY_IMPL_VOID(PlatformHelper,completeUpdate(int completeState))
HIVE_EMPTY_IMPL_VOID(PlatformHelper,showInAppBrowser(InAppBrowserParam param, onShowInAppBrowserHandler handler))
HIVE_EMPTY_IMPL_VOID(PlatformHelper,showInAppWebView(InAppWebViewParam param, onShowInAppWebViewHandler handler))
HIVE_EMPTY_IMPL_VOID(PlatformHelper, getLaunchParameters(onParameters handler))

HIVE_EMPTY_IMPL_VOID(PlatformHelper, openBrowser(const OpenBrowserParam param))
HIVE_EMPTY_CONSTRUCTOR_PARAM(OpenBrowserParam, OpenBrowserParam(const std::string& url))

//PlatformShare
HIVE_EMPTY_CONSTRUCTOR(PlatformShare)
HIVE_EMPTY_IMPL_DEFAULT(PlatformShare,getShareTypeInt(),int)
HIVE_EMPTY_IMPL_VOID(PlatformShare,setShareType(PlatformShareType argShareType))
HIVE_EMPTY_IMPL_CLASS(PlatformShare,getSubject(),std::string)
HIVE_EMPTY_IMPL_VOID(PlatformShare,setSubject(std::string argSubject))
HIVE_EMPTY_IMPL_CLASS(PlatformShare,getText(),std::string)
HIVE_EMPTY_IMPL_VOID(PlatformShare,setText(std::string argText))
HIVE_EMPTY_IMPL_CLASS(PlatformShare,getMedia(),std::vector<std::string>)
HIVE_EMPTY_IMPL_VOID(PlatformShare,setMedia(std::vector<std::string> argPaths))
PlatformShare::~PlatformShare() {}

//InAppBrowserParam
HIVE_EMPTY_CONSTRUCTOR_PARAM(InAppBrowserParam, InAppBrowserParam(std::string url))
HIVE_EMPTY_CONSTRUCTOR_PARAM(InAppBrowserParam, InAppBrowserParam(picojson::value jsonParam))

HIVE_EMPTY_CONSTRUCTOR_PARAM(InAppWebViewParam, InAppWebViewParam(std::string url))
HIVE_EMPTY_CONSTRUCTOR_PARAM(InAppWebViewParam, InAppWebViewParam(picojson::value jsonParam))

//Promotion
HIVE_EMPTY_IMPL_VOID(Promotion,showPromotion(PromotionType promotionType, bool isForced, onPromotionView listener))
HIVE_EMPTY_IMPL_VOID(Promotion,showCustomContents(PromotionCustomType customType, std::string contentsKey, onPromotionView listener))
HIVE_EMPTY_IMPL_VOID(Promotion,showCustomContentsOnGameWindow(PromotionCustomType customType, std::string contentsKey, onPromotionView listener))
HIVE_EMPTY_IMPL_VOID(Promotion,showNews(std::string menu, std::vector<int> giftPidList, onPromotionView listener))
HIVE_EMPTY_IMPL_DEFAULT(Promotion,getOfferwallState(),OfferwallState)
HIVE_EMPTY_IMPL_VOID(Promotion,showOfferwall(onPromotionView listener))
HIVE_EMPTY_IMPL_VOID(Promotion,showExit(onPromotionView listener))
HIVE_EMPTY_IMPL_VOID(Promotion,getViewInfo(PromotionCustomType customType, std::string contentsKey, onPromotionViewInfo listener))
HIVE_EMPTY_IMPL_VOID(Promotion,getBadgeInfo(onPromotionBadgeInfo listener))
HIVE_EMPTY_IMPL_VOID(Promotion,getAppInvitationData(onAppInvitationData listener))
HIVE_EMPTY_IMPL_VOID(Promotion,setAdditionalInfo(std::string additionalInfo))
HIVE_EMPTY_IMPL_VOID(Promotion,showNativeReview(onPromotionView listener))
HIVE_EMPTY_IMPL_VOID(Promotion,showReview(onPromotionView listener))
HIVE_EMPTY_IMPL_VOID(Promotion,executeEngine(picojson::value jsonParam))
HIVE_EMPTY_IMPL_CLASS(Promotion,setEngagementReady(bool isReady),ResultAPI)
HIVE_EMPTY_IMPL_VOID(Promotion,setEngagementHandler(onEngagement engagementHandler))
HIVE_EMPTY_IMPL_VOID(Promotion,showUAShare(std::string inviteMessage, std::string inviteLink, onPromotionUAShare engagementHandler))
HIVE_EMPTY_IMPL_VOID(Promotion,getBannerInfo(PromotionCampaignType campaignType, PromotionBannerType bannerType, onPromotionBannerInfo linstener))
HIVE_EMPTY_IMPL_VOID(Promotion,getBannerInfoString(std::string campaignString, std::string bannerString, onPromotionBannerInfo linstener))
HIVE_EMPTY_IMPL_DEFAULT(Promotion,processURI(std::string uri),bool)
HIVE_EMPTY_IMPL_VOID(Promotion,updatePromotionData())
HIVE_EMPTY_IMPL_VOID(Promotion,getAppInvitationSenderInfo(onAppInvitationSenderInfo appInvitationSenderInfoHandler))

//PromotionViewInfo
HIVE_EMPTY_CONSTRUCTOR(PromotionViewInfo)
HIVE_EMPTY_IMPL_DEFAULT(PromotionViewInfo,parse(picojson::value jsonParam),bool)
HIVE_EMPTY_IMPL_CLASS(PromotionViewInfo,toJson() const,picojson::object)
HIVE_EMPTY_IMPL_STDSTRING(PromotionViewInfo,toString() const)

//PromotionBadgeInfo
HIVE_EMPTY_CONSTRUCTOR(PromotionBadgeInfo)
HIVE_EMPTY_IMPL_DEFAULT(PromotionBadgeInfo,parse(picojson::value jsonParam),bool)
HIVE_EMPTY_IMPL_CLASS(PromotionBadgeInfo,toJson() const,picojson::object)
HIVE_EMPTY_IMPL_STDSTRING(PromotionBadgeInfo,toString() const)

HIVE_EMPTY_CONSTRUCTOR(PromotionBannerInfo)
HIVE_EMPTY_IMPL_DEFAULT(PromotionBannerInfo,parse(picojson::value jsonParam),bool)
HIVE_EMPTY_IMPL_CLASS(PromotionBannerInfo,toJson() const,picojson::object)
HIVE_EMPTY_IMPL_STDSTRING(PromotionBannerInfo,toString() const)

//OfferwallReward
//HIVE_EMPTY_CONSTRUCTOR(OfferwallReward)
//HIVE_EMPTY_IMPL_DEFAULT(OfferwallReward,parse(picojson::value jsonParam),bool)
//HIVE_EMPTY_IMPL_CLASS(OfferwallReward,toJson() const,picojson::object)
//HIVE_EMPTY_IMPL_STDSTRING(OfferwallReward,toString() const)

//AppInvitationData
HIVE_EMPTY_CONSTRUCTOR(AppInvitationData)
HIVE_EMPTY_IMPL_DEFAULT(AppInvitationData,parse(picojson::value jsonParam),bool)
HIVE_EMPTY_IMPL_CLASS(AppInvitationData,toJson() const,picojson::object)
HIVE_EMPTY_IMPL_STDSTRING(AppInvitationData,toString() const)

//AppInvitationCampaign
HIVE_EMPTY_CONSTRUCTOR(AppInvitationCampaign)
HIVE_EMPTY_IMPL_DEFAULT(AppInvitationCampaign,parse(picojson::value jsonParam),bool)
HIVE_EMPTY_IMPL_CLASS(AppInvitationCampaign,toJson() const,picojson::object)
HIVE_EMPTY_IMPL_STDSTRING(AppInvitationCampaign,toString() const)

//AppInvitationCampaign
HIVE_EMPTY_CONSTRUCTOR(AppInvitationCampaignStage)
HIVE_EMPTY_IMPL_DEFAULT(AppInvitationCampaignStage,parse(picojson::value jsonParam),bool)
#endif

//Push
HIVE_EMPTY_IMPL_VOID(Push,getRemotePush(onRemotePush listener))
HIVE_EMPTY_IMPL_VOID(Push,setRemotePush(RemotePush remotePush, onRemotePush listener))
HIVE_EMPTY_IMPL_VOID(Push,registerLocalPush(LocalPush localPush, onLocalPush listener))
HIVE_EMPTY_IMPL_VOID(Push,unregisterLocalPush(int noticeId))
HIVE_EMPTY_IMPL_VOID(Push,unregisterLocalPushes(std::vector<int>))
HIVE_EMPTY_IMPL_VOID(Push,unregisterAllLocalPushes())
HIVE_EMPTY_IMPL_VOID(Push,getForegroundPush(onPushSetting listener))
HIVE_EMPTY_IMPL_VOID(Push,setForegroundPush(PushSetting setting, onPushSetting listener))
HIVE_EMPTY_IMPL_VOID(Push,requestPushPermission())
HIVE_EMPTY_IMPL_VOID(Push,executeEngine(picojson::value jsonParam))

//RemotePush
HIVE_EMPTY_CONSTRUCTOR(RemotePush)
HIVE_EMPTY_CONSTRUCTOR_PARAM(RemotePush,RemotePush(bool isAgreeNotice, bool isAgreeNight))
HIVE_EMPTY_CONSTRUCTOR_PARAM(RemotePush,RemotePush(picojson::value jsonParam))
HIVE_EMPTY_IMPL_CLASS(RemotePush,toJson() const,picojson::object)
HIVE_EMPTY_IMPL_STDSTRING(RemotePush,toString() const)

//LocalPush
HIVE_EMPTY_CONSTRUCTOR(LocalPush)
HIVE_EMPTY_CONSTRUCTOR_PARAM(LocalPush,LocalPush(int noticeID, std::string title, std::string msg, long after))
HIVE_EMPTY_CONSTRUCTOR_PARAM(LocalPush,LocalPush(picojson::value jsonParam))
HIVE_EMPTY_IMPL_CLASS(LocalPush,toJson() const,picojson::object)
HIVE_EMPTY_IMPL_STDSTRING(LocalPush,toString() const)

//PushSetting
HIVE_EMPTY_CONSTRUCTOR(PushSetting)
HIVE_EMPTY_CONSTRUCTOR_PARAM(PushSetting,PushSetting(bool useForegroundRemotePush, bool useForegroundLocalPush))
HIVE_EMPTY_CONSTRUCTOR_PARAM(PushSetting,PushSetting(picojson::value jsonParam))
HIVE_EMPTY_IMPL_CLASS(PushSetting,toJson() const,picojson::object)
HIVE_EMPTY_IMPL_STDSTRING(PushSetting,toString() const)

//ResultAPI
#if WITH_EDITOR
HIVE_EMPTY_CONSTRUCTOR(ResultAPI)
HIVE_EMPTY_CONSTRUCTOR_PARAM(ResultAPI,ResultAPI(int errorCode, std::string errorMessage))
HIVE_EMPTY_IMPL_DEFAULT(ResultAPI,isSuccess() const,bool)
HIVE_EMPTY_IMPL_STDSTRING(ResultAPI,toString() const)
HIVE_EMPTY_IMPL_DEFAULT(ResultAPI,needExit() const,bool)
HIVE_EMPTY_CONSTRUCTOR_PARAM(ResultAPI,ResultAPI(picojson::value jsonParam))
HIVE_EMPTY_IMPL_CLASS(ResultAPI,toJson() const,picojson::object)
#endif

//SocialFacebook
HIVE_EMPTY_IMPL_VOID(SocialFacebook, getMyProfile(onProfileFacebook listener))
HIVE_EMPTY_IMPL_VOID(SocialFacebook, getFriends(onProfileFacebook listener))
HIVE_EMPTY_IMPL_VOID(SocialFacebook, sendMessageFacebook(FacebookMessage messageContents, onSendMessageFacebook listener))
HIVE_EMPTY_IMPL_VOID(SocialFacebook, showInvitationDialog(FacebookMessage inviteContents, onShowInvitationDialogFacebook listener))
HIVE_EMPTY_IMPL_DEFAULT(SocialFacebook,isLogin(),bool)
HIVE_EMPTY_IMPL_VOID(SocialFacebook, executeEngine(picojson::value jsonParam))
HIVE_EMPTY_IMPL_VOID(SocialFacebook, postFacebookWithContentURL(std::string contentURL, onPostFacebook listener))

//ProfileFacebook
HIVE_EMPTY_CONSTRUCTOR(ProfileFacebook)
HIVE_EMPTY_CONSTRUCTOR_PARAM(ProfileFacebook,ProfileFacebook(picojson::value jsonParam))
HIVE_EMPTY_IMPL_CLASS(ProfileFacebook,toJson() const,picojson::object)
HIVE_EMPTY_IMPL_STDSTRING(ProfileFacebook,toString() const)

//FacebookMessage
HIVE_EMPTY_CONSTRUCTOR(FacebookMessage)
HIVE_EMPTY_CONSTRUCTOR_PARAM(FacebookMessage,FacebookMessage(std::vector<std::string> recipients, std::string dialogTitle, std::string message, std::string data))
HIVE_EMPTY_CONSTRUCTOR_PARAM(FacebookMessage,FacebookMessage(picojson::value jsonParam))
HIVE_EMPTY_IMPL_CLASS(FacebookMessage,toJson() const,picojson::object)
HIVE_EMPTY_IMPL_STDSTRING(FacebookMessage,toString() const)

//SocialGoogle
HIVE_EMPTY_IMPL_VOID(SocialGoogle, getMyProfile(onProfileGoogle listener))
HIVE_EMPTY_IMPL_VOID(SocialGoogle, executeEngine(picojson::value jsonParam))

//ProfileGooglePlay
SocialGoogle::HIVE_EMPTY_CONSTRUCTOR(ProfileGooglePlay)
SocialGoogle::HIVE_EMPTY_CONSTRUCTOR_PARAM(ProfileGooglePlay,ProfileGooglePlay(std::string arg_playerId, std::string arg_playerName))
SocialGoogle::HIVE_EMPTY_CONSTRUCTOR_PARAM(ProfileGooglePlay,ProfileGooglePlay(picojson::value jsonParam))
HIVE_EMPTY_IMPL_CLASS(SocialGoogle::ProfileGooglePlay,toJson() const,picojson::object)
HIVE_EMPTY_IMPL_STDSTRING(SocialGoogle::ProfileGooglePlay,toString() const)

//SocialHive
HIVE_EMPTY_IMPL_VOID(SocialHive, getMyProfile(onProfileHive listener))
HIVE_EMPTY_IMPL_VOID(SocialHive, setMyProfile(std::string displayName, onProfileHive listener))
HIVE_EMPTY_IMPL_VOID(SocialHive, getFriends(FriendType friendType, onProfileHive listener))
HIVE_EMPTY_IMPL_VOID(SocialHive, getProfiles(std::vector<std::string> vidList, onProfileHive listener))
HIVE_EMPTY_IMPL_VOID(SocialHive, getBadgeInfo(onGetBadgeInfo listener))
HIVE_EMPTY_IMPL_VOID(SocialHive, sendMessage(MessageContent messageContent, onSendMessageHive listener))
HIVE_EMPTY_IMPL_VOID(SocialHive, sendInvitationMessage(MessageContent messageContent, onSendMessageHive listener))
HIVE_EMPTY_IMPL_VOID(SocialHive, showHiveDialog(HiveDialogType hiveDialogType, std::string vid, onShowHiveDialog listener))
HIVE_EMPTY_IMPL_VOID(SocialHive, showHiveDialog(HiveDialogType hiveDialogType, std::string vid, std::string additionalInfo,  onShowHiveDialog listener))
HIVE_EMPTY_IMPL_VOID(SocialHive, executeEngine(picojson::value jsonParam))

//SocialV4
#if WITH_EDITOR
HIVE_EMPTY_IMPL_VOID(SocialV4, sharePhoto(SocialV4::ProviderType providerType, onSharePhoto listener))
HIVE_EMPTY_IMPL_VOID(SocialV4, showCommunity(SocialV4::ProviderType providerType, onShowCommunity listener))
HIVE_EMPTY_IMPL_VOID(SocialV4, showCommunity(ProviderType providerType, ViewType viewType, onShowCommunity listener))
#endif

//ProfileHive
HIVE_EMPTY_CONSTRUCTOR(ProfileHive)
HIVE_EMPTY_CONSTRUCTOR_PARAM(ProfileHive,ProfileHive(picojson::value jsonParam))
HIVE_EMPTY_IMPL_CLASS(ProfileHive,toJson() const,picojson::object)
HIVE_EMPTY_IMPL_STDSTRING(ProfileHive,toString() const)

//MessageContent
HIVE_EMPTY_CONSTRUCTOR(MessageContent)
HIVE_EMPTY_CONSTRUCTOR_PARAM(MessageContent,MessageContent(std::string vid, std::string uid, std::string message, std::string imageUrl, std::string thumbnailUrl, bool usePush))
HIVE_EMPTY_CONSTRUCTOR_PARAM(MessageContent,MessageContent(picojson::value jsonParam))
HIVE_EMPTY_IMPL_CLASS(MessageContent,toJson() const,picojson::object)
HIVE_EMPTY_IMPL_STDSTRING(MessageContent,toString() const)

//AuthV4
#if WITH_EDITOR
HIVE_EMPTY_IMPL_VOID(AuthV4,setup(onSetup setupListener))
HIVE_EMPTY_IMPL_VOID(AuthV4,signIn(ProviderType providerType, onSignIn signInListener))
HIVE_EMPTY_IMPL_VOID(AuthV4,signInWithAuthKey(std::string authKey, onSignIn signInListener))
HIVE_EMPTY_IMPL_VOID(AuthV4,signOut(onSignOut signOutListener))
HIVE_EMPTY_IMPL_VOID(AuthV4,playerDelete(onSignOut playerDeleteListener))
HIVE_EMPTY_IMPL_VOID(AuthV4,connect(ProviderType providerType, onConnect connectListener))
HIVE_EMPTY_IMPL_VOID(AuthV4,disconnect(ProviderType providerType, onDisconnect disconnectListener))
HIVE_EMPTY_IMPL_VOID(AuthV4,selectConflict(PlayerID selectedPlayerId, onSignIn signInListener))
HIVE_EMPTY_IMPL_VOID(AuthV4,checkProvider(ProviderType providerType, onCheckProvider checkProviderListener))
HIVE_EMPTY_IMPL_VOID(AuthV4,checkMaintenance(bool isShow, onMaintenance maintenanceListener))
HIVE_EMPTY_IMPL_VOID(AuthV4,checkBlacklist(bool isShow, onMaintenance maintenanceListener))
HIVE_EMPTY_IMPL_VOID(AuthV4,setProviderChangedListener(onCheckProvider checkProviderLisener))
HIVE_EMPTY_IMPL_VOID(AuthV4,showSignIn(onSignIn signInListener))
HIVE_EMPTY_IMPL_VOID(AuthV4,showConflictSelection(IConflictViewInfo const& viewInfo,onSignIn signInListener))
HIVE_EMPTY_IMPL_VOID(AuthV4,showDeviceManagement(onShowDeviceManagement showDeviceManagementListener))
HIVE_EMPTY_IMPL_VOID(AuthV4,showInquiry(onShowInquiry showInquiryListener))
HIVE_EMPTY_IMPL_VOID(AuthV4,showMyInquiry(onShowMyInquiry showInquiryListener))
HIVE_EMPTY_IMPL_VOID(AuthV4,showChatbotInquiry(std::string additionalInfo, onShowChatbotInquiry showChatbotInquiryListener))
HIVE_EMPTY_IMPL_VOID(AuthV4,showTerms(onShowTerms showTermsListener))
HIVE_EMPTY_IMPL_VOID(AuthV4,resetAgreement())
HIVE_EMPTY_IMPL_VOID(AuthV4,showAdultConfirm(onAdultConfirm adultConfirmListener))
HIVE_EMPTY_IMPL_VOID(AuthV4,showProfile(PlayerID playerId, onShowProfile showProfileListener))
HIVE_EMPTY_IMPL_DEFAULT(AuthV4,isAutoSignIn(),bool)
HIVE_EMPTY_IMPL_VOID(AuthV4,getProviderFriendsList(ProviderType providerType, onGetProviderFriendsList getProviderFriendsListListener))
HIVE_EMPTY_IMPL_VOID(AuthV4,resolveConflict(onResolveConflict resolveConflictListener))
HIVE_EMPTY_IMPL_VOID(AuthV4,showGameCenterLoginCancelDialog(onAuthV4DialogDismiss listener))
HIVE_EMPTY_IMPL_VOID(AuthV4,requestPermissionViewData(onAuthV4RequestPermissionViewData listener))
HIVE_EMPTY_IMPL_DEFAULT(AuthV4,getAgeGateU13(),bool)
HIVE_EMPTY_IMPL_VOID(AuthV4, connectWithAuthKey(std::string authKey, onConnect connectListener))
HIVE_EMPTY_IMPL_VOID(AuthV4, disconnectWithName(std::string providerName, onDisconnect disconnectListener))
HIVE_EMPTY_IMPL_VOID(AuthV4, getHiveTalkPlusLoginToken(onGetHiveTalkPlusLoginToken getHiveTalkPlusLoginTokenListener))
HIVE_EMPTY_IMPL_VOID(AuthV4, terminateProcess())
HIVE_EMPTY_IMPL_VOID(AuthV4, refreshAccessToken(onRefreshAccessToken refreshAccessTokenListener))
HIVE_EMPTY_IMPL_VOID(AuthV4, signInWithStoredPlayerId(PlayerID playerId, bool useAutoSignIn, onSignIn signInListener))
HIVE_EMPTY_IMPL_VOID(AuthV4, getStoredPlayerIdList(onPlayerIdList playerIdListListener))
HIVE_EMPTY_IMPL_VOID(AuthV4, storeCurrentPlayerId(onStorePlayerId storeListener))
HIVE_EMPTY_IMPL_VOID(AuthV4, deleteStoredPlayerId(PlayerID playerId, onDeletePlayerId deleteListener))
HIVE_EMPTY_IMPL_VOID(AuthV4,getProfile(std::vector<PlayerID> playerIdList, onGetProfile getProfileListener))
HIVE_EMPTY_IMPL_CLASS(AuthV4,getPlayerInfo(),PlayerInfo)
HIVE_EMPTY_IMPL_CLASS(AuthV4,getParentalConsentInfo(),ParentalConsentInfo)
HIVE_EMPTY_IMPL_VOID(AuthV4,executeEngine(picojson::value jsonParam))
HIVE_EMPTY_IMPL_VOID(AuthV4, getHashedDi(onHashedDi hashedListener))
HIVE_EMPTY_IMPL_VOID(AuthV4, showIdentityVerification(onIdentityVerification identityVerificationListener))
HIVE_EMPTY_IMPL_VOID(AuthV4, getAgeRange(onGetAgeRange getAgeRangeListener))
HIVE_EMPTY_IMPL_VOID(AuthV4, showAgeRangeUpdatePermission(std::string description, onGetAgeRange listener))
HIVE_EMPTY_IMPL_VOID(AuthV4, checkAgeGate(bool useCloseButton, onCheckAgeGate checkAgeGateListener))
HIVE_EMPTY_IMPL_VOID(AuthV4, setAutoLoginEnabled(bool enabled, onAutoLoginEnabled autoLoginEnabledListener))

//AuthV4 helper
HIVE_EMPTY_IMPL_VOID(AuthV4,Helper::executeEngine(picojson::value jsonParam))
HIVE_EMPTY_IMPL_VOID(AuthV4,Helper::syncAccount(ProviderType providerType, onAuthV4Helper listener))
HIVE_EMPTY_IMPL_VOID(AuthV4,Helper::signIn(onAuthV4Helper listener))
HIVE_EMPTY_IMPL_VOID(AuthV4,Helper::signOut(onAuthV4Helper listener))
HIVE_EMPTY_IMPL_VOID(AuthV4,Helper::playerDelete(onAuthV4Helper listener))
HIVE_EMPTY_IMPL_VOID(AuthV4,Helper::connect(ProviderType providerType, onAuthV4Helper listener))
HIVE_EMPTY_IMPL_VOID(AuthV4,Helper::disconnect(ProviderType providerType, onAuthV4Helper listener))
HIVE_EMPTY_IMPL_VOID(AuthV4,Helper::showAchievements(onAuthV4Helper listener))
HIVE_EMPTY_IMPL_VOID(AuthV4,Helper::showLeaderboard(onAuthV4Helper listener))
HIVE_EMPTY_IMPL_VOID(AuthV4,Helper::achievementsReveal(const std::string achievementId, onAuthV4Helper listener))
HIVE_EMPTY_IMPL_VOID(AuthV4,Helper::achievementsUnlock(const std::string achievementId, onAuthV4Helper listener))
HIVE_EMPTY_IMPL_VOID(AuthV4,Helper::achievementsIncrement(const std::string achievementId, const int value, onAuthV4Helper listener))
HIVE_EMPTY_IMPL_VOID(AuthV4,Helper::leaderboardsSubmitScore(const std::string leaderboardId, const long long score, onAuthV4Helper listener))
HIVE_EMPTY_IMPL_VOID(AuthV4,Helper::showConflict(onAuthV4Helper listener))
HIVE_EMPTY_IMPL_VOID(AuthV4,Helper::showConflict(ConflictSingleViewInfo const& viewInfo,onAuthV4Helper listener))
HIVE_EMPTY_IMPL_VOID(AuthV4,Helper::switchAccount(onAuthV4Helper listener))
HIVE_EMPTY_IMPL_VOID(AuthV4,Helper::resolveConflict(onAuthV4Helper listener))
HIVE_EMPTY_IMPL_CLASS(AuthV4,Helper::getIDPList(), std::vector<ProviderType>)
HIVE_EMPTY_IMPL_VOID(AuthV4,Helper::showGameCenterLoginCancelDialog(onAuthV4DialogDismiss listener))

//ProfileInfo
HIVE_EMPTY_CONSTRUCTOR(ProfileInfo)
HIVE_EMPTY_CONSTRUCTOR_PARAM(ProfileInfo,ProfileInfo(picojson::value object))
ProfileInfo::~ProfileInfo() {}

//PlayerInfo
HIVE_EMPTY_CONSTRUCTOR(PlayerInfo)
HIVE_EMPTY_CONSTRUCTOR_PARAM(PlayerInfo,PlayerInfo(picojson::value object))
PlayerInfo::~PlayerInfo() {}

//ConflictSingleViewInfo
HIVE_EMPTY_CONSTRUCTOR_PARAM(ConflictSingleViewInfo,ConflictSingleViewInfo(PlayerID playerId))
ConflictSingleViewInfo::~ConflictSingleViewInfo() {}
HIVE_EMPTY_IMPL_VOID(ConflictSingleViewInfo,SetValue(const std::string key,const long long playerData))
HIVE_EMPTY_IMPL_VOID(ConflictSingleViewInfo,SetValue(const std::string key,const double playerData))
HIVE_EMPTY_IMPL_VOID(ConflictSingleViewInfo,SetValue(const std::string key,const std::string playerData))

HIVE_EMPTY_IMPL_STDSTRING(ConflictSingleViewInfo,toJsonConflict() const)
HIVE_EMPTY_IMPL_STDSTRING(ConflictSingleViewInfo,toJsonCurrent() const)

//ConflictViewInfo
HIVE_EMPTY_CONSTRUCTOR_PARAM(ConflictViewInfo,ConflictViewInfo(PlayerID currentPlayerId,PlayerID conflictPlayerId))
ConflictViewInfo::~ConflictViewInfo() {}
HIVE_EMPTY_IMPL_VOID(ConflictViewInfo,SetValue(const std::string key,const long long currentPlayerData,const long long conflictPlayerData))
HIVE_EMPTY_IMPL_VOID(ConflictViewInfo,SetValue(const std::string key,const double currentPlayerData,const double conflictPlayerData))
HIVE_EMPTY_IMPL_VOID(ConflictViewInfo,SetValue(const std::string key,const std::string currentPlayerData,const std::string conflictPlayerData))

HIVE_EMPTY_IMPL_STDSTRING(ConflictViewInfo,toJsonConflict() const)
HIVE_EMPTY_IMPL_STDSTRING(ConflictViewInfo,toJsonCurrent() const)

//ProviderInfo
HIVE_EMPTY_CONSTRUCTOR(ProviderInfo)
HIVE_EMPTY_CONSTRUCTOR_PARAM(ProviderInfo,ProviderInfo(picojson::value object))
HIVE_EMPTY_IMPL_STDSTRING(ProviderInfo,stringProviderType(ProviderType providerType))
HIVE_EMPTY_IMPL_DEFAULT(ProviderInfo,providerTypeFromString(const std::string typeString),ProviderType)

//Identity
HIVE_EMPTY_CONSTRUCTOR(Identity)
HIVE_EMPTY_CONSTRUCTOR_PARAM(Identity, Identity(picojson::value object))
#endif

//ProviderGoogle
HIVE_EMPTY_IMPL_VOID(ProviderGoogle,achievementsReveal(const std::string achievementId))
HIVE_EMPTY_IMPL_VOID(ProviderGoogle,achievementsReveal(const std::string achievementId, onAchievementsResult listener))
HIVE_EMPTY_IMPL_VOID(ProviderGoogle,achievementsUnlock(const std::string achievementId))
HIVE_EMPTY_IMPL_VOID(ProviderGoogle,achievementsUnlock(const std::string achievementId, onAchievementsResult listener))
HIVE_EMPTY_IMPL_VOID(ProviderGoogle,achievementsIncrement(const std::string incrementalAchievementId, const int argValue))
HIVE_EMPTY_IMPL_VOID(ProviderGoogle,achievementsIncrement(const std::string incrementalAchievementId, const int argValue, onAchievementsResult listener))
HIVE_EMPTY_IMPL_VOID(ProviderGoogle,leaderboardsSubmitScore(const std::string leaderboardId, const long long score))
HIVE_EMPTY_IMPL_VOID(ProviderGoogle,leaderboardsSubmitScore(const std::string leaderboardId, const long long score, onLeaderboardsResult listener))
HIVE_EMPTY_IMPL_VOID(ProviderGoogle,showLeaderboard(onLeaderboardsResult listener))
HIVE_EMPTY_IMPL_VOID(ProviderGoogle,showAchievements(onAchievementsResult listener))
HIVE_EMPTY_IMPL_VOID(ProviderGoogle,executeEngine(picojson::value jsonParam))
HIVE_EMPTY_IMPL_VOID(ProviderGoogle,getGooglePlayerId(onGooglePlayerIdResult listener))

//ProviderApple
HIVE_EMPTY_IMPL_VOID(ProviderApple,reportScore(std::string score,std::string leaderboardIdentifier,onReportLeaderboard listener))
HIVE_EMPTY_IMPL_VOID(ProviderApple,showLeaderboard(onShowLeaderboard listener))
HIVE_EMPTY_IMPL_VOID(ProviderApple,loadAchievements(onLoadAchievements listener))
HIVE_EMPTY_IMPL_VOID(ProviderApple,reportAchievement(std::string percent,bool showsCompletionBanner,std::string achievementIdentifier,onReportAchievement listener))
HIVE_EMPTY_IMPL_VOID(ProviderApple,showAchievements(onShowAchievement listener))
HIVE_EMPTY_IMPL_VOID(ProviderApple,resetAchievements(onResetAchievements listener))
HIVE_EMPTY_IMPL_VOID(ProviderApple,executeEngine(picojson::value jsonParam))

//ProviderAppleAchievement
HIVE_EMPTY_CONSTRUCTOR(ProviderAppleAchievement)
ProviderAppleAchievement::~ProviderAppleAchievement() {}

#if WITH_EDITOR
//DataStore
HIVE_EMPTY_IMPL_VOID(DataStore, set(string key, string value, onSet listener))
HIVE_EMPTY_IMPL_VOID(DataStore, set(map<string, string> data, onSet listener))
HIVE_EMPTY_IMPL_VOID(DataStore, get(string key, onGet listener))
HIVE_EMPTY_IMPL_VOID(DataStore, getMyData(onMyData listener))
HIVE_EMPTY_IMPL_VOID(DataStore, getUsersData(string key, onUsersData listener))
HIVE_EMPTY_IMPL_VOID(DataStore, executeEngine(picojson::value jsonParam))
#endif

//IAPV4
#if WITH_EDITOR
HIVE_EMPTY_IMPL_VOID(IAPV4,marketConnect(onMarketConnect listener))
HIVE_EMPTY_IMPL_VOID(IAPV4,getProductInfo(onGetProductInfo listener))
HIVE_EMPTY_IMPL_VOID(IAPV4,purchase(std::string marketPid,std::string iapPayload,onPurchase listener))
HIVE_EMPTY_IMPL_VOID(IAPV4,purchase(std::string marketPid,std::string iapPayload,int quantity,onPurchase listener))
HIVE_EMPTY_IMPL_VOID(IAPV4,restore(onRestore listener))
HIVE_EMPTY_IMPL_VOID(IAPV4,transactionFinish(std::string marketPid,onTransactionFinish listener))
HIVE_EMPTY_IMPL_VOID(IAPV4,transactionMultiFinish(std::vector<std::string> const & marketPidList,onTransactionMultiFinish listener))
HIVE_EMPTY_IMPL_VOID(IAPV4,showMarketSelection(onMarketConnect listener))
HIVE_EMPTY_IMPL_VOID(IAPV4,getBalanceInfo(onBalance listener))
HIVE_EMPTY_IMPL_VOID(IAPV4,showCharge(onBalance listener))
HIVE_EMPTY_IMPL_VOID(IAPV4,checkPromotePurchase(onCheckPromotePurchase listener))
HIVE_EMPTY_IMPL_VOID(IAPV4,getSubscriptionProductInfo(onGetProductInfo listener))
HIVE_EMPTY_IMPL_VOID(IAPV4,purchaseSubscriptionUpdate(std::string marketPid,std::string oldMarketPid,std::string iapPayload,onPurchase listener))
HIVE_EMPTY_IMPL_VOID(IAPV4,purchaseSubscription(IAPV4PurchaseParam param, onPurchase listener))
HIVE_EMPTY_IMPL_VOID(IAPV4,restoreSubscription(onRestore listener))
HIVE_EMPTY_IMPL_VOID(IAPV4,getMarketProductInfo(std::vector<std::string> const & marketPidList, onGetProductInfo listener))
HIVE_EMPTY_IMPL_VOID(IAPV4,showInAppMessages(int categoryId, onInAppMessages listener))
HIVE_EMPTY_IMPL_VOID(IAPV4,getConsumeInfoAgreement(onGetConsumeInfoAgreement listener))
HIVE_EMPTY_IMPL_VOID(IAPV4,showConsumeInfoAgreement(onShowConsumeInfoAgreement listener))
HIVE_EMPTY_IMPL_STDSTRING(IAPV4,getAccountUuid())

HIVE_EMPTY_IMPL_DEFAULT(IAPV4,getSelectedMarket(),IAPV4Type)
HIVE_EMPTY_IMPL_VOID(IAPV4, executeEngine(picojson::value jsonParam))


//IAPV4Product
HIVE_EMPTY_CONSTRUCTOR(IAPV4Product)
HIVE_EMPTY_CONSTRUCTOR_PARAM(IAPV4Product,IAPV4Product(picojson::value const& jsonParam))

//IAPV4Receipt
HIVE_EMPTY_CONSTRUCTOR(IAPV4Receipt)
HIVE_EMPTY_IMPL_CLASS(IAPV4Receipt,create(picojson::value const& jsonParam), std::shared_ptr<IAPV4Receipt>)
IAPV4Receipt::~IAPV4Receipt() {}

//IAPV4PurchaseParam
HIVE_EMPTY_CONSTRUCTOR(IAPV4PurchaseParam)
HIVE_EMPTY_CONSTRUCTOR_PARAM(IAPV4PurchaseParam, IAPV4PurchaseParam(picojson::value jsonParam))
HIVE_EMPTY_IMPL_CLASS(IAPV4PurchaseParam,toJson() const,picojson::object)
HIVE_EMPTY_IMPL_STDSTRING(IAPV4PurchaseParam,toString() const)
#endif

//PermissionViewData
HIVE_EMPTY_CONSTRUCTOR(PermissionViewData)
HIVE_EMPTY_CONSTRUCTOR_PARAM(PermissionViewData, PermissionViewData(picojson::value const& jsonParam))


#if WITH_EDITOR
//MatchMaking
HIVE_EMPTY_IMPL_VOID(MatchMaking, requestMatchMaking(int matchId, int point, const char * extraData, onMatchMakingData listener))
HIVE_EMPTY_IMPL_VOID(MatchMaking, getRequestingStatus(int matchId, onMatchMakingData listener))
HIVE_EMPTY_IMPL_VOID(MatchMaking, deleteRequesting(int matchId, onMatchMakingResult listener))
HIVE_EMPTY_IMPL_VOID(MatchMaking, createGroup(int matchId, int point, const char * extraData, onMatchMakingGroupData listener))
HIVE_EMPTY_IMPL_VOID(MatchMaking, joinGroup(int matchId, const char * groupCode, int point, const char * extraData, onMatchMakingGroupData listener))
HIVE_EMPTY_IMPL_VOID(MatchMaking, leaveGroup(int matchId, onMatchMakingResult listener))
HIVE_EMPTY_IMPL_VOID(MatchMaking, kickGroupUser(int matchId, PlayerID targetPlayerId, onMatchMakingGroupData listener))
HIVE_EMPTY_IMPL_VOID(MatchMaking, getGroupInfoByUser(int matchId, onMatchMakingGroupData listener))
HIVE_EMPTY_IMPL_VOID(MatchMaking, getGroupInfoByGroupCode(const char * groupCode, onMatchMakingGroupData listener))
HIVE_EMPTY_IMPL_VOID(MatchMaking, updateGroupUser(int matchId, bool ready, int point, const char * extraData, onMatchMakingGroupData listener))
HIVE_EMPTY_IMPL_VOID(MatchMaking, requestGroupMatching(int matchId, onMatchMakingGroupData listener))
HIVE_EMPTY_IMPL_VOID(MatchMaking, deleteGroupMatching(int matchId, onMatchMakingGroupData listener))
HIVE_EMPTY_IMPL_VOID(MatchMaking, executeEngine(picojson::value jsonParam))

HIVE_EMPTY_CONSTRUCTOR(MatchMakingData)
HIVE_EMPTY_CONSTRUCTOR(MatchMakingGroupData)
HIVE_EMPTY_CONSTRUCTOR(MatchingMemberInfo)
HIVE_EMPTY_CONSTRUCTOR(MatchingResultPlayerInfo)
HIVE_EMPTY_CONSTRUCTOR(MatchingResultTeamInfo)
#endif

#if WITH_EDITOR
//Chat
HIVE_EMPTY_IMPL_VOID(Chat, createChannel(CreateChannelParams const & params, onCreateChannel listener))
HIVE_EMPTY_IMPL_VOID(Chat, getChannels(GetChannelsParams const * params, onGetChannels listener))
HIVE_EMPTY_IMPL_VOID(Chat, getChannelInfo(std::string const & channelId, onGetChannelInfo listener))
HIVE_EMPTY_IMPL_VOID(Chat, getChannelMembers(std::string const & channelId, onGetChannelMembers listener))
HIVE_EMPTY_IMPL_VOID(Chat, deleteChannel(std::string const & channelId, onDeleteChannel listener))
HIVE_EMPTY_IMPL_VOID(Chat, enterChannel(EnterChannelParams const & params, onEnterChannel listener))
HIVE_EMPTY_IMPL_VOID(Chat, exitChannel(std::string const & channelId, onExitChannel listener))
HIVE_EMPTY_IMPL_VOID(Chat, getChannelsByUser(onGetChannelsByUser listener))
HIVE_EMPTY_IMPL_VOID(Chat, getBlockMembers(onGetBlockMembers listener))
HIVE_EMPTY_IMPL_VOID(Chat, blockMember(int64_t blockPlayerId, onBlockMember listener))
HIVE_EMPTY_IMPL_VOID(Chat, unblockMember(int64_t blockPlayerId, onUnblockMember listener))
HIVE_EMPTY_IMPL_VOID(Chat, connect(std::string const & extraData, onResult listener))
HIVE_EMPTY_IMPL_VOID(Chat, connect(onConnect listener))
HIVE_EMPTY_IMPL_VOID(Chat, reconnect(onReconnect listener))
HIVE_EMPTY_IMPL_VOID(Chat, disconnect(onDisconnect listener))
HIVE_EMPTY_IMPL_VOID(Chat, sendMessageWithChannelSendMessageParams(ChannelSendMessageParams const& params))
HIVE_EMPTY_IMPL_VOID(Chat, sendMessageWithChannelSendMessageParams(ChannelSendMessageParams const& params, onChannelSendMessage listener))
HIVE_EMPTY_IMPL_VOID(Chat, sendMessageWithDirectSendMessageParams(DirectSendMessageParams const& params))
HIVE_EMPTY_IMPL_VOID(Chat, sendMessageWithDirectSendMessageParams(DirectSendMessageParams const& params, onDirectSendMessage listener))
HIVE_EMPTY_IMPL_VOID(Chat, translate(TranslateParams const & params, onTranslate listener))
HIVE_EMPTY_IMPL_VOID(Chat, addChannelListener(std::string const & uniqueKey, ChannelListener* listener))
HIVE_EMPTY_IMPL_VOID(Chat, addDirectMessageListener(std::string const & uniqueKey, DirectMessageListener* listener))
HIVE_EMPTY_IMPL_VOID(Chat, addConnectionListener(std::string const & uniqueKey, ConnectionListener* listener))
HIVE_EMPTY_IMPL_VOID(Chat, addUserListener(std::string const & uniqueKey, UserListener* listener))
HIVE_EMPTY_IMPL_VOID(Chat, addCustomDataListener(std::string const & uniqueKey, CustomDataListener* listener))
HIVE_EMPTY_IMPL_VOID(Chat, removeChannelListener(std::string const & uniqueKey))
HIVE_EMPTY_IMPL_VOID(Chat, removeDirectMessageListener(std::string const & uniqueKey))
HIVE_EMPTY_IMPL_VOID(Chat, removeConnectionListener(std::string const & uniqueKey))
HIVE_EMPTY_IMPL_VOID(Chat, removeUserListener(std::string const & uniqueKey))
HIVE_EMPTY_IMPL_VOID(Chat, removeCustomDataListener(std::string const & uniqueKey))
HIVE_EMPTY_IMPL_DEFAULT(Chat, isConnected(), bool)
HIVE_EMPTY_IMPL_VOID(Chat, executeEngine(picojson::value jsonParam))

//Channel 인스턴스 메서드
HIVE_EMPTY_IMPL_VOID(Channel, query(ChannelMessageListQueryParams const & params, Chat::onGetChannelMessageHistory listener) const)
HIVE_EMPTY_IMPL_VOID(Channel, setTranslationEnabled(bool enabled, Chat::onChannelTranslationSetting listener) const)
HIVE_EMPTY_IMPL_VOID(Channel, addReaction(std::string const & messageId, ReactionType reactionType, Chat::onAddReaction listener) const)
HIVE_EMPTY_IMPL_VOID(Channel, removeReaction(std::string const & messageId, ReactionType reactionType, Chat::onRemoveReaction listener) const)

HIVE_EMPTY_CONSTRUCTOR(CreateChannelParams)
HIVE_EMPTY_CONSTRUCTOR(GetChannelsParams)
HIVE_EMPTY_CONSTRUCTOR(EnterChannelParams)
HIVE_EMPTY_CONSTRUCTOR(DirectSendMessageParams)
HIVE_EMPTY_CONSTRUCTOR(ChannelSendMessageParams)
HIVE_EMPTY_CONSTRUCTOR(TranslateParams)
HIVE_EMPTY_CONSTRUCTOR(ChannelMessageListQueryParams)

HIVE_EMPTY_CONSTRUCTOR(Channel)
HIVE_EMPTY_CONSTRUCTOR(ChannelPage)
HIVE_EMPTY_CONSTRUCTOR(Member)
HIVE_EMPTY_CONSTRUCTOR(BlockMember)
HIVE_EMPTY_CONSTRUCTOR(ChannelMessage)
HIVE_EMPTY_CONSTRUCTOR(ChannelNoticeMessage)
HIVE_EMPTY_CONSTRUCTOR(DirectMessage)
HIVE_EMPTY_CONSTRUCTOR(EnteredMember)
HIVE_EMPTY_CONSTRUCTOR(ExitedMember)
HIVE_EMPTY_CONSTRUCTOR(DeletedChannel)
HIVE_EMPTY_CONSTRUCTOR(ChannelMessageListQueryResponse)
HIVE_EMPTY_CONSTRUCTOR(TranslationData)
HIVE_EMPTY_CONSTRUCTOR(Reaction)
HIVE_EMPTY_CONSTRUCTOR(NoticeMessage)
#endif

NS_HIVE_END

#endif
