#include "HIVE_Configuration.h"


#include "HIVE_CppPlugin.h"
#if !WITH_EDITOR && PLATFORM_WINDOWS


NS_HIVE_BEGIN

static Configuration::onGetMetaData g_ConfigurationGetMetaData;

std::string Configuration::getConfiguration()
{
    picojson::object jsonParam = HiveCppPlugin::createParam("Configuration", "getConfiguration");
    
    picojson::value resJson = HiveCppPlugin::callNative(jsonParam);
    
    picojson::value jsonValue = resJson.get("getConfiguration");
    if(jsonValue.is<picojson::null>())
        return "";
//    return jsonValue.to_str();
    return jsonValue.serialize(true);
}


std::string Configuration::getHiveSDKVersion()
{
	picojson::object jsonParam = HiveCppPlugin::createParam("Configuration", "getHiveSDKVersion");

	picojson::value resJson = HiveCppPlugin::callNative(jsonParam);

    picojson::value jsonValue = resJson.get("getHiveSDKVersion");
    if(jsonValue.is<picojson::null>())
        return "";
    return jsonValue.to_str();
}


std::string Configuration::getReferenceSDKVersion()
{
    picojson::object jsonParam = HiveCppPlugin::createParam("Configuration", "getReferenceSDKVersion");
    
    picojson::value resJson = HiveCppPlugin::callNative(jsonParam);
    
    picojson::value jsonValue = resJson.get("getReferenceSDKVersion");
    if(jsonValue.is<picojson::null>())
        return "";
    return jsonValue.to_str();
}


std::string Configuration::getAppId()
{
	picojson::object jsonParam = HiveCppPlugin::createParam("Configuration", "getAppId");

	picojson::value resJson = HiveCppPlugin::callNative(jsonParam);

    picojson::value jsonValue = resJson.get("getAppId");
    if(jsonValue.is<picojson::null>())
        return "";
    return jsonValue.to_str();
}


void Configuration::setAppId(std::string appId)
{
	picojson::object jsonParam = HiveCppPlugin::createParam("Configuration", "setAppId");
	jsonParam["setAppId"] = picojson::value(appId);

	HiveCppPlugin::callNative(jsonParam);
}

//GCPSDK4-284
std::string Configuration::getHiveCertificationKey()
{
    picojson::object jsonParam = HiveCppPlugin::createParam("Configuration", "getHiveCertificationKey");

    picojson::value resJson = HiveCppPlugin::callNative(jsonParam);

    picojson::value jsonValue = resJson.get("getHiveCertificationKey");
    if(jsonValue.is<picojson::null>())
        return "";
    return jsonValue.to_str();
}

//GCPSDK4-284
void Configuration::setHiveCertificationKey(std::string appKey)
{
    picojson::object jsonParam = HiveCppPlugin::createParam("Configuration", "setHiveCertificationKey");
    jsonParam["appKey"] = picojson::value(appKey);

    HiveCppPlugin::callNative(jsonParam);
}


ZoneType Configuration::getZone()
{
	picojson::object jsonParam = HiveCppPlugin::createParam("Configuration", "getZone");

	picojson::value resJson = HiveCppPlugin::callNative(jsonParam);

    std::string resultValue;
    picojson::value jsonValue = resJson.get("getZone");
    if(jsonValue.is<picojson::null>() == false)
        resultValue = jsonValue.to_str();

    if (resultValue.compare("SANDBOX") == 0)
        return ZoneType::SANDBOX;
    else
        return ZoneType::REAL;
}


void Configuration::setZone(ZoneType zone)
{
	picojson::object jsonParam = HiveCppPlugin::createParam("Configuration", "setZone");

    std::string zoneString = "REAL";
    if (zone == ZoneType::SANDBOX)
        zoneString = "SANDBOX";

    jsonParam["setZone"] = picojson::value(zoneString);

	HiveCppPlugin::callNative(jsonParam);
}


std::string Configuration::getServerId()
{
	picojson::object jsonParam = HiveCppPlugin::createParam("Configuration", "getServerId");

	picojson::value resJson = HiveCppPlugin::callNative(jsonParam);

    picojson::value jsonValue = resJson.get("getServerId");
    if(jsonValue.is<picojson::null>())
        return "";
    return jsonValue.to_str();
}


void Configuration::setServerId(std::string serverId)
{
	picojson::object jsonParam = HiveCppPlugin::createParam("Configuration", "setServerId");
	jsonParam["setServerId"] = picojson::value(serverId);

	HiveCppPlugin::callNative(jsonParam);
}

void Configuration::updateServerId(std::string serverId)
{
    picojson::object jsonParam = HiveCppPlugin::createParam("Configuration", "updateServerId");
    jsonParam["updateServerId"] = picojson::value(serverId);

    HiveCppPlugin::callNative(jsonParam);
}

std::string Configuration::getGameLanguage()
{
	picojson::object jsonParam = HiveCppPlugin::createParam("Configuration", "getGameLanguage");
    
	picojson::value resJson = HiveCppPlugin::callNative(jsonParam);

    picojson::value jsonValue = resJson.get("getGameLanguage");
    if(jsonValue.is<picojson::null>())
        return "";
    return jsonValue.to_str();
}

void Configuration::setGameLanguage(std::string language)
{
	picojson::object jsonParam = HiveCppPlugin::createParam("Configuration", "setGameLanguage");
	jsonParam["setGameLanguage"] = picojson::value(language);

	HiveCppPlugin::callNative(jsonParam);
}

void Configuration::updateGameLanguage(std::string language)
{
    picojson::object jsonParam = HiveCppPlugin::createParam("Configuration", "updateGameLanguage");
    jsonParam["updateGameLanguage"] = picojson::value(language);

    HiveCppPlugin::callNative(jsonParam);
}

bool Configuration::getUseLog()
{
	picojson::object jsonParam = HiveCppPlugin::createParam("Configuration", "getUseLog");

	picojson::value resJson = HiveCppPlugin::callNative(jsonParam);

    picojson::value jsonValue = resJson.get("getUseLog");
    if(jsonValue.is<picojson::null>())
        return false;
    return jsonValue.get<bool>();
}


void Configuration::setUseLog(bool useLog)
{
	picojson::object jsonParam = HiveCppPlugin::createParam("Configuration", "setUseLog");
	jsonParam["setUseLog"] = picojson::value(useLog);

	HiveCppPlugin::callNative(jsonParam);
}


std::string Configuration::getCompany()
{
    picojson::object jsonParam = HiveCppPlugin::createParam("Configuration", "getCompany");
    
    picojson::value resJson = HiveCppPlugin::callNative(jsonParam);
    
    picojson::value jsonValue = resJson.get("getCompany");
    if(jsonValue.is<picojson::null>())
        return "";
    return jsonValue.to_str();
}


void Configuration::setCompany(std::string company)
{
    picojson::object jsonParam = HiveCppPlugin::createParam("Configuration", "setCompany");
    jsonParam["setCompany"] = picojson::value(company);
    
    HiveCppPlugin::callNative(jsonParam);
}


std::string Configuration::getChannel()
{
    picojson::object jsonParam = HiveCppPlugin::createParam("Configuration", "getChannel");
    
    picojson::value resJson = HiveCppPlugin::callNative(jsonParam);
    
    picojson::value jsonValue = resJson.get("getChannel");
    if(jsonValue.is<picojson::null>())
        return "";
    return jsonValue.to_str();
}


void Configuration::setChannel(std::string channel)
{
    picojson::object jsonParam = HiveCppPlugin::createParam("Configuration", "setChannel");
    jsonParam["setChannel"] = picojson::value(channel);
    
    HiveCppPlugin::callNative(jsonParam);
}


int Configuration::getHttpConnectTimeout()
{
	picojson::object jsonParam = HiveCppPlugin::createParam("Configuration", "getHttpConnectTimeout");

	picojson::value resJson = HiveCppPlugin::callNative(jsonParam);

    picojson::value jsonValue = resJson.get("getHttpConnectTimeout");
    if(jsonValue.is<picojson::null>())
        return 15;
    return (int)jsonValue.get<double>();
}


void Configuration::setHttpConnectTimeout(int httpConnectTimeout)
{
	picojson::object jsonParam = HiveCppPlugin::createParam("Configuration", "setHttpConnectTimeout");
	jsonParam["setHttpConnectTimeout"] = picojson::value((double)httpConnectTimeout);

	HiveCppPlugin::callNative(jsonParam);
}


int Configuration::getHttpReadTimeout()
{
	picojson::object jsonParam = HiveCppPlugin::createParam("Configuration", "getHttpReadTimeout");

	picojson::value resJson = HiveCppPlugin::callNative(jsonParam);

    picojson::value jsonValue = resJson.get("getHttpReadTimeout");
    if(jsonValue.is<picojson::null>())
        return 10;
    return (int)jsonValue.get<double>();
}


void Configuration::setHttpReadTimeout(int httpReadTimeout)
{
	picojson::object jsonParam = HiveCppPlugin::createParam("Configuration", "setHttpReadTimeout");
	jsonParam["setHttpReadTimeout"] = picojson::value((double)httpReadTimeout);

	HiveCppPlugin::callNative(jsonParam);
}


int Configuration::getMaxGameLogSize()
{
	picojson::object jsonParam = HiveCppPlugin::createParam("Configuration", "getMaxGameLogSize");

	picojson::value resJson = HiveCppPlugin::callNative(jsonParam);

    picojson::value jsonValue = resJson.get("getMaxGameLogSize");
    if(jsonValue.is<picojson::null>())
        return 5;
    return (int)jsonValue.get<double>();
}


void Configuration::setMaxGameLogSize(int maxGameLogSize)
{
	picojson::object jsonParam = HiveCppPlugin::createParam("Configuration", "setMaxGameLogSize");
	jsonParam["setMaxGameLogSize"] = picojson::value((double)maxGameLogSize);

	HiveCppPlugin::callNative(jsonParam);
}


std::string Configuration::getMarket()
{
	picojson::object jsonParam = HiveCppPlugin::createParam("Configuration", "getMarket");

	picojson::value resJson = HiveCppPlugin::callNative(jsonParam);

    picojson::value jsonValue = resJson.get("getMarket");
    if(jsonValue.is<picojson::null>())
        return "";
    return jsonValue.to_str();
}

std::string Configuration::getHiveCountry() {
    picojson::object jsonParam = HiveCppPlugin::createParam("Configuration", "getHiveCountry");
    
    picojson::value resJson = HiveCppPlugin::callNative(jsonParam);
    
    picojson::value jsonValue = resJson.get("getHiveCountry");
    if(jsonValue.is<picojson::null>())
        return "";
    return jsonValue.to_str();
}

std::string Configuration::getHiveTimeZone() {
    picojson::object jsonParam = HiveCppPlugin::createParam("Configuration", "getHiveTimeZone");
    
    picojson::value resJson = HiveCppPlugin::callNative(jsonParam);
    
    picojson::value jsonValue = resJson.get("getHiveTimeZone");
    if(jsonValue.is<picojson::null>())
        return "";
    return jsonValue.to_str();
}

void Configuration::setMarket(std::string market)
{
	picojson::object jsonParam = HiveCppPlugin::createParam("Configuration", "setMarket");
	jsonParam["setMarket"] = picojson::value(market);

	HiveCppPlugin::callNative(jsonParam);
}

unsigned int Configuration::getAnalyticsSendLimit() {
    picojson::object jsonParam = HiveCppPlugin::createParam("Configuration", "getAnalyticsSendLimit");
    
    picojson::value resJson = HiveCppPlugin::callNative(jsonParam);
    
    picojson::value jsonValue = resJson.get("getAnalyticsSendLimit");
    if(jsonValue.is<picojson::null>())
        return 0;
    return static_cast<unsigned int>(jsonValue.get<double>());
    
}

void Configuration::setAnalyticsSendLimit(unsigned int limit) {
    picojson::object jsonParam = HiveCppPlugin::createParam("Configuration", "setAnalyticsSendLimit");
    jsonParam["setAnalyticsSendLimit"] = picojson::value(static_cast<double>(limit));
    
    HiveCppPlugin::callNative(jsonParam);
}

unsigned int Configuration::getAnalyticsQueueLimit() {
    picojson::object jsonParam = HiveCppPlugin::createParam("Configuration", "getAnalyticsQueueLimit");
    
    picojson::value resJson = HiveCppPlugin::callNative(jsonParam);
    
    picojson::value jsonValue = resJson.get("getAnalyticsQueueLimit");
    if(jsonValue.is<picojson::null>())
        return 0;
    return static_cast<unsigned int>(jsonValue.get<double>());
    
}
void Configuration::setAnalyticsQueueLimit(unsigned int limit) {
    picojson::object jsonParam = HiveCppPlugin::createParam("Configuration", "setAnalyticsQueueLimit");
    jsonParam["setAnalyticsQueueLimit"] = picojson::value(static_cast<double>(limit));
    
    HiveCppPlugin::callNative(jsonParam);
}

float Configuration::getAnalyticsSendCycleSeconds() {
    picojson::object jsonParam = HiveCppPlugin::createParam("Configuration", "getAnalyticsSendCycleSeconds");
    
    picojson::value resJson = HiveCppPlugin::callNative(jsonParam);
    
    picojson::value jsonValue = resJson.get("getAnalyticsSendCycleSeconds");
    if(jsonValue.is<picojson::null>())
        return 0;
    return static_cast<float>(jsonValue.get<double>());
    
}

void Configuration::setAnalyticsSendCycleSeconds(float seconds) {
    picojson::object jsonParam = HiveCppPlugin::createParam("Configuration", "setAnalyticsSendCycleSeconds");
    jsonParam["setAnalyticsSendCycleSeconds"] = picojson::value(seconds);
    
    HiveCppPlugin::callNative(jsonParam);
}

bool Configuration::getAgeGateU13() {
    picojson::object jsonParam = HiveCppPlugin::createParam("Configuration", "getAgeGateU13");
    
    picojson::value resJson = HiveCppPlugin::callNative(jsonParam);
    
    picojson::value jsonValue = resJson.get("getAgeGateU13");
    if(jsonValue.is<picojson::null>())
        return false;
    
    return jsonValue.get<bool>();
}


void Configuration::setAgeGateU13(bool ageGateU13) {
    picojson::object jsonParam = HiveCppPlugin::createParam("Configuration", "setAgeGateU13");
    jsonParam["setAgeGateU13"] = picojson::value(ageGateU13);
    
    HiveCppPlugin::callNative(jsonParam);
}

bool Configuration::getAgeGateU16Agree() {
    picojson::object jsonParam = HiveCppPlugin::createParam("Configuration", "getAgeGateU16Agree");

    picojson::value resJson = HiveCppPlugin::callNative(jsonParam);

    picojson::value jsonValue = resJson.get("getAgeGateU16Agree");
    if(jsonValue.is<picojson::null>())
        return false;

    return jsonValue.get<bool>();
}

bool Configuration::getLegalGuardianConsentAgree() {
    picojson::object jsonParam = HiveCppPlugin::createParam("Configuration", "getLegalGuardianConsentAgree");
    
    picojson::value resJson = HiveCppPlugin::callNative(jsonParam);
    
    picojson::value jsonValue = resJson.get("getLegalGuardianConsentAgree");
    
    if(jsonValue.is<picojson::null>()) return false;
    
    return jsonValue.get<bool>();
}

// not support setAgeGateU16Agree
//void Configuration::setAgeGateU16Agree(bool ageGateU16Agree) {}

void Configuration::setHivePermissionViewOn(bool isOn) {
    picojson::object jsonParam = HiveCppPlugin::createParam("Configuration", "setHivePermissionViewOn");
    jsonParam["isOn"] = picojson::value(isOn);
    HiveCppPlugin::callNative(jsonParam);
}

PermissionViewData Configuration::getPermissionViewData(HIVELanguage language) {
    picojson::object jsonParam = HiveCppPlugin::createParam("Configuration", "getPermissionViewData");

    std::string languageStr = "";

    if (language == HIVELanguage::HIVELanguageDE) {
        languageStr = "de";
    }
    else if (language == HIVELanguage::HIVELanguageEN) {
        languageStr = "en";
    }
    else if (language == HIVELanguage::HIVELanguageES) {
        languageStr = "es";
    }
    else if (language == HIVELanguage::HIVELanguageFR) {
        languageStr = "fr";
    }
    else if (language == HIVELanguage::HIVELanguageID) {
        languageStr = "id";
    }
    else if (language == HIVELanguage::HIVELanguageIT) {
        languageStr = "it";
    }
    else if (language == HIVELanguage::HIVELanguageJA) {
        languageStr = "ja";
    }
    else if (language == HIVELanguage::HIVELanguageKO) {
        languageStr = "ko";
    }
    else if (language == HIVELanguage::HIVELanguagePT) {
        languageStr = "pt";
    }
    else if (language == HIVELanguage::HIVELanguageRU) {
        languageStr = "ru";
    }
    else if (language == HIVELanguage::HIVELanguageTH) {
        languageStr = "th";
    }
    else if (language == HIVELanguage::HIVELanguageTR) {
        languageStr = "tr";
    }
    else if (language == HIVELanguage::HIVELanguageVI) {
        languageStr = "vi";
    }
    else if (language == HIVELanguage::HIVELanguageZHS) {
        languageStr = "zh-hans";
    }
    else if (language == HIVELanguage::HIVELanguageZHT) {
        languageStr = "zh-hant";
    }
    else if (language == HIVELanguage::HIVELanguageAR) {
        languageStr = "ar";
    }

    jsonParam["language"] = picojson::value(languageStr);

    picojson::value resJson = HiveCppPlugin::callNative(jsonParam);

    PermissionViewData permissionViewData(resJson.get("data"));

    return permissionViewData;
}

HiveThemeType Configuration::getHiveTheme() {
    picojson::object jsonParam = HiveCppPlugin::createParam("Configuration", "getHiveTheme");

    picojson::value resJson = HiveCppPlugin::callNative(jsonParam);

    picojson::value jsonValue = resJson.get("hiveThemeType");
    if(jsonValue.is<picojson::null>())
        return HiveThemeType::hiveLight;

    std::string themeStr = jsonValue.to_str();

    if (themeStr == "hiveLight") {
        return HiveThemeType::hiveLight;
    } else {
        return HiveThemeType::hiveDark;
    }
    return HiveThemeType::hiveLight;
}

void Configuration::setHiveTheme(HiveThemeType theme)
{
    picojson::object jsonParam = HiveCppPlugin::createParam("Configuration", "setHiveTheme");


    std::string themeStr = "";
    if (theme == HiveThemeType::hiveLight) {
        themeStr = "hiveLight";
    } else if (theme == HiveThemeType::hiveDark) {
        themeStr = "hiveDark";
    }

    jsonParam["hiveThemeType"] = picojson::value(themeStr);

    HiveCppPlugin::callNative(jsonParam);
}

void Configuration::setHiveOrientation(std::string orientation)
{
    picojson::object jsonParam = HiveCppPlugin::createParam("Configuration", "setHiveOrientation");
    jsonParam["hiveOrientation"] = picojson::value(orientation);

    HiveCppPlugin::callNative(jsonParam);
}

void Configuration::setHiveCommunityUrl(std::string url)
{
    picojson::object jsonParam = HiveCppPlugin::createParam("Configuration", "setHiveCommunityUrl");
    jsonParam["hiveCommunityUrl"] = picojson::value(url);

    HiveCppPlugin::callNative(jsonParam);
}

void Configuration::setUseHercules(bool enable) {
    picojson::object jsonParam = HiveCppPlugin::createParam("Configuration", "setUseHercules");
    jsonParam["enable"] = picojson::value(enable);

    HiveCppPlugin::callNative(jsonParam);
}

void Configuration::setConfigurations(HiveConfigType configType,std::string value)
{
    picojson::object jsonParam = HiveCppPlugin::createParam("Configuration", "setConfigurations");

    std::string typeStr = "";
    if (configType == HiveConfigType::googleServerClientId) {
        typeStr = "googleServerClientId";
    } else if (configType == HiveConfigType::googlePlayGamesServerClientId) {
        typeStr = "googlePlayGamesServerClientId";
    } else if (configType == HiveConfigType::wechatSecret) {
        typeStr = "wechatSecret";
    } else if (configType == HiveConfigType::wechatPaymentKey) {
        typeStr = "wechatPaymentKey";
    } else if (configType == HiveConfigType::adjustKey) {
        typeStr = "adjustKey";
    } else if (configType == HiveConfigType::singularKey) {
        typeStr = "singularKey";
    } else if (configType == HiveConfigType::appsflyerKey) {
        typeStr = "appsflyerKey";
    } else if (configType == HiveConfigType::airbridgeKey) {
        typeStr = "airbridgeKey";
    } else if (configType == HiveConfigType::airbridgeAppName) {
        typeStr = "airbridgeAppName";
    } else if (configType == HiveConfigType::airbridgeSecretId) {
        typeStr = "airbridgeSecretId";
    } else if (configType == HiveConfigType::airbridgeSecret) {
        typeStr = "airbridgeSecret";
    }


    jsonParam["configType"] = picojson::value(typeStr);
    jsonParam["value"] = picojson::value(value);

    HiveCppPlugin::callNative(jsonParam);
}

void Configuration::getMetaData(std::string key, bool forceReload, onGetMetaData listener){
    g_ConfigurationGetMetaData = listener;
    picojson::object jsonParam = HiveCppPlugin::createParam("Configuration", "getMetaData");
    jsonParam["key"] = picojson::value(key);
    jsonParam["forceReload"] = picojson::value(forceReload);
    HiveCppPlugin::callNative(jsonParam);
}

bool Configuration::getCrossPromotionBannerShowing() {
    picojson::object jsonParam = HiveCppPlugin::createParam("Configuration", "getCrossPromotionBannerShowing");
    
    picojson::value resJson = HiveCppPlugin::callNative(jsonParam);
    
    picojson::value jsonValue = resJson.get("getCrossPromotionBannerShowing");
    if(jsonValue.is<picojson::null>())
        return true;
    
    return jsonValue.get<bool>();
}

void Configuration::setCrossPromotionBannerShowing(bool expose) {
    picojson::object jsonParam = HiveCppPlugin::createParam("Configuration", "setCrossPromotionBannerShowing");
    jsonParam["setCrossPromotionBannerShowing"] = picojson::value(expose);
    
    HiveCppPlugin::callNative(jsonParam);
}

void Configuration::setUsePrivateBrowsingForAuth(bool use) {
    picojson::object jsonParam = HiveCppPlugin::createParam("Configuration", "setUsePrivateBrowsingForAuth");
    jsonParam["use"] = picojson::value(use);
    HiveCppPlugin::callNative(jsonParam);
}

bool Configuration::getEnableGameController() {
    picojson::object jsonParam = HiveCppPlugin::createParam("Configuration", "getEnableGameController");
    picojson::value resJson = HiveCppPlugin::callNative(jsonParam);
    picojson::value jsonValue = resJson.get("enable");
    if (jsonValue.is<picojson::null>())
        return true;
    return jsonValue.get<bool>();
}

void Configuration::setEnableGameController(bool enable) {
    picojson::object jsonParam = HiveCppPlugin::createParam("Configuration", "setEnableGameController");
    jsonParam["enable"] = picojson::value(enable);
    HiveCppPlugin::callNative(jsonParam);
}

int Configuration::getChatConnectionTimeout() {
    picojson::object jsonParam = HiveCppPlugin::createParam("Configuration", "getChatConnectionTimeout");
    
    picojson::value resJson = HiveCppPlugin::callNative(jsonParam);
    
    picojson::value jsonValue = resJson.get("getChatConnectionTimeout");
    if(jsonValue.is<picojson::null>())
        return 60;
    
    return (int)jsonValue.get<double>();
}

void Configuration::setChatConnectionTimeout(int timeout) {
    picojson::object jsonParam = HiveCppPlugin::createParam("Configuration", "setChatConnectionTimeout");
    jsonParam["setChatConnectionTimeout"] = picojson::value((double)timeout);
    
    HiveCppPlugin::callNative(jsonParam);
}

void Configuration::setTestZone() {
    picojson::object jsonParam = HiveCppPlugin::createParam("Configuration", "setTestZone");
    HiveCppPlugin::callNative(jsonParam);
}

bool Configuration::isTestZone() {
    picojson::object jsonParam = HiveCppPlugin::createParam("Configuration", "isTestZone");

    picojson::value resJson = HiveCppPlugin::callNative(jsonParam);

    picojson::value jsonValue = resJson.get("isTestZone");
    if (jsonValue.is<picojson::null>())
        return false;

    return jsonValue.get<bool>();
}

void Configuration::executeEngine(picojson::value jsonParam)
{
	ResultAPI result;

    if(!jsonParam.get("resultAPI").is<picojson::null>()){
        result = ResultAPI(jsonParam.get("resultAPI"));
    }

    std::string methodName = jsonParam.get("method").to_str();
    if(methodName.compare("getMetaData") == 0){
        if(g_ConfigurationGetMetaData != nullptr){
            std::string value = "";
            if(!jsonParam.get("value").is<picojson::null>()){
                value = jsonParam.get("value").get<std::string>();
            }
            g_ConfigurationGetMetaData(result,value);
        }
    }
}

NS_HIVE_END		// namespace hive

#endif