//
//  HIVE_DataStore.cpp
//  HIVE_SDK_Plugin
//
//  Created by sjyong on 2022/03/03.
//

#include "HIVE_DataStore.h"
#include "HIVE_CppPlugin.h"

#if !WITH_EDITOR && PLATFORM_WINDOWS

NS_HIVE_BEGIN

static DataStore::onSet g_DataStoreSetWithKeyValue = nullptr;
static DataStore::onSet g_DataStoreSetWithData = nullptr;
static DataStore::onGet g_DataStoreGet = nullptr;
static DataStore::onMyData g_DataStoreGetMyData = nullptr;
static DataStore::onUsersData g_DataStoreGetUsersData = nullptr;

const char* DATASTORE_CLASS_NAME = "DataStore";
const char* DATASTORE_FUNC_NAME_SET = "set";
const char* DATASTORE_FUNC_NAME_GET = "get";
const char* DATASTORE_FUNC_NAME_GET_MY_DATA = "getMyData";
const char* DATASTORE_FUNC_NAME_GET_USERS_DATA = "getUsersData";


void DataStore::set(string key, string value, onSet onSetListener) {
    g_DataStoreSetWithKeyValue = onSetListener;

    picojson::object jsonParam = HiveCppPlugin::createParam(DATASTORE_CLASS_NAME, DATASTORE_FUNC_NAME_SET);
    jsonParam["key"] = picojson::value(key);
    jsonParam["value"] = picojson::value(value);

    HiveCppPlugin::callNative(jsonParam);
}

void DataStore::set(map<string, string> data, onSet onSetListener) {
    g_DataStoreSetWithData = onSetListener;

    picojson::object jsonParam = HiveCppPlugin::createParam(DATASTORE_CLASS_NAME, DATASTORE_FUNC_NAME_SET);

    picojson::object dataObject;
    for (auto it = data.begin(); it != data.end(); it++) {
        dataObject[it->first] = picojson::value(it->second);
    }

    string dataString = picojson::value(dataObject).serialize();
    jsonParam["data"] = picojson::value(dataString);

    HiveCppPlugin::callNative(jsonParam);
}

void DataStore::get(string key, onGet onCommandListener) {
    g_DataStoreGet = onCommandListener;

    picojson::object jsonParam = HiveCppPlugin::createParam(DATASTORE_CLASS_NAME, DATASTORE_FUNC_NAME_GET);
    jsonParam["key"] = picojson::value(key);

    HiveCppPlugin::callNative(jsonParam);
}

void DataStore::getMyData(onMyData onMyDataListener) {
    g_DataStoreGetMyData = onMyDataListener;

    picojson::object jsonParam = HiveCppPlugin::createParam(DATASTORE_CLASS_NAME, DATASTORE_FUNC_NAME_GET_MY_DATA);

    HiveCppPlugin::callNative(jsonParam);
}

void DataStore::getUsersData(string key, onUsersData onUsersDataListener) {
    g_DataStoreGetUsersData = onUsersDataListener;

    picojson::object jsonParam = HiveCppPlugin::createParam(DATASTORE_CLASS_NAME, DATASTORE_FUNC_NAME_GET_USERS_DATA);
    jsonParam["key"] = picojson::value(key);

    HiveCppPlugin::callNative(jsonParam);
}

void DataStore::executeEngine(picojson::value jsonParam) {
    ResultAPI result(jsonParam.get("resultAPI"));

    std::string methodName = jsonParam.get("method").to_str();
    if (methodName.compare(DATASTORE_FUNC_NAME_SET) == 0) {
        if (g_DataStoreSetWithKeyValue != nullptr) {
            g_DataStoreSetWithKeyValue(result);
            g_DataStoreSetWithKeyValue = nullptr;
        }
        else if (g_DataStoreSetWithData != nullptr) {
            g_DataStoreSetWithData(result);
            g_DataStoreSetWithData = nullptr;
        }
    }
    else if (methodName.compare(DATASTORE_FUNC_NAME_GET) == 0) {
        if (g_DataStoreGet != nullptr) {
            string data;

            if (!result.isSuccess()) {
                g_DataStoreGet(result, data);
                return;
            }
            else if (!jsonParam.get("data").is<picojson::null>()) {
                data = jsonParam.get("data").to_str();
            }

            g_DataStoreGet(result, data);
        }
    }
    else if (methodName.compare(DATASTORE_FUNC_NAME_GET_MY_DATA) == 0) {
        if (g_DataStoreGetMyData != nullptr) {
            map<string, string> myData;

            if (!result.isSuccess()) {
                g_DataStoreGetMyData(result, myData);
                return;
            }
            else if (!jsonParam.get("myData").is<picojson::null>()) {
                string myDataString = jsonParam.get("myData").to_str();
                picojson::value myDataValue;
                picojson::parse(myDataValue, myDataString);
                picojson::object myDataObject = myDataValue.get<picojson::object>();

                for (auto it = myDataObject.begin(); it != myDataObject.end(); it++) {
                    myData[it->first] = it->second.to_str();
                }
            }
            g_DataStoreGetMyData(result, myData);
        }
    }
    else if (methodName.compare(DATASTORE_FUNC_NAME_GET_USERS_DATA) == 0) {
        if (g_DataStoreGetUsersData != nullptr) {
            map<long long, string> usersData;
            string key = jsonParam.get("key").to_str();

            if (!result.isSuccess()) {
                g_DataStoreGetUsersData(result, key, usersData);
                return;
            }
            else if (!jsonParam.get("usersData").is<picojson::null>()) {
                string usersDataString = jsonParam.get("usersData").to_str();
                picojson::value usersDataValue;
                picojson::parse(usersDataValue, usersDataString);
                picojson::object usersDataObject = usersDataValue.get<picojson::object>();

                for (auto it = usersDataObject.begin(); it != usersDataObject.end(); it++) {
                    string keyString = it->first;
                    usersData[stoll(keyString)] = it->second.to_str();
                }
            }
            g_DataStoreGetUsersData(result, key, usersData);
        }
    }
}

NS_HIVE_END

#endif