//
//  HIVE_IAPV4.cpp
//  HIVE_SDK+Plugin
//
//  Created by paikjongman on 2017. 8. 28..
//  Copyright © 2017년 GCP. All rights reserved.
//
#include "HIVE_IAPV4.h"

#include "HIVE_CppPlugin.h"
#if !WITH_EDITOR && PLATFORM_WINDOWS
NS_HIVE_BEGIN



static IAPV4Type StringToHIVEIAPV4Type(const std::string& str){
    if(str == "NOT_SELECTED"){
        return IAPV4Type::NotSelected;
    }else if(str == "APPLE_APPSTORE"){
        return IAPV4Type::AppleAppStore;
    }else if(str == "GOOGLE_PLAYSTORE"){
        return IAPV4Type::GooglePlayStore;
    }else if(str == "HIVE_LEBI"){
        return IAPV4Type::HIVELebi;
    }else if(str == "ONESTORE"){
        return IAPV4Type::OneStore;
    }else if(str == "AMAZON_APPSTORE"){
        return IAPV4Type::AmazonAppStore;
    }else if(str == "SAMSUNG_GALAXYSTORE"){
        return IAPV4Type::SamsungGalaxyStore;
    }else if(str == "HUAWEI_APPGALLERY"){
        return IAPV4Type::HuaweiAppGallery;
    }else if(str == "FUNTAP"){
        return IAPV4Type::Funtap;
    }else if(str == "OPPO_APPMARKET"){
        return IAPV4Type::OPPOAppMarket;
    }else if(str == "VIVO_APPSTORE"){
        return IAPV4Type::VIVOAppStore;
    }else if(str == "TENCENT_MYAPP"){
        return IAPV4Type::TencentMyapp;
    }else if(str == "XIAOMI_APPSTORE"){
        return IAPV4Type::XiaomiAppStore;
    }else if(str == "HUAWEI_APPGALLERY_CHINA"){
        return IAPV4Type::HuaweiAppGalleryChina;
    }else if(str == "HIVESTORE"){
        return IAPV4Type::HiveStore;
    }else if(str == "STEAM"){
        return IAPV4Type::Steam;
    }else if(str == "NOWGG"){
        return IAPV4Type::Nowgg;
    }
    return IAPV4Type::AppleAppStore;
}


static IAPV4::onMarketConnect g_IAPV4MarketConnect;
static IAPV4::onGetProductInfo g_IAPV4GetMarketProductInfo;
static IAPV4::onGetProductInfo g_IAPV4GetProductInfo;
static IAPV4::onPurchase g_IAPV4Purchase;
static IAPV4::onRestore g_IAPV4Restore;
// Subscription start
static IAPV4::onGetProductInfo g_IAPV4GetSubscriptionProductInfo;
static IAPV4::onPurchase g_IAPV4PurchaseSubscriptionUpdate;
static IAPV4::onPurchase g_IAPV4PurchaseSubscription;
static IAPV4::onRestore g_IAPV4RestoreSubscription;
// Subscription End
static IAPV4::onTransactionFinish g_IAPV4TransactionFinish;
static IAPV4::onTransactionMultiFinish g_IAPV4TransactionMultiFinish;
static IAPV4::onMarketConnect g_IAPV4ShowMarketSelection;
static IAPV4::onBalance g_IAPV4GetBalanceInfo;
static IAPV4::onBalance g_IAPV4ShowCharge;
static IAPV4::onCheckPromotePurchase g_IAPV4CheckPromotePurchase;
static IAPV4::onInAppMessages g_IAPV4ShowInAppMessages;
static IAPV4::onGetConsumeInfoAgreement g_IAPV4GetConsumeInfoAgreement;
static IAPV4::onShowConsumeInfoAgreement g_IAPV4ShowConsumeInfoAgreement;

void IAPV4::marketConnect(onMarketConnect listener){
    g_IAPV4MarketConnect = listener;
    picojson::object jsonParam = HiveCppPlugin::createParam("IAPV4", "marketConnect");
    HiveCppPlugin::callNative(jsonParam);
}

void IAPV4::getMarketProductInfo(std::vector<std::string> const & marketPidList, onGetProductInfo listener){
    g_IAPV4GetMarketProductInfo = listener;
    picojson::object jsonParam = HiveCppPlugin::createParam("IAPV4", "getMarketProductInfo");
    picojson::array pidList;
    for(auto it=marketPidList.cbegin();it!=marketPidList.cend();++it){
        pidList.push_back(picojson::value(*it));
    }
    jsonParam["marketPidList"] = picojson::value(pidList);
    HiveCppPlugin::callNative(jsonParam);
}

void IAPV4::getProductInfo(onGetProductInfo listener){
    g_IAPV4GetProductInfo = listener;
    picojson::object jsonParam = HiveCppPlugin::createParam("IAPV4", "getProductInfo");
    HiveCppPlugin::callNative(jsonParam);
}

void IAPV4::purchase(std::string marketPid,std::string iapPayload,onPurchase listener){
    g_IAPV4Purchase = listener;
    picojson::object jsonParam = HiveCppPlugin::createParam("IAPV4", "purchase");
    jsonParam["marketPid"] = picojson::value(marketPid);
    jsonParam["iapPayload"] = picojson::value(iapPayload);
    HiveCppPlugin::callNative(jsonParam);
}

void IAPV4::purchase(std::string marketPid,std::string iapPayload,int quantity,onPurchase listener){
    g_IAPV4Purchase = listener;
    picojson::object jsonParam = HiveCppPlugin::createParam("IAPV4", "purchase");
    jsonParam["marketPid"] = picojson::value(marketPid);
    jsonParam["iapPayload"] = picojson::value(iapPayload);
    jsonParam["quantity"] = picojson::value(static_cast<double>(quantity));
    HiveCppPlugin::callNative(jsonParam);
}

void IAPV4::restore(onRestore listener){
    g_IAPV4Restore = listener;
    picojson::object jsonParam = HiveCppPlugin::createParam("IAPV4", "restore");
    HiveCppPlugin::callNative(jsonParam);
}

// Subscription Start

void IAPV4::getSubscriptionProductInfo(onGetProductInfo listener){
    g_IAPV4GetProductInfo = listener;
    picojson::object jsonParam = HiveCppPlugin::createParam("IAPV4", "getSubscriptionProductInfo");
    HiveCppPlugin::callNative(jsonParam);
}

void IAPV4::purchaseSubscriptionUpdate(std::string marketPid,std::string oldMarketPid,std::string iapPayload,onPurchase listener){
    g_IAPV4Purchase = listener;
    picojson::object jsonParam = HiveCppPlugin::createParam("IAPV4", "purchaseSubscriptionUpdate");
    jsonParam["marketPid"] = picojson::value(marketPid);
    jsonParam["oldMarketPid"] = picojson::value(oldMarketPid);
    jsonParam["iapPayload"] = picojson::value(iapPayload);
    HiveCppPlugin::callNative(jsonParam);
}

void IAPV4::purchaseSubscription(IAPV4PurchaseParam param, onPurchase listener){
    g_IAPV4Purchase = listener;
    picojson::object jsonParam = HiveCppPlugin::createParam("IAPV4", "purchaseSubscription");
    jsonParam["param"] = picojson::value(param.toString());
    HiveCppPlugin::callNative(jsonParam);
}

void IAPV4::restoreSubscription(onRestore listener){
    g_IAPV4Restore = listener;
    picojson::object jsonParam = HiveCppPlugin::createParam("IAPV4", "restoreSubscription");
    HiveCppPlugin::callNative(jsonParam);
}

// Subscription End

void IAPV4::transactionFinish(std::string marketPid,onTransactionFinish listener){
    g_IAPV4TransactionFinish = listener;
    picojson::object jsonParam = HiveCppPlugin::createParam("IAPV4", "transactionFinish");
    jsonParam["marketPid"] = picojson::value(marketPid);
    HiveCppPlugin::callNative(jsonParam);
}

void IAPV4::transactionMultiFinish(std::vector<std::string> const & marketPidList,onTransactionMultiFinish listener){
    g_IAPV4TransactionMultiFinish = listener;
    picojson::object jsonParam = HiveCppPlugin::createParam("IAPV4", "transactionMultiFinish");
    picojson::array pidList;
    for(auto it=marketPidList.cbegin();it!=marketPidList.cend();++it){
        pidList.push_back(picojson::value(*it));
    }
    jsonParam["marketPidList"] = picojson::value(pidList);
    HiveCppPlugin::callNative(jsonParam);
}
void IAPV4::showMarketSelection(onMarketConnect listener) {
    g_IAPV4ShowMarketSelection = listener;
    picojson::object jsonParam = HiveCppPlugin::createParam("IAPV4", "showMarketSelection");
    HiveCppPlugin::callNative(jsonParam);
}
void IAPV4::getBalanceInfo(onBalance listener) {
    g_IAPV4GetBalanceInfo = listener;
    picojson::object jsonParam = HiveCppPlugin::createParam("IAPV4", "getBalanceInfo");
    HiveCppPlugin::callNative(jsonParam);
}
void IAPV4::showCharge(onBalance listener) {
    g_IAPV4ShowCharge = listener;
    picojson::object jsonParam = HiveCppPlugin::createParam("IAPV4", "showCharge");
    HiveCppPlugin::callNative(jsonParam);
}
void IAPV4::checkPromotePurchase(onCheckPromotePurchase listener) {
    g_IAPV4CheckPromotePurchase = listener;
    picojson::object jsonParam = HiveCppPlugin::createParam("IAPV4", "checkPromotePurchase");
    HiveCppPlugin::callNative(jsonParam);
}

IAPV4Type IAPV4::getSelectedMarket() {
    picojson::object jsonParam = HiveCppPlugin::createParam("IAPV4", "getSelectedMarket");
    picojson::value resJson = HiveCppPlugin::callNative(jsonParam);
    IAPV4Type iapv4Type = StringToHIVEIAPV4Type(resJson.get("iapv4Type").get<std::string>());
    return iapv4Type;
}

std::string IAPV4::getAccountUuid() {
    picojson::object jsonParam = HiveCppPlugin::createParam("IAPV4", "getAccountUuid");
    picojson::value resJson = HiveCppPlugin::callNative(jsonParam);
    picojson::value jsonValue = resJson.get("accountUuid");
    if(jsonValue.is<picojson::null>())
        return "";
    std::string accountUuid = jsonValue.get<std::string>();
    return accountUuid;
}

void IAPV4::showInAppMessages(int categoryId, onInAppMessages listener) {
    g_IAPV4ShowInAppMessages = listener;
    picojson::object jsonParam = HiveCppPlugin::createParam("IAPV4", "showInAppMessages");
    jsonParam["categoryId"] = picojson::value(to_string(categoryId));
    HiveCppPlugin::callNative(jsonParam);
}

void IAPV4::getConsumeInfoAgreement(onGetConsumeInfoAgreement listener){
    g_IAPV4GetConsumeInfoAgreement = listener;
    picojson::object jsonParam = HiveCppPlugin::createParam("IAPV4", "getConsumeInfoAgreement");
    HiveCppPlugin::callNative(jsonParam);
}

void IAPV4::showConsumeInfoAgreement(onShowConsumeInfoAgreement listener){
    g_IAPV4ShowConsumeInfoAgreement = listener;
    picojson::object jsonParam = HiveCppPlugin::createParam("IAPV4", "showConsumeInfoAgreement");
    HiveCppPlugin::callNative(jsonParam);
}

void IAPV4::executeEngine(picojson::value jsonParam){
    
    ResultAPI result;
    if(!jsonParam.get("resultAPI").is<picojson::null>()){
        result = ResultAPI(jsonParam.get("resultAPI"));
    }
    
    std::string methodName = jsonParam.get("method").to_str();
    
    if(methodName.compare("marketConnect") == 0){
        if(g_IAPV4MarketConnect != nullptr) {
            std::vector<IAPV4Type> iapV4TypeList;
            if(!jsonParam.get("iapV4TypeList").is<picojson::null>()){
                auto jsonList = jsonParam.get("iapV4TypeList").get<picojson::array>();
                for(auto it=jsonList.begin();it!=jsonList.end();++it){
                    iapV4TypeList.push_back(StringToHIVEIAPV4Type((*it).get<std::string>()));
                }
            }
            g_IAPV4MarketConnect(result,iapV4TypeList);
        }
    }
    else if(methodName.compare("getMarketProductInfo") == 0){
        if(g_IAPV4GetMarketProductInfo != nullptr){
            
            std::vector<IAPV4Product> productList;
            unsigned int balance = 0;
            
            if(!jsonParam.get("iapV4ProductList").is<picojson::null>()){
                auto jsonList = jsonParam.get("iapV4ProductList").get<picojson::array>();
                for(auto it=jsonList.begin();it!=jsonList.end();++it){
                    productList.push_back(IAPV4Product(*it));
                }
            }
            if(!jsonParam.get("balance").is<picojson::null>()){
                balance = static_cast<unsigned int>(jsonParam.get("balance").get<double>());
            }
            g_IAPV4GetMarketProductInfo(result,productList,balance);
        }
    }
    else if(methodName.compare("getProductInfo") == 0){
        if(g_IAPV4GetProductInfo != nullptr){
            
            std::vector<IAPV4Product> productList;
            unsigned int balance = 0;
            
            if(!jsonParam.get("iapV4ProductList").is<picojson::null>()){
                auto jsonList = jsonParam.get("iapV4ProductList").get<picojson::array>();
                for(auto it=jsonList.begin();it!=jsonList.end();++it){
                    productList.push_back(IAPV4Product(*it));
                }
            }
            if(!jsonParam.get("balance").is<picojson::null>()){
                balance = static_cast<unsigned int>(jsonParam.get("balance").get<double>());
            }
            g_IAPV4GetProductInfo(result,productList,balance);
        }
    }
    else if(methodName.compare("purchase") == 0){
        
        if(g_IAPV4Purchase != nullptr){
            std::shared_ptr<IAPV4Receipt>receipt;
            if(!jsonParam.get("iapV4Receipt").is<picojson::null>()){
                receipt = IAPV4Receipt::create(jsonParam.get("iapV4Receipt"));
            } else {
                receipt = std::make_shared<IAPV4Receipt>();
            }
            g_IAPV4Purchase(result,*receipt);
        }
    }
    else if(methodName.compare("restore") == 0){
        
        if(g_IAPV4Restore != nullptr){
            std::vector<std::shared_ptr<IAPV4Receipt>> receipts;
            std::vector<std::reference_wrapper<IAPV4Receipt>> receiptRefs;
            if(!jsonParam.get("iapv4ReceiptList").is<picojson::null>()){
                auto iapv4ReceiptList = jsonParam.get("iapv4ReceiptList").get<picojson::array>();
                for(auto it = iapv4ReceiptList.begin();it != iapv4ReceiptList.end();++it){
                    std::shared_ptr<IAPV4Receipt> ptr = IAPV4Receipt::create(*it);
                    receipts.push_back(ptr);
                    receiptRefs.push_back(*ptr);
                }
            }
            g_IAPV4Restore(result,receiptRefs);
        }
    }
    
    // subscription Start
    
    else if(methodName.compare("getSubscriptionProductInfo") == 0){
        if(g_IAPV4GetProductInfo != nullptr){
            
            std::vector<IAPV4Product> productList;
            unsigned int balance = 0;
            
            if(!jsonParam.get("iapV4ProductList").is<picojson::null>()){
                auto jsonList = jsonParam.get("iapV4ProductList").get<picojson::array>();
                for(auto it=jsonList.begin();it!=jsonList.end();++it){
                    productList.push_back(IAPV4Product(*it));
                }
            }
            if(!jsonParam.get("balance").is<picojson::null>()){
                balance = static_cast<unsigned int>(jsonParam.get("balance").get<double>());
            }
            g_IAPV4GetProductInfo(result,productList,balance);
        }
    }
    else if(methodName.compare("purchaseSubscriptionUpdate") == 0){
        
        if(g_IAPV4Purchase != nullptr){
            std::shared_ptr<IAPV4Receipt>receipt;
            if(!jsonParam.get("iapV4Receipt").is<picojson::null>()){
                receipt = IAPV4Receipt::create(jsonParam.get("iapV4Receipt"));
            } else {
                receipt = std::make_shared<IAPV4Receipt>();
            }
            g_IAPV4Purchase(result,*receipt);
        }
    }
    else if(methodName.compare("purchaseSubscription") == 0){
        
        if(g_IAPV4Purchase != nullptr){
            std::shared_ptr<IAPV4Receipt>receipt;
            if(!jsonParam.get("iapV4Receipt").is<picojson::null>()){
                receipt = IAPV4Receipt::create(jsonParam.get("iapV4Receipt"));
            } else {
                receipt = std::make_shared<IAPV4Receipt>();
            }
            g_IAPV4Purchase(result,*receipt);
        }
    }
    else if(methodName.compare("restoreSubscription") == 0){
        
        if(g_IAPV4Restore != nullptr){
            std::vector<std::shared_ptr<IAPV4Receipt>> receipts;
            std::vector<std::reference_wrapper<IAPV4Receipt>> receiptRefs;
            if(!jsonParam.get("iapv4ReceiptList").is<picojson::null>()){
                auto iapv4ReceiptList = jsonParam.get("iapv4ReceiptList").get<picojson::array>();
                for(auto it = iapv4ReceiptList.begin();it != iapv4ReceiptList.end();++it){
                    std::shared_ptr<IAPV4Receipt> ptr = IAPV4Receipt::create(*it);
                    receipts.push_back(ptr);
                    receiptRefs.push_back(*ptr);
                }
            }
            g_IAPV4Restore(result,receiptRefs);
        }
    }
    // Subscription End
    else if(methodName.compare("transactionFinish") == 0){
        if(g_IAPV4TransactionFinish != nullptr){
            std::string marketPid = "";
            if(!jsonParam.get("marketPid").is<picojson::null>()){
                marketPid = jsonParam.get("marketPid").get<std::string>();
            }
            g_IAPV4TransactionFinish(result,marketPid);
        }
    }
    else if(methodName.compare("transactionMultiFinish") == 0){
        if(g_IAPV4TransactionMultiFinish != nullptr){
            std::vector<ResultAPI> resultList;
            std::vector<std::string> marketPidList;
            
            if(!jsonParam.get("resultList").is<picojson::null>()){
                auto jsonResultList = jsonParam.get("resultList").get<picojson::array>();
                for(auto it=jsonResultList.begin();it!=jsonResultList.end();++it){
                    resultList.push_back(ResultAPI(*it));
                }
            }
            if(!jsonParam.get("marketPidList").is<picojson::null>()){
                auto jsonMarketPidList = jsonParam.get("marketPidList").get<picojson::array>();
                for(auto it=jsonMarketPidList.begin();it!=jsonMarketPidList.end();++it){
                    marketPidList.push_back((*it).get<std::string>());
                }
            }
            g_IAPV4TransactionMultiFinish(resultList,marketPidList);
        }
    }
    else if(methodName.compare("showMarketSelection") == 0) {
        if(g_IAPV4ShowMarketSelection != nullptr) {
            std::vector<IAPV4Type> iapV4TypeList;
            if(!jsonParam.get("iapV4TypeList").is<picojson::null>()){
                auto jsonList = jsonParam.get("iapV4TypeList").get<picojson::array>();
                for(auto it=jsonList.begin();it!=jsonList.end();++it){
                    iapV4TypeList.push_back(StringToHIVEIAPV4Type((*it).get<std::string>()));
                }
            }
            g_IAPV4ShowMarketSelection(result,iapV4TypeList);
        }
    }
    else if(methodName.compare("getBalanceInfo") == 0) {
        if(g_IAPV4GetBalanceInfo != nullptr){
            unsigned int balance = 0;

            if(!jsonParam.get("balance").is<picojson::null>()){
                balance = static_cast<unsigned int>(jsonParam.get("balance").get<double>());
            }
            g_IAPV4GetBalanceInfo(result,balance);
        }
    }
    else if(methodName.compare("showCharge") == 0) {
        if(g_IAPV4ShowCharge != nullptr) {
            unsigned int balance = 0;
            
            if(!jsonParam.get("balance").is<picojson::null>()){
                balance = static_cast<unsigned int>(jsonParam.get("balance").get<double>());
            }
            g_IAPV4ShowCharge(result,balance);
        }
    }
    else if(methodName.compare("checkPromotePurchase") == 0) {
        if(g_IAPV4CheckPromotePurchase != nullptr){
            std::string marketPid = "";
            if(!jsonParam.get("marketPid").is<picojson::null>()){
                marketPid = jsonParam.get("marketPid").get<std::string>();
            }
            g_IAPV4CheckPromotePurchase(result,marketPid);
        }
    }
    else if(methodName.compare("showInAppMessages") == 0) {
        if(g_IAPV4ShowInAppMessages != nullptr){
            unsigned int responseCode = -1;

            if(!jsonParam.get("responseCode").is<picojson::null>()){
                responseCode = static_cast<unsigned int>(jsonParam.get("responseCode").get<double>());
            }
            g_IAPV4ShowInAppMessages(responseCode);
        }
    }
    else if(methodName.compare("getConsumeInfoAgreement") == 0) {
        if(g_IAPV4GetConsumeInfoAgreement != nullptr){
            if(!jsonParam.get("info").is<picojson::null>()){
                auto info = new IAPV4ConsumeInfoUserAgreement(jsonParam.get("info"));
                g_IAPV4GetConsumeInfoAgreement(result, info);
            }
            else{
                g_IAPV4GetConsumeInfoAgreement(result, nullptr);
            }
        }
    }
    else if(methodName.compare("showConsumeInfoAgreement") == 0) {
        if(g_IAPV4ShowConsumeInfoAgreement != nullptr){
            bool didAgree = false;
            
            if(!jsonParam.get("didAgree").is<picojson::null>()){
                didAgree = static_cast<bool>(jsonParam.get("didAgree").get<bool>());
            }
            g_IAPV4ShowConsumeInfoAgreement(result, didAgree);
        }
    }
}


IAPV4Product::IAPV4Product()
:productType("")
,marketPid("")
,currency("")
,price(0)
,title("")
,displayPrice("")
,productDescription("")
,originalMarketJson("")
,displayOriginalPrice("")
,originalPrice(0)
,iconURL("")
,coinsReward(0){
}

IAPV4Product::IAPV4Product(picojson::value const& jsonParam) : IAPV4Product() {
    HIVE_SETVALUEFROMJSONSTRING(this->productType, jsonParam, "productType");
    HIVE_SETVALUEFROMJSONSTRING(this->marketPid, jsonParam, "marketPid");
    HIVE_SETVALUEFROMJSONSTRING(this->currency, jsonParam, "currency");
    HIVE_SETVALUEFROMJSONNUMBER(this->price, double, jsonParam, "price");
    HIVE_SETVALUEFROMJSONSTRING(this->title, jsonParam, "title");
    HIVE_SETVALUEFROMJSONSTRING(this->displayPrice, jsonParam, "displayPrice");
    HIVE_SETVALUEFROMJSONSTRING(this->productDescription, jsonParam, "productDescription");
    HIVE_SETVALUEFROMJSONSTRING(this->originalMarketJson, jsonParam, "originalMarketJson");
    HIVE_SETVALUEFROMJSONSTRING(this->displayOriginalPrice, jsonParam, "displayOriginalPrice");
    HIVE_SETVALUEFROMJSONNUMBER(this->originalPrice, double, jsonParam, "originalPrice");
    HIVE_SETVALUEFROMJSONSTRING(this->iconURL, jsonParam, "iconURL");
    HIVE_SETVALUEFROMJSONNUMBER(this->coinsReward, int, jsonParam, "coinsReward");
}

std::shared_ptr<IAPV4Receipt> IAPV4Receipt::create(picojson::value const& jsonParam){
    std::shared_ptr<IAPV4Receipt> receipt;
    receipt = std::make_shared<IAPV4Receipt>(IAPV4Receipt(jsonParam));
    
    return receipt;
    
}

IAPV4Type IAPV4Receipt::getIAPV4TypeFromJson(picojson::value const& jsonParam){
    auto jsonValue = jsonParam.get("type");
    if(!jsonValue.is<picojson::null>())
        return StringToHIVEIAPV4Type(jsonValue.get<std::string>());
    
    return IAPV4Type::AppleAppStore;
}

IAPV4Receipt::IAPV4Receipt(){
    
}

IAPV4Receipt::IAPV4Receipt(picojson::value const& jsonParam){
    if(jsonParam.is<picojson::null>())
        return;
    
    HIVE_SETVALUEFROMJSONSTRING(this->iapPayload, jsonParam, "iapPayload");
    HIVE_SETVALUEFROMJSONSTRING(this->hiveiapReceipt, jsonParam, "hiveiapReceipt");
    HIVE_SETVALUEFROMJSONSTRING(this->bypassInfo, jsonParam, "bypassInfo");
    HIVE_SETVALUEFROMJSONNUMBER(this->quantity, int, jsonParam, "quantity");
    
    auto jsonValue = jsonParam.get("product");
    if(!jsonValue.is<picojson::null>())
        this->product = IAPV4Product(jsonValue);
    
    this->type = getIAPV4TypeFromJson(jsonParam);
}

IAPV4Receipt::~IAPV4Receipt(){
    
}

// IAPV4PurchaseParam class Implements
IAPV4PurchaseParam::IAPV4PurchaseParam()
{
}


IAPV4PurchaseParam::IAPV4PurchaseParam(picojson::value jsonParam)
{
    if(jsonParam.is<picojson::null>())
            return;

    picojson::value jsonValue;
    
    jsonValue = jsonParam.get("marketPid");
    if(jsonValue.is<picojson::null>() == false)
        this->marketPid = jsonValue.to_str();
    
    jsonValue = jsonParam.get("iapPayload");
    if(jsonValue.is<picojson::null>() == false)
        this->iapPayload = jsonValue.to_str();
    
    jsonValue = jsonParam.get("oldMarketPid");
    if(jsonValue.is<picojson::null>() == false)
        this->oldMarketPid = jsonValue.to_str();
    
    jsonValue = jsonParam.get("offerToken");
    if(jsonValue.is<picojson::null>() == false)
        this->offerToken = jsonValue.to_str();
}


picojson::object IAPV4PurchaseParam::toJson() const
{
    picojson::object resJson;
    
    resJson["marketPid"] = picojson::value(this->marketPid);
    resJson["iapPayload"] = picojson::value(this->iapPayload);
    resJson["oldMarketPid"] = picojson::value(this->oldMarketPid);
    resJson["offerToken"] = picojson::value(this->offerToken);
    return resJson;
}


std::string IAPV4PurchaseParam::toString() const
{
    picojson::object resJson = this->toJson();
    std::string resJsonString = picojson::value(resJson).serialize();
    return resJsonString;
}

IAPV4ConsumeInfoUserAgreement::IAPV4ConsumeInfoUserAgreement()
:didAgree(false)
,firstAnsweredDate(0)
,lastAnsweredDate(0){
}

IAPV4ConsumeInfoUserAgreement::IAPV4ConsumeInfoUserAgreement(picojson::value const jsonParam)
{
    if (jsonParam.is<picojson::null>())
        return;
    
    picojson::value jsonValue;
    
    jsonValue = jsonParam.get("didAgree");
    if (jsonValue.is<picojson::null>() == false)
        this->didAgree = jsonValue.get<bool>();
    
    jsonValue = jsonParam.get("firstAnsweredDate");
    if (jsonValue.is<picojson::null>() == false)
        this->firstAnsweredDate = jsonValue.get<int64_t>();
    
    jsonValue = jsonParam.get("lastAnsweredDate");
    if (jsonValue.is<picojson::null>() == false)
        this->lastAnsweredDate = jsonValue.get<int64_t>();
}

NS_HIVE_END

#endif