//
//  HIVE_PlatformHelper.cpp
//  HIVE_SDK_Plugin
//
//  Created by 김재원 on 2017. 3. 3..
//  Copyright © 2017년 GCP. All rights reserved.
//
#include "HIVE_PlatformHelper.h"
#include "HIVE_CppPlugin.h"

#if !WITH_EDITOR && PLATFORM_WINDOWS

NS_HIVE_BEGIN

static PlatformHelper::onHIVEPlatformHelperShareHandler g_shareTextCB = NULL;

static PlatformHelper::onHIVEPlatformHelperShareHandler g_shareMediaCB = NULL;

static PlatformHelper::onRequestUserPermissionsHandler g_requestUserPermissionsCB = NULL;

static PlatformHelper::onShowInAppBrowserHandler g_showInAppBrowserCB = NULL;

static PlatformHelper::onShowInAppWebViewHandler g_showInAppWebViewCB = NULL;

static PlatformHelper::onParameters g_getLaunchParametersCB = NULL;

void PlatformHelper::share(PlatformShare platformShare, onHIVEPlatformHelperShareHandler handler)
{
    picojson::object jsonParam = HiveCppPlugin::createParam("PlatformHelper", "share");
    
    int shareTypeInt = platformShare.getShareTypeInt();
    std::vector<std::string> paths = platformShare.getMedia();
    std::string subject = platformShare.getSubject();
    std::string text = platformShare.getText();
    
    picojson::array jsonArray;
    for (std::vector<std::string>::iterator it = paths.begin(); it != paths.end(); ++it) {
        jsonArray.push_back(picojson::value((*it)));
    }
    jsonParam["shareType"] = picojson::value((double)shareTypeInt);
    jsonParam["shareMedia"] = picojson::value(jsonArray);
    jsonParam["shareSubject"] = picojson::value(subject);
    jsonParam["shareText"] = picojson::value(text);
    
    g_shareMediaCB = handler;
    
    HiveCppPlugin::callNative(jsonParam);
}

void PlatformHelper::requestUserPermissions(std::vector<std::string> requests, onRequestUserPermissionsHandler handler)
{
    picojson::object jsonParam = HiveCppPlugin::createParam("PlatformHelper", "requestUserPermissions");

    picojson::array jsonArray;
    for (std::vector<std::string>::iterator it = requests.begin(); it != requests.end(); ++it) {
        jsonArray.push_back(picojson::value(*it));
    }
    jsonParam["requests"] = picojson::value(jsonArray);

    g_requestUserPermissionsCB = handler;

    HiveCppPlugin::callNative(jsonParam);
}

void PlatformHelper::completeUpdate(int completeState)
{
    picojson::object jsonParam = HiveCppPlugin::createParam("PlatformHelper", "completeUpdate");

    jsonParam["shareType"] = picojson::value((double)completeState);

    HiveCppPlugin::callNative(jsonParam);
}

void PlatformHelper::showInAppBrowser(InAppBrowserParam param, onShowInAppBrowserHandler handler)
{
    picojson::object jsonParam = HiveCppPlugin::createParam("PlatformHelper", "showInAppBrowser");
    
    jsonParam["param"] = picojson::value(param.toString());

    g_showInAppBrowserCB = handler;

    HiveCppPlugin::callNative(jsonParam);
}

void PlatformHelper::showInAppWebView(InAppWebViewParam param, onShowInAppWebViewHandler handler)
{
    picojson::object jsonParam = HiveCppPlugin::createParam("PlatformHelper", "showInAppWebView");
    
    jsonParam["param"] = picojson::value(param.toString());

    g_showInAppWebViewCB = handler;

    HiveCppPlugin::callNative(jsonParam);
}

void PlatformHelper::openBrowser(const OpenBrowserParam param) {
    //  NOT Support Mobile.
    picojson::object jsonParam = HiveCppPlugin::createParam("PlatformHelper", "openBrowser");

    jsonParam["url"] = picojson::value(param.url);
    jsonParam["useIncognitoMode"] = picojson::value(param.useIncognitoMode);

    HiveCppPlugin::callNative(jsonParam);
}

void PlatformHelper::getLaunchParameters(onParameters handler)
{
    picojson::object jsonParam = HiveCppPlugin::createParam("PlatformHelper", "getLaunchParameters");

    g_getLaunchParametersCB = handler;

    HiveCppPlugin::callNative(jsonParam);
}

void PlatformHelper::executeEngine(picojson::value jsonParam)
{
    ResultAPI result(jsonParam.get("resultAPI"));
    
    std::string methodName = jsonParam.get("method").to_str();
    if(methodName.compare("shareText") == 0)
    {
        if(g_shareTextCB != NULL)
        {
            bool isSuccess = jsonParam.get("isSuccess").get<bool>();
            g_shareTextCB(isSuccess);
        }
    }
    else if(methodName.compare("shareMedia") == 0)
    {
        if( g_shareMediaCB != NULL)
        {
            bool isSuccess = jsonParam.get("isSuccess").get<bool>();
            g_shareMediaCB(isSuccess);
        }
        
    }
    else if(methodName.compare("requestUserPermissions") == 0)
    {
        if (g_requestUserPermissionsCB != NULL)
        {
            std::vector<std::string> grantedVector;
            picojson::value grantedJson = jsonParam.get("granted");

            if (!grantedJson.is<picojson::null>()) {
                picojson::array arrayGranted = grantedJson.get<picojson::array>();

                for (auto it=arrayGranted.begin(); it!=arrayGranted.end(); ++it) {
                    std::string str = (*it).to_str();
                    grantedVector.push_back(str);
                }
            }
            std::vector<std::string> deniedVector;
            picojson::value deniedJson = jsonParam.get("denied");

            if (!deniedJson.is<picojson::null>()) {
                picojson::array arrayDenied = jsonParam.get("denied").get<picojson::array>();

                for (auto it=arrayDenied.begin(); it!=arrayDenied.end(); ++it) {
                    std::string str = (*it).to_str();
                    deniedVector.push_back(str);
                }
            }
            g_requestUserPermissionsCB(result, grantedVector, deniedVector);
        }
    }
    else if (methodName.compare("showInAppBrowser") == 0)
    {
        if (g_showInAppBrowserCB == NULL) {
            return;
        }
        g_showInAppBrowserCB(result);
    }
    else if (methodName.compare("showInAppWebView") == 0)
    {
        if (g_showInAppWebViewCB == NULL) {
            return;
        }
        g_showInAppWebViewCB(result);
    }
    else if (methodName.compare("getLaunchParameters") == 0)
    {
        if (g_getLaunchParametersCB == NULL) {
            return;
        }

        std::string parameters = jsonParam.get("parameters").to_str();


        g_getLaunchParametersCB(result, parameters.c_str());
    }
}

PlatformShare::PlatformShare()
{
    
}

PlatformShare::~PlatformShare()
{
    
}

PlatformShareType PlatformShare::getShareType()
{
    return this->shareType;
}

int PlatformShare::getShareTypeInt()
{
    int typeNum = 2;
    switch(this->shareType){
        case PlatformShareType::TEXT:
            typeNum = 1;
            break;
        case PlatformShareType::MEDIA:
            typeNum = 2;
            break;
        default:
            typeNum = 2;
            break;
    }
    return typeNum;
}

void PlatformShare::setShareType(PlatformShareType _shareType)
{
    this->shareType = _shareType;
}

std::string PlatformShare::getSubject()
{
    return this->subject;
}

void PlatformShare::setSubject(std::string _subject)
{
    this->subject = _subject;
}

std::string PlatformShare::getText()
{
    return this->text;
}

void PlatformShare::setText(std::string _text)
{
    this->text = _text;
}

std::vector<std::string> PlatformShare::getMedia()
{
    return this->paths;
}

void PlatformShare::setMedia(std::vector<std::string> _paths)
{
    this->paths = _paths;
}

// InAppBrowserParam class Implements
InAppBrowserParam::InAppBrowserParam(std::string url)
{
    this->url = url;
}


InAppBrowserParam::InAppBrowserParam(picojson::value jsonParam)
{
    if (jsonParam.is<picojson::null>())
            return;

    picojson::value jsonValue;
    
    jsonValue = jsonParam.get("url");
    if (jsonValue.is<picojson::null>() == false)
        this->url = jsonValue.to_str();
    
    jsonValue = jsonParam.get("navigationColor");
    if (jsonValue.is<picojson::null>() == false)
        this->navigationColor = jsonValue.to_str();
    
    jsonValue = jsonParam.get("buttonColor");
    if (jsonValue.is<picojson::null>() == false)
        this->buttonColor = jsonValue.to_str();
    
    jsonValue = jsonParam.get("urlBarHiding");
    if (jsonValue.is<picojson::null>() == false)
        this->urlBarHiding = jsonValue.evaluate_as_boolean();
    
    jsonValue = jsonParam.get("autoRedirectToExternalBrowser");
    if (jsonValue.is<picojson::null>() == false)
        this->autoRedirectToExternalBrowser = jsonValue.evaluate_as_boolean();
}

picojson::object InAppBrowserParam::toJson() const
{
    picojson::object resJson;
    
    resJson["url"] = picojson::value(this->url);
    resJson["navigationColor"] = picojson::value(this->navigationColor);
    resJson["buttonColor"] = picojson::value(this->buttonColor);
    resJson["urlBarHiding"] = picojson::value(this->urlBarHiding);
    resJson["autoRedirectToExternalBrowser"] = picojson::value(this->autoRedirectToExternalBrowser);
    return resJson;
}

std::string InAppBrowserParam::toString() const
{
    picojson::object resJson = this->toJson();
    std::string resJsonString = picojson::value(resJson).serialize();
    return resJsonString;
}

// InAppWebViewParam class Implements
InAppWebViewParam::InAppWebViewParam(std::string url)
{
    this->url = url;
}


InAppWebViewParam::InAppWebViewParam(picojson::value jsonParam)
{
    if (jsonParam.is<picojson::null>())
            return;

    picojson::value jsonValue;
    
    jsonValue = jsonParam.get("url");
    if (jsonValue.is<picojson::null>() == false)
        this->url = jsonValue.to_str();
    
    jsonValue = jsonParam.get("useUserSession");
    if (jsonValue.is<picojson::null>() == false)
        this->useUserSession = jsonValue.evaluate_as_boolean();
    
    jsonValue = jsonParam.get("postData");
    if (jsonValue.is<picojson::null>() == false)
        this->postData = jsonValue.to_str();
}

picojson::object InAppWebViewParam::toJson() const
{
    picojson::object resJson;
    
    resJson["url"] = picojson::value(this->url);
    resJson["useUserSession"] = picojson::value(this->useUserSession);
    resJson["postData"] = picojson::value(this->postData);
    return resJson;
}

std::string InAppWebViewParam::toString() const
{
    picojson::object resJson = this->toJson();
    std::string resJsonString = picojson::value(resJson).serialize();
    return resJsonString;
}

OpenBrowserParam::OpenBrowserParam(const std::string& url) {
    this->url = url;
}

NS_HIVE_END

#endif