#include "HIVE_Promotion.h"
#include "HIVE_CppPlugin.h"
#include <sstream>

//#pragma clang diagnostic push
//#pragma clang diagnostic ignored "-Wunused-function"
#if !WITH_EDITOR && PLATFORM_WINDOWS

NS_HIVE_BEGIN


static Promotion::onPromotionView g_onPromotionView = NULL;

static Promotion::onPromotionViewInfo g_onPromotionViewInfo = NULL;

static Promotion::onPromotionBadgeInfo g_onPromotionBadgeInfo = NULL;

static Promotion::onPromotionBannerInfo g_onPromotionBannerInfo = NULL;

static Promotion::onAppInvitationData g_onAppInvitationData = NULL;

static Promotion::onAppInvitationSenderInfo g_onAppInvitationSenderInfo = NULL;

static Promotion::onEngagement g_EngagementListener = nullptr;

static Promotion::onPromotionUAShare g_ShowUAShare = nullptr;

int char2int(char input);
std::vector<char> hexToBytesteeam(const std::string& byte);
std::string bytestreamToHex(const std::vector<char>& stream);

int char2int(char input)
{
    if(input >= '0' && input <= '9')
        return input - '0';
    if(input >= 'A' && input <= 'F')
        return input - 'A' + 10;
    if(input >= 'a' && input <= 'f')
        return input - 'a' + 10;
    return 0;//TODO Assert
}

std::string stringToLowerCase(std::string str)
{
    std::string result = str;
    std::transform(result.begin(), result.end(), result.begin(),
                            [](unsigned char const &c){
                                return ::tolower(c);
                            });
    return result;
}

std::string bytestreamToHex(const std::vector<char>& stream){
    std::stringstream ss;
    for(auto bin:stream){
        ss << std::hex << (int)bin;
    }
    return ss.str();
}
std::vector<char> hexToBytesteeam(const std::string& byte){
    const char* src = byte.c_str();
    std::vector<char> target;
    while(*src && src[1])
    {
        target.push_back(char2int(*src)*16 + char2int(src[1]));
        src += 2;
    }
    return target;
}

static std::string PromotionTypeToString(PromotionType promotionType)
{
	if(promotionType == PromotionType::BANNER)
		return "BANNER";
	else if(promotionType == PromotionType::NEWS)
		return "NEWS";
    else if(promotionType == PromotionType::NOTICE)
		return "NOTICE";
    else
        return "BANNERLEGACY";
}


static std::string PromotionCustomTypeToString(PromotionCustomType customType)
{
    if(customType == PromotionCustomType::VIEW)
        return "VIEW";
    else if(customType == PromotionCustomType::BOARD)
        return "BOARD";
    else if(customType == PromotionCustomType::SPOT)
        return "SPOT";
    else
        return "DIRECT";
}

static std::string PromotionCampaignTypeToString(PromotionCampaignType campaignType)
{
    if (campaignType == PromotionCampaignType::EVENT)
        return "EVENT";
    else if (campaignType == PromotionCampaignType::NOTICE)
        return "NOTICE";
    else if (campaignType == PromotionCampaignType::ALL)
        return "ALL";
    else if (campaignType == PromotionCampaignType::CROSS)
        return "CROSS";
    else
        return "EVENT";
}

static std::string PromotionBannerTypeToString(PromotionBannerType bannerType)
{
    if (bannerType == PromotionBannerType::GREAT)
        return "GREAT";
    else if (bannerType == PromotionBannerType::SMALL)
        return "SMALL";
    else if (bannerType == PromotionBannerType::ROLLING)
        return "ROLLING";
    else
        return "ROLLING";
}


static PromotionEventType StringToPromotionEvent(std::string promotionEventString)
{
    PromotionEventType promotionEventType = PromotionEventType::CLOSE;
    if(promotionEventString.compare("OPEN") == 0)
        promotionEventType = PromotionEventType::OPEN;
    else if(promotionEventString.compare("CLOSE") == 0)
        promotionEventType = PromotionEventType::CLOSE;
    else if(promotionEventString.compare("START_PLAYBACK") == 0)
        promotionEventType = PromotionEventType::START_PLAYBACK;
    else if(promotionEventString.compare("FINISH_PLAYBACK") == 0)
        promotionEventType = PromotionEventType::FINISH_PLAYBACK;
    else if(promotionEventString.compare("EXIT") == 0)
        promotionEventType = PromotionEventType::EXIT;
    
    return promotionEventType;
}


static PromotionBadgeTarget StringToPromotionBadgeTarget(std::string promotionBadgeTargetString)
{
	if(promotionBadgeTargetString.compare("NEWS") == 0)
		return PromotionBadgeTarget::NEWS;
	else if(promotionBadgeTargetString.compare("NOTICE") == 0)
		return PromotionBadgeTarget::NOTICE;
	else if(promotionBadgeTargetString.compare("CUSTOMVIEW") == 0)
		return PromotionBadgeTarget::CUSTOMVIEW;
    else
        return PromotionBadgeTarget::CUSTOMBOARD;
}


static std::string PromotionBadgeTargetToString(PromotionBadgeTarget promotionBadgeTarget)
{
	if(promotionBadgeTarget == PromotionBadgeTarget::NEWS)
		return "NEWS";
	else if(promotionBadgeTarget == PromotionBadgeTarget::NOTICE)
		return "NOTICE";
	else if(promotionBadgeTarget == PromotionBadgeTarget::CUSTOMVIEW)
		return "CUSTOMVIEW";
	else
		return "CUSTOMBOARD";
}


static EngagementEventType StringToEngagementEventType(std::string engagementEventTypeString)
{
    if(engagementEventTypeString.compare("EVENT_TYPE") == 0)
        return EngagementEventType::EVENT_TYPE;
    else if(engagementEventTypeString.compare("PROMOTION_VIEW") == 0)
        return EngagementEventType::PROMOTION_VIEW;
    else if(engagementEventTypeString.compare("OFFERWALL_VIEW") == 0)
        return EngagementEventType::OFFERWALL_VIEW;
    else if(engagementEventTypeString.compare("USER_ACQUISITION") == 0)
        return EngagementEventType::USER_ACQUISITION;
    else if(engagementEventTypeString.compare("COUPON") == 0)
        return EngagementEventType::COUPON;
    else if(engagementEventTypeString.compare("AUTH_LOGIN_VIEW") == 0)
        return EngagementEventType::AUTH_LOGIN_VIEW;
    else if(engagementEventTypeString.compare("SOCIAL_INQUIRY_VIEW") == 0)
        return EngagementEventType::SOCIAL_INQUIRY_VIEW;
    else if(engagementEventTypeString.compare("EVENT") == 0)
        return EngagementEventType::EVENT;
    else if(engagementEventTypeString.compare("IAP_UPDATED") == 0)
        return EngagementEventType::IAP_UPDATED;
    else if(engagementEventTypeString.compare("IAP_PURCHASE") == 0)
        return EngagementEventType::IAP_PURCHASE;
    else if(engagementEventTypeString.compare("IAP_PROMOTE") == 0)
        return EngagementEventType::IAP_PROMOTE;
    else if(engagementEventTypeString.compare("COMPANION") == 0)
        return EngagementEventType::COMPANION;
    else if(engagementEventTypeString.compare("SOCIAL_MYINQUIRY_VIEW") == 0)
        return EngagementEventType::SOCIAL_MYINQUIRY_VIEW;
    else if(engagementEventTypeString.compare("SOCIAL_PROFILE_VIEW") == 0)
        return EngagementEventType::SOCIAL_PROFILE_VIEW;
    else if(engagementEventTypeString.compare("COMMUNITY_VIEW") == 0)
        return EngagementEventType::COMMUNITY_VIEW;
    else if(engagementEventTypeString.compare("APPUPDATE_DOWNLOADED") == 0)
        return EngagementEventType::APPUPDATE_DOWNLOADED;
    else
        return EngagementEventType::EVENT_TYPE;
}


static std::string EngagementEventTypeToString(EngagementEventType engagementEventType)
{
    if(engagementEventType == EngagementEventType::EVENT_TYPE)
        return "EVENT_TYPE";
    else if(engagementEventType == EngagementEventType::PROMOTION_VIEW)
        return "PROMOTION_VIEW";
    else if(engagementEventType == EngagementEventType::OFFERWALL_VIEW)
        return "OFFERWALL_VIEW";
    else if(engagementEventType == EngagementEventType::USER_ACQUISITION)
        return "USER_ACQUISITION";
    else if(engagementEventType == EngagementEventType::COUPON)
        return "COUPON";
    else if(engagementEventType == EngagementEventType::AUTH_LOGIN_VIEW)
        return "AUTH_LOGIN_VIEW";
    else if(engagementEventType == EngagementEventType::SOCIAL_INQUIRY_VIEW)
        return "SOCIAL_INQUIRY_VIEW";
    else if(engagementEventType == EngagementEventType::EVENT)
        return "EVENT";
    else if(engagementEventType == EngagementEventType::IAP_UPDATED)
        return "IAP_UPDATED";
    else if(engagementEventType == EngagementEventType::IAP_PURCHASE)
        return "IAP_PURCHASE";
    else if(engagementEventType == EngagementEventType::IAP_PROMOTE)
        return "IAP_PROMOTE";
    else if(engagementEventType == EngagementEventType::COMPANION)
        return "COMPANION";
    else if(engagementEventType == EngagementEventType::SOCIAL_MYINQUIRY_VIEW)
        return "SOCIAL_MYINQUIRY_VIEW";
    else if(engagementEventType == EngagementEventType::SOCIAL_PROFILE_VIEW)
        return "SOCIAL_PROFILE_VIEW";
    else if(engagementEventType == EngagementEventType::COMMUNITY_VIEW)
        return "COMMUNITY_VIEW";
    else if(engagementEventType == EngagementEventType::APPUPDATE_DOWNLOADED)
        return "APPUPDATE_DOWNLOADED";
    else
        return "EVENT_TYPE";
}

static EngagementEventState StringToEngagementEventState(std::string engagementEventStateString)
{
    if(engagementEventStateString.compare("BEGIN") == 0)
        return EngagementEventState::BEGIN;
    else if(engagementEventStateString.compare("FINISH") == 0)
        return EngagementEventState::FINISH;
    else if(engagementEventStateString.compare("START") == 0)
        return EngagementEventState::EVENT_START;
    else if(engagementEventStateString.compare("END") == 0)
        return EngagementEventState::EVENT_END;
    else
        return EngagementEventState::BEGIN;
}


static std::string EngagementEventStateToString(EngagementEventState engagementEventState)
{
    if(engagementEventState == EngagementEventState::BEGIN)
        return "BEGIN";
    else if(engagementEventState == EngagementEventState::FINISH)
        return "FINISH";
    else if(engagementEventState == EngagementEventState::EVENT_START)
        return "START";
    else if(engagementEventState == EngagementEventState::EVENT_END)
        return "END";
    else
        return "BEGIN";
}


void Promotion::showPromotion(PromotionType promotionType, bool isForced, onPromotionView listener)
{
	g_onPromotionView = listener;


	picojson::object jsonParam = HiveCppPlugin::createParam("Promotion", "showPromotion");

	std::string promotionTypeString = PromotionTypeToString(promotionType);
	jsonParam["promotionType"] = picojson::value(promotionTypeString);

	jsonParam["isForced"] = picojson::value(isForced);

	HiveCppPlugin::callNative(jsonParam);

}


void Promotion::showCustomContents(PromotionCustomType customType, std::string contentsKey, onPromotionView listener)
{
	g_onPromotionView = listener;

    picojson::object jsonParam = HiveCppPlugin::createParam("Promotion", "showCustomContents");
    
    std::string customTypeString = PromotionCustomTypeToString(customType);
    jsonParam["customType"] = picojson::value(customTypeString);
    
	jsonParam["contentsKey"] = picojson::value(contentsKey);

	HiveCppPlugin::callNative(jsonParam);
}

void Promotion::showCustomContentsOnGameWindow(PromotionCustomType customType, std::string contentsKey, onPromotionView listener)
{
    g_onPromotionView = listener;

    picojson::object jsonParam = HiveCppPlugin::createParam("Promotion", "showCustomContentsOnGameWindow");

    std::string customTypeString = PromotionCustomTypeToString(customType);
    jsonParam["customType"] = picojson::value(customTypeString);

    jsonParam["contentsKey"] = picojson::value(contentsKey);

    HiveCppPlugin::callNative(jsonParam);
}


OfferwallState Promotion::getOfferwallState()
{
    picojson::object jsonParam = HiveCppPlugin::createParam("Promotion", "getOfferwallState");
    
    picojson::value resJson = HiveCppPlugin::callNative(jsonParam);
    
    picojson::value offerwallState = resJson.get("offerwallState");
    if(offerwallState.is<picojson::null>() == false)
    {
        std::string value = offerwallState.to_str();
        if(value.compare("ENABLED") == 0)
            return OfferwallState::ENABLED;
        else if(value.compare("DISABLED") == 0)
            return OfferwallState::DISABLED;
    }
    
    return OfferwallState::UNKNOWN;
}


void Promotion::showOfferwall(onPromotionView listener)
{
	g_onPromotionView = listener;


	picojson::object jsonParam = HiveCppPlugin::createParam("Promotion", "showOfferwall");

	HiveCppPlugin::callNative(jsonParam);
}


void Promotion::showNews(std::string menu, std::vector<int> giftPidList, onPromotionView listener)
{
    g_onPromotionView = listener;
    picojson::array jsonArray;
    for (std::vector<int>::iterator it = giftPidList.begin(); it != giftPidList.end(); ++it) {
        jsonArray.push_back(picojson::value((to_string(*it))));
    }


    picojson::object jsonParam = HiveCppPlugin::createParam("Promotion", "showNews");

    jsonParam["menu"] = picojson::value(menu);
    jsonParam["giftPidList"] = picojson::value(jsonArray);

    HiveCppPlugin::callNative(jsonParam);
}


void Promotion::showNativeReview(onPromotionView listener)
{
    g_onPromotionView = listener;
    
    
    picojson::object jsonParam = HiveCppPlugin::createParam("Promotion", "showNativeReview");
    
    HiveCppPlugin::callNative(jsonParam);
}

void Promotion::showReview(onPromotionView listener)
{
    g_onPromotionView = listener;


    picojson::object jsonParam = HiveCppPlugin::createParam("Promotion", "showReview");

    HiveCppPlugin::callNative(jsonParam);
}


void Promotion::showExit(onPromotionView listener)
{
	g_onPromotionView = listener;


	picojson::object jsonParam = HiveCppPlugin::createParam("Promotion", "showExit");

	HiveCppPlugin::callNative(jsonParam);
}


void Promotion::getViewInfo(PromotionCustomType customType, std::string contentsKey, onPromotionViewInfo listener)
{
	g_onPromotionViewInfo = listener;

	picojson::object jsonParam = HiveCppPlugin::createParam("Promotion", "getViewInfo");
    
    std::string customTypeString = PromotionCustomTypeToString(customType);
    jsonParam["customType"] = picojson::value(customTypeString);
    
    jsonParam["contentsKey"] = picojson::value(contentsKey);

	HiveCppPlugin::callNative(jsonParam);
}


void Promotion::getBadgeInfo(onPromotionBadgeInfo listener)
{
	g_onPromotionBadgeInfo = listener;

	picojson::object jsonParam = HiveCppPlugin::createParam("Promotion", "getBadgeInfo");

	HiveCppPlugin::callNative(jsonParam);
}

void Promotion::getBannerInfo(PromotionCampaignType campaignType, PromotionBannerType bannerType, onPromotionBannerInfo listener)
{
    g_onPromotionBannerInfo = listener;

    picojson::object jsonParam = HiveCppPlugin::createParam("Promotion", "getBannerInfo");
    std::string campaignTypeStr = stringToLowerCase(PromotionCampaignTypeToString(campaignType));
    jsonParam["campaignType"] = picojson::value(campaignTypeStr);

    std::string bannerTypeStr = stringToLowerCase(PromotionBannerTypeToString(bannerType));
    jsonParam["bannerType"] = picojson::value(bannerTypeStr);

    HiveCppPlugin::callNative(jsonParam);
}

void Promotion::getBannerInfoString(std::string campaignString, std::string bannerString, onPromotionBannerInfo listener)
{
    g_onPromotionBannerInfo = listener;

    picojson::object jsonParam = HiveCppPlugin::createParam("Promotion", "getBannerInfoString");
    jsonParam["campaignType"] = picojson::value(campaignString);

    jsonParam["bannerType"] = picojson::value(bannerString);

    HiveCppPlugin::callNative(jsonParam);
}


void Promotion::getAppInvitationData(onAppInvitationData listener)
{
    g_onAppInvitationData = listener;
    
    picojson::object jsonParam = HiveCppPlugin::createParam("Promotion", "getAppInvitationData");
    
    HiveCppPlugin::callNative(jsonParam);
}


void Promotion::getAppInvitationSenderInfo(onAppInvitationSenderInfo listener)
{
    g_onAppInvitationSenderInfo = listener;

    picojson::object jsonParam = HiveCppPlugin::createParam("Promotion", "getAppInvitationSenderInfo");

    HiveCppPlugin::callNative(jsonParam);
}


void Promotion::setAdditionalInfo(std::string additionalInfo)
{
	picojson::object jsonParam = HiveCppPlugin::createParam("Promotion", "setAdditionalInfo");
	jsonParam["setAdditionalInfo"] = picojson::value(additionalInfo);

	HiveCppPlugin::callNative(jsonParam);
}

ResultAPI Promotion::setEngagementReady(bool isReady) {
    picojson::object jsonParam = HiveCppPlugin::createParam("Promotion", "setEngagementReady");
    
    jsonParam["isReady"] = picojson::value(isReady);
    
    return ResultAPI(HiveCppPlugin::callNative(jsonParam));
    
}

void Promotion::setEngagementHandler(onEngagement engagementHandler) {
    g_EngagementListener = engagementHandler;
    picojson::object jsonParam = HiveCppPlugin::createParam("Promotion", "setEngagementHandler");
    HiveCppPlugin::callNative(jsonParam);
    
}

void Promotion::showUAShare(std::string inviteMessage, std::string inviteLink, onPromotionUAShare uaShareHandler) {
    g_ShowUAShare = uaShareHandler;
    picojson::object jsonParam = HiveCppPlugin::createParam("Promotion", "showUAShare");
	jsonParam["inviteMessage"] = picojson::value(inviteMessage);
	jsonParam["inviteLink"] = picojson::value(inviteLink);

	
    HiveCppPlugin::callNative(jsonParam);
    
}

bool Promotion::processURI(std::string URI) {
    
    picojson::object jsonParam = HiveCppPlugin::createParam("Promotion", "processURI");
    jsonParam["URI"] = picojson::value(URI);
    
    picojson::value resJson =  HiveCppPlugin::callNative(jsonParam);
    picojson::value jsonValue = resJson.get("processURI");
    bool result = false;
    if (jsonValue.is<picojson::null>() == false)
        result = jsonValue.evaluate_as_boolean();

    return result;
}
void Promotion::updatePromotionData() {
    picojson::object jsonParam = HiveCppPlugin::createParam("Promotion", "updatePromotionData");
    HiveCppPlugin::callNative(jsonParam);
    
}

void Promotion::executeEngine(picojson::value jsonParam)
{
	ResultAPI result(jsonParam.get("resultAPI"));
    
    
	std::string methodName = jsonParam.get("method").to_str();
	if(methodName.compare("getViewInfo") == 0)
    {
        if(g_onPromotionViewInfo != NULL)
        {
            std::vector<PromotionViewInfo> viewInfoList;
            
            picojson::array viewInfoListJson;
            
            if(jsonParam.get("viewInfoList").is<picojson::null>() == false)
                viewInfoListJson = jsonParam.get("viewInfoList").get<picojson::array>();
            
            for (picojson::array::iterator iter = viewInfoListJson.begin(); iter != viewInfoListJson.end(); ++iter)
            {
                PromotionViewInfo viewInfo;
                viewInfo.parse((*iter));
                
                viewInfoList.push_back(viewInfo);
            }

        	g_onPromotionViewInfo(result, viewInfoList);
        }
    }
    else if(methodName.compare("getBadgeInfo") == 0)
    {
        if(g_onPromotionBadgeInfo != NULL)
        {
        	std::vector<PromotionBadgeInfo> badgeInfoList;
            picojson::array badgeInfoListJson;
            
            if(jsonParam.get("badgeInfoList").is<picojson::null>() == false)
                badgeInfoListJson = jsonParam.get("badgeInfoList").get<picojson::array>();
            
            for (picojson::array::iterator iter = badgeInfoListJson.begin(); iter != badgeInfoListJson.end(); ++iter)
            {
            	PromotionBadgeInfo badgeInfo;
            	badgeInfo.parse((*iter));

            	badgeInfoList.push_back(badgeInfo);
            }

        	g_onPromotionBadgeInfo(result, badgeInfoList);
        }
    }
    else if(methodName.compare("getBannerInfo") == 0)
    {
        if(g_onPromotionBannerInfo != NULL)
        {
            std::vector<PromotionBannerInfo> bannerInfoList;
            picojson::array bannerInfoListJson;

            if(jsonParam.get("bannerInfoList").is<picojson::null>() == false)
                bannerInfoListJson = jsonParam.get("bannerInfoList").get<picojson::array>();

            for (picojson::array::iterator iter = bannerInfoListJson.begin(); iter != bannerInfoListJson.end(); ++iter)
            {
                PromotionBannerInfo bannerInfo;
                bannerInfo.parse((*iter));

                bannerInfoList.push_back(bannerInfo);
            }

            g_onPromotionBannerInfo(result, bannerInfoList);
        }
    }
    else if(methodName.compare("getBannerInfoString") == 0)
    {
        if(g_onPromotionBannerInfo != NULL)
        {
            std::vector<PromotionBannerInfo> bannerInfoList;
            picojson::array bannerInfoListJson;

            if(jsonParam.get("bannerInfoList").is<picojson::null>() == false)
                bannerInfoListJson = jsonParam.get("bannerInfoList").get<picojson::array>();

            for (picojson::array::iterator iter = bannerInfoListJson.begin(); iter != bannerInfoListJson.end(); ++iter)
            {
                PromotionBannerInfo bannerInfo;
                bannerInfo.parse((*iter));

                bannerInfoList.push_back(bannerInfo);
            }

            g_onPromotionBannerInfo(result, bannerInfoList);
        }
    }
    else if(methodName.compare("getAppInvitationData") == 0)
    {
        if(g_onAppInvitationData != NULL)
        {
            AppInvitationData appInvitationData;
            appInvitationData.parse(jsonParam.get("appInvitationData"));
            
            g_onAppInvitationData(result, appInvitationData);
        }
    }
    else if(methodName.compare("setEngagementHandler") == 0)
    {
        if(g_EngagementListener != NULL)
        {
            
            // Engagement Event Type
            std::string strTypeValue;
            picojson::value  jsonTypeValue = jsonParam.get("engagementEventType");
            if(jsonTypeValue.is<picojson::null>() == false)
                strTypeValue = jsonTypeValue.to_str();
            EngagementEventType  engagementEventType = StringToEngagementEventType(strTypeValue);
            
            
            // Engagement Event State
            std::string strStateValue;
            picojson::value jsonStateValue = jsonParam.get("engagementEventState");
            if(jsonStateValue.is<picojson::null>() == false)
                strStateValue = jsonStateValue.to_str();
            EngagementEventState engagementEventState = StringToEngagementEventState(strStateValue);
            
            // Parameter by Engagement Event Type
            picojson::value jsonValue = jsonParam.get("param");
            
            g_EngagementListener(result, engagementEventType, engagementEventState, jsonValue);
        }
    }
    else if(methodName.compare("showUAShare") == 0)
    {
        if(g_ShowUAShare != NULL)
        {
            g_ShowUAShare(result);
        }
    }
    else if(methodName.compare("getAppInvitationSenderInfo") == 0)
    {
        if(g_onAppInvitationSenderInfo != NULL)
        {
            AppInvitationSenderInfo senderInfo;
            senderInfo.parse(jsonParam.get("senderInfo"));
            g_onAppInvitationSenderInfo(result, senderInfo);
        }
    }
    else
	{
        if(g_onPromotionView != NULL)
        {
            std::string promotionEventTypeString;
            if(jsonParam.get("promotionEventType").is<picojson::null>() == false)
                promotionEventTypeString = jsonParam.get("promotionEventType").to_str();
            
            PromotionEventType promotionEventType = StringToPromotionEvent(promotionEventTypeString);
            
//            OfferwallReward offerwallReward;
//            offerwallReward.parse(jsonParam.get("offerwallReward"));
            
            g_onPromotionView(result, promotionEventType);
        }
	}
}
    
    
    
// OfferwallReward class Implements
//OfferwallReward::OfferwallReward()
//{
//}
//
//
//bool OfferwallReward::parse(picojson::value jsonParam)
//{
//    if(jsonParam.is<picojson::null>())
//        return false;
//
//    picojson::value jsonValue;
//    jsonValue = jsonParam.get("errorNo");
//    if(jsonValue.is<picojson::null>() == false)
//        this->errorNo = (int)jsonValue.get<double>();
//
//    jsonValue = jsonParam.get("errorMessage");
//    if(jsonValue.is<picojson::null>() == false)
//        this->errorMessage = jsonValue.to_str();
//
//    jsonValue = jsonParam.get("result");
//    if(jsonValue.is<picojson::null>() == false)
//        this->result = (int)jsonValue.get<double>();
//
//    jsonValue = jsonParam.get("eventID");
//    if(jsonValue.is<picojson::null>() == false)
//        this->eventID = (int)jsonValue.get<double>();
//
//    jsonValue = jsonParam.get("assetCode");
//    if(jsonValue.is<picojson::null>() == false)
//        this->assetCode = (int)jsonValue.get<double>();
//
//    jsonValue = jsonParam.get("assetAmount");
//    if(jsonValue.is<picojson::null>() == false)
//        this->assetAmount = (int)jsonValue.get<double>();
//
//    return true;
//}
//
//
//picojson::object OfferwallReward::toJson() const
//{
//    picojson::object resJson;
//    resJson["errorNo"] = picojson::value((double)this->errorNo);
//    resJson["errorMessage"] = picojson::value(this->errorMessage);
//    resJson["result"] = picojson::value((double)this->result);
//    resJson["eventID"] = picojson::value(this->eventID);
//    resJson["assetCode"] = picojson::value(this->assetCode);
//    resJson["assetAmount"] = picojson::value((double)this->assetAmount);
//    return resJson;
//}
//
//std::string OfferwallReward::toString() const
//{
//    picojson::object resJson = this->toJson();
//    std::string resJsonString = picojson::value(resJson).serialize();
//    return resJsonString;
//}



// PromotionViewInfo class Implements
PromotionViewInfo::PromotionViewInfo()
{

}


bool PromotionViewInfo::parse(picojson::value jsonParam)
{
    if(jsonParam.is<picojson::null>())
        return false;

    picojson::value jsonValue;

    jsonValue = jsonParam.get("postString");
    if(jsonValue.is<picojson::null>() == false)
        this->postString = jsonValue.to_str();

    jsonValue = jsonParam.get("url");
    if(jsonValue.is<picojson::null>() == false)
        this->url = jsonValue.to_str();
    
    return true;
}


picojson::object PromotionViewInfo::toJson() const
{
    picojson::object resJson;
    resJson["url"] = picojson::value(this->url);
    resJson["postString"] = picojson::value(this->postString);

    return resJson;
}

std::string PromotionViewInfo::toString() const
{
    picojson::object resJson = this->toJson();
    std::string resJsonString = picojson::value(resJson).serialize();
    return resJsonString;
}


// PromotionBadgeInfo class Implements
PromotionBadgeInfo::PromotionBadgeInfo()
{

}

bool PromotionBadgeInfo::parse(picojson::value jsonParam)
{
    if(jsonParam.is<picojson::null>())
        return false;

    picojson::value jsonValue;
    
    std::string promotionBadgeTargetString;
    
    jsonValue = jsonParam.get("target");
    if(jsonValue.is<picojson::null>() == false)
        promotionBadgeTargetString = jsonValue.to_str();
    this->target = StringToPromotionBadgeTarget(promotionBadgeTargetString);

    jsonValue = jsonParam.get("contentsKey");
    if(jsonValue.is<picojson::null>() == false)
        this->contentsKey = jsonValue.to_str();
    
    jsonValue = jsonParam.get("badgeType");
    if(jsonValue.is<picojson::null>() == false)
        this->badgeType = jsonValue.to_str();
    
    return true;
}


picojson::object PromotionBadgeInfo::toJson() const
{
    picojson::object resJson;

    std::string promotionBadgeTargetString = PromotionBadgeTargetToString(this->target);
    resJson["target"] = picojson::value(promotionBadgeTargetString);
    resJson["contentsKey"] = picojson::value(this->contentsKey);
    resJson["badgeType"] = picojson::value(this->badgeType);

    return resJson;
}

std::string PromotionBadgeInfo::toString() const
{
    picojson::object resJson = this->toJson();
    std::string resJsonString = picojson::value(resJson).serialize();
    return resJsonString;
}

//PromotionBannerInfo class implements
PromotionBannerInfo::PromotionBannerInfo()
{

}

bool PromotionBannerInfo::parse(picojson::value jsonParam)
{
    if(jsonParam.is<picojson::null>())
        return false;

    picojson::value jsonValue;

    jsonValue = jsonParam.get("pid");
    if(jsonValue.is<picojson::null>() == false)
        this->pid = (int)jsonValue.get<double>();

    jsonValue = jsonParam.get("imageUrl");
    if(jsonValue.is<picojson::null>() == false)
        this->imageUrl = jsonValue.to_str();

    jsonValue = jsonParam.get("linkUrl");
    if(jsonValue.is<picojson::null>() == false)
        this->linkUrl = jsonValue.to_str();

    jsonValue = jsonParam.get("displayStartDate");
    if(jsonValue.is<picojson::null>() == false)
        this->displayStartDate = jsonValue.to_str();

    jsonValue = jsonParam.get("displayEndDate");
    if(jsonValue.is<picojson::null>() == false)
        this->displayEndDate = jsonValue.to_str();

    jsonValue = jsonParam.get("utcStartDate");
    if(jsonValue.is<picojson::null>() == false)
        this->utcStartDate = (long)jsonValue.get<double>();

    jsonValue = jsonParam.get("utcEndDate");
    if(jsonValue.is<picojson::null>() == false)
        this->utcEndDate = (long)jsonValue.get<double>();

    jsonValue = jsonParam.get("typeLink");
    if(jsonValue.is<picojson::null>() == false)
        this->typeLink = jsonValue.to_str();

    jsonValue = jsonParam.get("typeBanner");
    if(jsonValue.is<picojson::null>() == false)
        this->typeBanner = jsonValue.to_str();

    jsonValue = jsonParam.get("typeCampaign");
    if(jsonValue.is<picojson::null>() == false)
        this->typeCampaign = jsonValue.to_str();

    jsonValue = jsonParam.get("interworkData");
    if(jsonValue.is<picojson::null>() == false)
        this->interworkData = jsonValue.to_str();


    return true;
}

picojson::object PromotionBannerInfo::toJson() const
{
    picojson::object resJson;

    std::stringstream ss;
    ss << this->pid;
    resJson["pid"] = picojson::value(ss.str());
    resJson["imageUrl"] = picojson::value(this->imageUrl);
    resJson["linkUrl"] = picojson::value(this->linkUrl);
    resJson["displayStartDate"] = picojson::value(this->displayStartDate);
    resJson["displayEndDate"] = picojson::value(this->displayEndDate);
    ss.str("");
    ss << this->utcStartDate;
    resJson["utcStartDate"] = picojson::value(ss.str());
    ss.str("");
    ss << this->utcEndDate;
    resJson["utcEndDate"] = picojson::value(ss.str());
    resJson["typeLink"] = picojson::value(this->typeLink);
    resJson["typeBanner"] = picojson::value(this->typeBanner);
    resJson["typeCampaign"] = picojson::value(this->typeCampaign);
    resJson["interworkData"] = picojson::value(this->interworkData);

    return resJson;
}

std::string PromotionBannerInfo::toString() const
{
    picojson::object resJson = this->toJson();
    std::string resJsonString = picojson::value(resJson).serialize();
    return resJsonString;
}


// AppInvitationData class Implements
AppInvitationData::AppInvitationData()
{
    
}

bool AppInvitationData::parse(picojson::value jsonParam)
{
    if(jsonParam.is<picojson::null>())
        return false;
    
    picojson::value jsonValue;
    
    jsonValue = jsonParam.get("qrcode");
    if(jsonValue.is<picojson::null>() == false) {
        this->qrCode = hexToBytesteeam(jsonValue.to_str());
    }
		

    jsonValue = jsonParam.get("inviteCommonLink");
    if(jsonValue.is<picojson::null>() == false)
        this->inviteCommonLink = jsonValue.to_str();
    
    jsonValue = jsonParam.get("inviteHivemsgLink");
    if(jsonValue.is<picojson::null>() == false)
    	this->inviteHivemsgLink = jsonValue.to_str();
    
    jsonValue = jsonParam.get("inviteFacebookLink");
    if(jsonValue.is<picojson::null>() == false)
    	this->inviteFacebookLink = jsonValue.to_str();
    
    jsonValue = jsonParam.get("eachCampaignList");
    if(jsonValue.is<picojson::null>() == false)
    {
    	this->eachCampaignList.clear();

    	picojson::array jsonArray = jsonValue.get<picojson::array>();
    	for (picojson::array::iterator iter = jsonArray.begin(); iter != jsonArray.end(); ++iter)
    	{
    		AppInvitationCampaign newObj;
    		newObj.parse((*iter));
    		this->eachCampaignList.push_back(newObj);
    	}
    }
    
    jsonValue = jsonParam.get("stageCampaignList");
    if(jsonValue.is<picojson::null>() == false)
	{
    	this->stageCampaignList.clear();

    	picojson::array jsonArray = jsonValue.get<picojson::array>();
    	for (picojson::array::iterator iter = jsonArray.begin(); iter != jsonArray.end(); ++iter)
    	{
    		AppInvitationCampaignStage newObj;
    		newObj.parse((*iter));
    		this->stageCampaignList.push_back(newObj);
    	}
	}
    
    return true;
}


picojson::object AppInvitationData::toJson() const
{
    picojson::object resJson;
    
    resJson["qrcode"] = picojson::value(bytestreamToHex(this->qrCode));
    resJson["inviteCommonLink"] = picojson::value(this->inviteCommonLink);
    resJson["inviteHivemsgLink"] = picojson::value(this->inviteHivemsgLink);
    resJson["inviteFacebookLink"] = picojson::value(this->inviteFacebookLink);
    
    picojson::array jsonArray;
    for(int i = 0; i< this->eachCampaignList.size(); i++)
    {
    	AppInvitationCampaign appInvitationCampaign = this->eachCampaignList[i];
    	jsonArray.push_back(picojson::value(appInvitationCampaign.toJson()));
    }
    resJson["eachCampaignList"] = picojson::value(jsonArray);

    jsonArray.clear();
    for(int i = 0; i< this->stageCampaignList.size(); i++)
    {
    	AppInvitationCampaign appInvitationCampaign = this->stageCampaignList[i];
    	jsonArray.push_back(picojson::value(appInvitationCampaign.toJson()));
    }
    resJson["stageCampaignList"] = picojson::value(jsonArray);

    return resJson;
}


std::string AppInvitationData::toString() const
{
    picojson::object resJson = this->toJson();
    std::string resJsonString = picojson::value(resJson).serialize();
    return resJsonString;
}

// AppInvitationCampaignStage class implements
AppInvitationCampaignStage::AppInvitationCampaignStage() {
	
}

bool AppInvitationCampaignStage::parse(picojson::value jsonParam)
{
	bool result = AppInvitationCampaign::parse(jsonParam);
	
	if (result)
	{
		picojson::value _goalCount = jsonParam.get("goalCount");
		picojson::value _goaltotal = jsonParam.get("goalTotal");
		
		if(_goalCount.is<picojson::null>() == false)
		{
			this->goalCount = _goalCount.get<double>();
		}
		
		if(_goaltotal.is<picojson::null>() == false)
		{
			this->goalTotal = _goaltotal.get<double>();
		}
		
		return true;
	}else {
		return false;
	}
}

// AppInvitationData class Implements
AppInvitationCampaign::AppInvitationCampaign()
{
    
}

bool AppInvitationCampaign::parse(picojson::value jsonParam)
{
    if(jsonParam.is<picojson::null>())
        return false;
    
    picojson::value jsonValue;
    
    jsonValue = jsonParam.get("title");
    if(jsonValue.is<picojson::null>() == false)
        this->title = jsonValue.to_str();
    
    jsonValue = jsonParam.get("description");
    if(jsonValue.is<picojson::null>() == false)
        this->description = jsonValue.to_str();
    
    jsonValue = jsonParam.get("imageUrl");
    if(jsonValue.is<picojson::null>() == false)
        this->imageUrl = jsonValue.to_str();

    jsonValue = jsonParam.get("order");
	if(jsonValue.is<picojson::null>() == false)
		this->order = (int)jsonValue.get<double>();

    jsonValue = jsonParam.get("item");
	if(jsonValue.is<picojson::null>() == false)
		this->item = jsonValue;

	jsonValue = jsonParam.get("count");
	if(jsonValue.is<picojson::null>() == false)
		this->count = (int)jsonValue.get<double>();

	jsonValue = jsonParam.get("limit");
	if(jsonValue.is<picojson::null>() == false)
		this->limit = (int)jsonValue.get<double>();

    jsonValue = jsonParam.get("campaignId");
    if(jsonValue.is<picojson::null>() == false)
        this->campaignId = jsonValue.to_str();
    
    return true;
}


picojson::object AppInvitationCampaign::toJson() const
{
    picojson::object resJson;
    
    resJson["title"] = picojson::value(this->title);
    resJson["description"] = picojson::value(this->description);
    resJson["imageUrl"] = picojson::value(this->imageUrl);
    resJson["item"] = this->item;
    resJson["count"] = picojson::value((double)this->count);
    resJson["limit"] = picojson::value((double)this->limit);
    resJson["order"] = picojson::value((double)this->order);
    resJson["campaignId"] = picojson::value(this->campaignId);

    return resJson;
}

std::string AppInvitationCampaign::toString() const
{
    picojson::object resJson = this->toJson();
    std::string resJsonString = picojson::value(resJson).serialize();
    return resJsonString;
}


AppInvitationSenderInfo::AppInvitationSenderInfo()
{

}

bool AppInvitationSenderInfo::parse(picojson::value jsonParam)
{
    if(jsonParam.is<picojson::null>())
        return false;

    picojson::value jsonValue;

    jsonValue = jsonParam.get("vid");
    if(jsonValue.is<picojson::null>() == false)
        this->vid = jsonValue.to_str();

    return true;
}

picojson::object AppInvitationSenderInfo::toJson() const
{
    picojson::object resJson;

    resJson["vid"] = picojson::value(this->vid);

    return resJson;
}

std::string AppInvitationSenderInfo::toString() const
{
    picojson::object resJson = this->toJson();
    std::string resJsonString = picojson::value(resJson).serialize();
    return resJsonString;
}





NS_HIVE_END		// namespace hive
#endif
//#pragma clang diagnostic pop
