#include "HIVE_ResultAPI.h"


#include "HIVE_CppPlugin.h"



#if __cplusplus>=201103L
# include <cmath>
#else
extern "C" {
# ifdef _MSC_VER
#  include <float.h>
# elif defined(__INTEL_COMPILER)
#  include <mathimf.h>
# else
#  include <math.h>
# endif
}
#endif


#ifdef _MSC_VER
    #define SNPRINTF _snprintf_s
    #pragma warning(push)
    #pragma warning(disable : 4244) // conversion from int to char
    #pragma warning(disable : 4127) // conditional expression is constant
    #pragma warning(disable : 4702) // unreachable code
#else
    #define SNPRINTF snprintf
#endif
#if !WITH_EDITOR && PLATFORM_WINDOWS

static std::string ITOA(double number)
{
	char buf[256] = "";
	double tmp;
	SNPRINTF(buf, sizeof(buf), fabs(number) < (1ULL << 53) && modf(number, &tmp) == 0 ? "%.f" : "%.17g", number);

	std::string retValue = buf;
	return retValue;
}


NS_HIVE_BEGIN


// ResultAPI class Implements
ResultAPI::ResultAPI()
{
	this->errorCode = 0;
	this->errorMessage = "success";
	this->message = "success";
	this->latencyMs = 0;
    this->code = CommonUnknown;
}


ResultAPI::ResultAPI(int argErrorCode, std::string argErrorMessage)
{
	this->errorCode = argErrorCode;
	this->errorMessage = argErrorMessage;
	this->message = argErrorMessage;
	this->latencyMs = 0;
    this->code = CommonUnknown;
}
ResultAPI::ResultAPI(int errorCode, Code code, std::string errorMessage)
{
    this->errorCode = errorCode;
    this->errorMessage = errorMessage;
	this->message = errorMessage;
    this->latencyMs = 0;
    this->code = code;
}

ResultAPI::ResultAPI(picojson::value jsonParam)
{
	this->errorCode = atoi(jsonParam.get("errorCode").to_str().c_str());
	this->errorMessage = jsonParam.get("errorMessage").to_str();
	this->message = jsonParam.get("message").to_str();
	this->latencyMs = atoi(jsonParam.get("latencyMs").to_str().c_str());
    this->code = static_cast<ResultAPI::Code>(atoi(jsonParam.get("code").to_str().c_str()));
}

bool ResultAPI::isSuccess() const
{
	return (this->errorCode >= 0 || this->code >= 0);
}

picojson::object ResultAPI::toJson() const
{
	picojson::object resJson;
	resJson["errorCode"] = picojson::value(ITOA(this->errorCode));
	resJson["errorMessage"] = picojson::value(this->errorMessage);
	resJson["message"] = picojson::value(this->message);
	resJson["latencyMs"] = picojson::value(ITOA(this->latencyMs));
    resJson["code"] = picojson::value(ITOA(this->code));
	return resJson;
}

ResultAPI::ErrorCode ResultAPI::getErrorCode() const {
    return static_cast<ErrorCode>(errorCode);
}

std::string ResultAPI::toString() const
{

	picojson::object resJson = this->toJson();
	std::string resJsonString = picojson::value(resJson).serialize();
	return resJsonString;
}

bool ResultAPI::needExit() const
{
    return (this->errorCode == NEED_EXIT);
}


NS_HIVE_END		// namespace hive

#endif