#include "HIVE_SocialV4.h"


#include "HIVE_CppPlugin.h"

#if !WITH_EDITOR && PLATFORM_WINDOWS

NS_HIVE_BEGIN



static SocialV4::onShowCommunity g_onShowCommunity = NULL;
static SocialV4::onSharePhoto g_onSharePhoto = NULL;


void SocialV4::showCommunity(ProviderType providerType, onShowCommunity listener)
{
	g_onShowCommunity = listener;
	picojson::object jsonParam = HiveCppPlugin::createParam("SocialV4", "showCommunity");;
	jsonParam["providerType"] = picojson::value(stringProviderType(providerType));
	HiveCppPlugin::callNative(jsonParam);
}

void SocialV4::showCommunity(ProviderType providerType, ViewType viewType, onShowCommunity listener)
{
    g_onShowCommunity = listener;
    picojson::object jsonParam = HiveCppPlugin::createParam("SocialV4", "showCommunity");;
    jsonParam["providerType"] = picojson::value(stringProviderType(providerType));
    jsonParam["viewType"] = picojson::value(stringViewType(viewType));
    HiveCppPlugin::callNative(jsonParam);
}


void SocialV4::sharePhoto(ProviderType providerType, onSharePhoto listener)
{
	g_onSharePhoto = listener;
	picojson::object jsonParam = HiveCppPlugin::createParam("SocialV4", "sharePhoto");;
	jsonParam["providerType"] = picojson::value(stringProviderType(providerType));
	HiveCppPlugin::callNative(jsonParam);
}


std::string SocialV4::stringProviderType(ProviderType providerType)
{
	switch(providerType)
	{
		case ProviderType::HIVE:			return "HIVE";
		case ProviderType::FACEBOOK:		return "FACEBOOK";
		default:							return "";
	}
}

std::string SocialV4::stringViewType(ViewType viewType)
{
    switch(viewType)
    {
        case ViewType::FullScreen:          return "FullScreen";
        case ViewType::Frame:               return "Frame";
        default:                            return "FullScreen";
    }
}


void SocialV4::executeEngine(picojson::value jsonParam)
{
	ResultAPI result(jsonParam.get("resultAPI"));

	std::string methodName = jsonParam.get("method").to_str();
	if (methodName.compare("showCommunity") == 0)
    {
        if (g_onShowCommunity != NULL)
        {
            g_onShowCommunity(result);
        }
    }
	else if (methodName.compare("sharePhoto") == 0)
    {
        if (g_onSharePhoto != NULL)
        {
            g_onSharePhoto(result);
        }
    }
}



NS_HIVE_END		// namespace hive
#endif