/* Copyright © 2024 Com2uS Platform Corp. All Rights Reserved. */
#include "HiveAuthV4.h"
#include "HiveUELogger.h"
#include "HiveMacros.h"

HIVE_CALL_IMPL_VOID_METHOD(FHiveAuthV4, Setup, (const FHiveAuthV4OnSetupDelegate& Delegate), (Delegate))
HIVE_CALL_IMPL_VOID_METHOD(FHiveAuthV4, SignIn, (const EHiveProviderType& ProviderType, const FHiveAuthV4OnSignInDelegate& Delegate), (ProviderType, Delegate))
HIVE_CALL_IMPL_VOID_METHOD(FHiveAuthV4, SignInWithAuthKey, (const FString& AuthKey, const FHiveAuthV4OnSignInDelegate& Delegate), (AuthKey, Delegate))
HIVE_CALL_IMPL_VOID_METHOD(FHiveAuthV4, SignOut, (const FHiveAuthV4OnSignOutDelegate& Delegate), (Delegate))
HIVE_CALL_IMPL_VOID_METHOD(FHiveAuthV4, PlayerDelete, (const FHiveAuthV4OnSignOutDelegate& Delegate), (Delegate))
HIVE_CALL_IMPL_VOID_METHOD(FHiveAuthV4, Connect, (const EHiveProviderType& ProviderType, const FHiveAuthV4OnConnectDelegate& Delegate), (ProviderType, Delegate))
HIVE_CALL_IMPL_VOID_METHOD(FHiveAuthV4, Disconnect, (const EHiveProviderType& ProviderType, const FHiveAuthV4OnDisconnectDelegate& Delegate), (ProviderType, Delegate))
HIVE_CALL_IMPL_VOID_METHOD(FHiveAuthV4, ConnectWithAuthKey, (const FString& AuthKey, const FHiveAuthV4OnConnectDelegate& Delegate), (AuthKey, Delegate))
HIVE_CALL_IMPL_VOID_METHOD(FHiveAuthV4, DisconnectWithName, (const FString& ProviderName, const FHiveAuthV4OnDisconnectDelegate& Delegate), (ProviderName, Delegate))
HIVE_CALL_IMPL_VOID_METHOD(FHiveAuthV4, SelectConflict, (int64 SelectedPlayerId, const FHiveAuthV4OnSignInDelegate& Delegate), (SelectedPlayerId, Delegate))
HIVE_CALL_IMPL_VOID_METHOD(FHiveAuthV4, ShowConflictSelection, (const FHiveConflictViewData& ConflictViewData, const FHiveAuthV4OnSignInDelegate& Delegate), (ConflictViewData, Delegate))
HIVE_CALL_IMPL_VOID_METHOD(FHiveAuthV4, CheckProvider, (const EHiveProviderType& ProviderType, const FHiveAuthV4OnCheckProviderDelegate& Delegate), (ProviderType, Delegate))
HIVE_CALL_IMPL_VOID_METHOD(FHiveAuthV4, CheckMaintenance, (bool IsShow, const FHiveAuthV4OnMaintenanceInfoDelegate& Delegate), (IsShow, Delegate))
HIVE_CALL_IMPL_VOID_METHOD(FHiveAuthV4, CheckBlacklist, (bool IsShow, const FHiveAuthV4OnMaintenanceInfoDelegate& Delegate), (IsShow, Delegate))
HIVE_CALL_IMPL_VOID_METHOD(FHiveAuthV4, SetProviderChangedListener, (const FHiveAuthV4OnCheckProviderDelegate& Delegate), (Delegate))
HIVE_CALL_IMPL_VOID_METHOD(FHiveAuthV4, ShowSignIn, (const FHiveAuthV4OnSignInDelegate& Delegate), (Delegate))
HIVE_CALL_IMPL_VOID_METHOD(FHiveAuthV4, ShowInquiry, (const FHiveAuthV4OnShowInquiryDelegate& Delegate), (Delegate))
HIVE_CALL_IMPL_VOID_METHOD(FHiveAuthV4, ShowChatbotInquiry, (const FString& AdditionalInfo, const FHiveAuthV4OnShowInquiryDelegate& Delegate), (AdditionalInfo, Delegate))
HIVE_CALL_IMPL_VOID_METHOD(FHiveAuthV4, ShowMyInquiry, (const FHiveAuthV4OnShowInquiryDelegate& Delegate), (Delegate))
HIVE_CALL_IMPL_VOID_METHOD(FHiveAuthV4, ShowTerms, (const FHiveAuthV4OnShowTermsDelegate& Delegate), (Delegate))
HIVE_CALL_IMPL_VOID_METHOD(FHiveAuthV4, ShowAdultConfirm, (const FHiveAuthV4OnAdultConfirmDelegate& Delegate), (Delegate))
HIVE_CALL_IMPL_VOID_METHOD(FHiveAuthV4, GetProfile, (const TArray<int64> PlayerIdArray, const FHiveAuthV4OnGetProfileDelegate& Delegate), (PlayerIdArray, Delegate))
HIVE_CALL_IMPL_VOID_METHOD(FHiveAuthV4, ShowProfile, (int64 PlayerId, const FHiveAuthV4OnShowProfileDelegate& Delegate), (PlayerId, Delegate))
HIVE_CALL_IMPL_VOID_METHOD(FHiveAuthV4, ResetAgreement, (), ())
HIVE_CALL_IMPL_RETURN_METHOD(FHiveAuthV4, bool, IsAutoSignIn, (), ())
HIVE_CALL_IMPL_RETURN_METHOD(FHiveAuthV4, TOptional<FHivePlayerInfo>, GetPlayerInfo, (), ())
HIVE_CALL_IMPL_VOID_METHOD(FHiveAuthV4, GetProviderFriendsList, (const EHiveProviderType& ProviderType, const FHiveAuthV4OnGetProviderFriendsListDelegate& Delegate), (ProviderType, Delegate))
HIVE_CALL_IMPL_VOID_METHOD(FHiveAuthV4, ResolveConflict, (const FHiveAuthV4OnResolveConflictDelegate& Delegate), (Delegate))
HIVE_CALL_IMPL_VOID_METHOD(FHiveAuthV4, ShowGameCenterLoginCancelDialog, (const FHiveAuthV4OnAuthV4DialogDismissDelegate& Delegate), (Delegate))
HIVE_CALL_IMPL_RETURN_METHOD(FHiveAuthV4, bool, GetAgeGateU13, (), ())
HIVE_CALL_IMPL_VOID_METHOD(FHiveAuthV4, ShowDeviceManagement, (const FHiveAuthV4OnShowDeviceManagementDelegate& Delegate), (Delegate))
HIVE_CALL_IMPL_VOID_METHOD(FHiveAuthV4, GetHiveTalkPlusLoginToken, (const FHiveAuthV4OnGetHiveTalkPlusLoginTokenDelegate& Delegate), (Delegate))
HIVE_CALL_IMPL_VOID_METHOD(FHiveAuthV4, RefreshAccessToken, (const FHiveAuthV4OnRefreshAccessTokenDelegate& Delegate), (Delegate))
HIVE_CALL_IMPL_VOID_METHOD(FHiveAuthV4, SignInWithStoredPlayerId, (int64 PlayerId, bool useAutoSignIn, const FHiveAuthV4OnSignInDelegate& Delegate), (PlayerId, useAutoSignIn, Delegate))
HIVE_CALL_IMPL_VOID_METHOD(FHiveAuthV4, GetStoredPlayerIdList, (const FHiveAuthV4OnGetStoredPlayerIdListDelegate& Delegate), (Delegate))
HIVE_CALL_IMPL_VOID_METHOD(FHiveAuthV4, StoreCurrentPlayerId, (const FHiveAuthV4OnStoreCurrentPlayerIdDelegate& Delegate), (Delegate))
HIVE_CALL_IMPL_VOID_METHOD(FHiveAuthV4, DeleteStoredPlayerId, (int64 PlayerId, const FHiveAuthV4OnDeleteStoredPlayerIdDelegate& Delegate), (PlayerId, Delegate))
HIVE_CALL_IMPL_RETURN_METHOD(FHiveAuthV4, TOptional<FHiveParentalConsentInfo>, GetParentalConsentInfo, (), ())
HIVE_CALL_IMPL_VOID_METHOD(FHiveAuthV4, GetHashedDi, (const FHiveAuthV4OnGetHashedDiDelegate& Delegate), (Delegate))
HIVE_CALL_IMPL_VOID_METHOD(FHiveAuthV4, CheckAgeGate, (bool UseCloseButton, const FHiveAuthV4OnCheckAgeGateDelegate& Delegate), (UseCloseButton, Delegate))
HIVE_CALL_IMPL_VOID_METHOD(FHiveAuthV4, ShowIdentityVerification, (const FHiveAuthV4OnIdentityVerificationDelegate& Delegate), (Delegate))
HIVE_CALL_IMPL_VOID_METHOD(FHiveAuthV4, GetAgeRange, (const FHiveAuthV4OnGetAgeRangeDelegate& Delegate), (Delegate))
HIVE_CALL_IMPL_VOID_METHOD(FHiveAuthV4, ShowAgeRangeUpdatePermission, (const FString& Description, const FHiveAuthV4OnShowAgeRangeUpdatePermissionDelegate& Delegate), (Description, Delegate))
HIVE_CALL_IMPL_VOID_METHOD(FHiveAuthV4, SetAutoLoginEnabled, (bool enabled, const FHiveAuthV4OnSetAutoLoginEnabledDelegate& Delegate), (enabled, Delegate))

// *** Helper ***
HIVE_CALL_IMPL_VOID_METHOD(FHiveAuthV4::Helper, SyncAccount, (const EHiveProviderType& ProviderType, const FHiveAuthV4HelperDelegate& Delegate), (ProviderType, Delegate))
HIVE_CALL_IMPL_VOID_METHOD(FHiveAuthV4::Helper, SignIn, (const FHiveAuthV4HelperDelegate& Delegate), (Delegate))
HIVE_CALL_IMPL_VOID_METHOD(FHiveAuthV4::Helper, SignOut, (const FHiveAuthV4HelperDelegate& Delegate), (Delegate))
HIVE_CALL_IMPL_VOID_METHOD(FHiveAuthV4::Helper, PlayerDelete, (const FHiveAuthV4HelperDelegate& Delegate), (Delegate))
HIVE_CALL_IMPL_VOID_METHOD(FHiveAuthV4::Helper, Connect, (const EHiveProviderType& ProviderType, const FHiveAuthV4HelperDelegate& Delegate), (ProviderType, Delegate))
HIVE_CALL_IMPL_VOID_METHOD(FHiveAuthV4::Helper, Disconnect, (const EHiveProviderType& ProviderType, const FHiveAuthV4HelperDelegate& Delegate), (ProviderType, Delegate))
HIVE_CALL_IMPL_VOID_METHOD(FHiveAuthV4::Helper, ShowAchievements, (const FHiveAuthV4HelperDelegate& Delegate), (Delegate))
HIVE_CALL_IMPL_VOID_METHOD(FHiveAuthV4::Helper, ShowLeaderboard, (const FHiveAuthV4HelperDelegate& Delegate), (Delegate))
HIVE_CALL_IMPL_VOID_METHOD(FHiveAuthV4::Helper, AchievementsReveal, (const FString& AchievementId, const FHiveAuthV4HelperDelegate& Delegate), (AchievementId, Delegate))
HIVE_CALL_IMPL_VOID_METHOD(FHiveAuthV4::Helper, AchievementsUnlock, (const FString& AchievementId, const FHiveAuthV4HelperDelegate& Delegate), (AchievementId, Delegate))
HIVE_CALL_IMPL_VOID_METHOD(FHiveAuthV4::Helper, AchievementsIncrement, (const FString& AchievementId, int64 value, const FHiveAuthV4HelperDelegate& Delegate), (AchievementId, value, Delegate))
HIVE_CALL_IMPL_VOID_METHOD(FHiveAuthV4::Helper, LeaderboardsSubmitScore, (const FString& LeaderboardId, int64 value, const FHiveAuthV4HelperDelegate& Delegate), (LeaderboardId, value, Delegate))
HIVE_CALL_IMPL_VOID_METHOD(FHiveAuthV4::Helper, ShowConflict, (const FHiveAuthV4HelperDelegate& Delegate), (Delegate))
HIVE_CALL_IMPL_VOID_METHOD(FHiveAuthV4::Helper, ShowConflict, (const FHiveConflictSingleViewData& ViewData, const FHiveAuthV4HelperDelegate& Delegate), (ViewData, Delegate))
HIVE_CALL_IMPL_VOID_METHOD(FHiveAuthV4::Helper, SwitchAccount, (const FHiveAuthV4HelperDelegate& Delegate), (Delegate))
HIVE_CALL_IMPL_VOID_METHOD(FHiveAuthV4::Helper, ResolveConflict, (const FHiveAuthV4HelperDelegate& Delegate), (Delegate))
HIVE_CALL_IMPL_RETURN_METHOD(FHiveAuthV4::Helper, TArray<EHiveProviderType>, GetIDPList, (), ())
HIVE_CALL_IMPL_VOID_METHOD(FHiveAuthV4::Helper, ShowGameCenterLoginCancelDialog, (const FHiveAuthV4HelperOnDialogDismissDelegate& Delegate), (Delegate))
