/* Copyright © 2025 Com2uS Platform Corp. All Rights Reserved. */
#include "HiveChat.h"
#include "HiveUELogger.h"
#include "HiveMacros.h"


HIVE_CALL_IMPL_VOID_METHOD(FHiveChat, CreateChannel, (const FHiveCreateChannelParams& params, const FHiveChatOnResultDelegate& Delegate), (params, Delegate))
HIVE_CALL_IMPL_VOID_METHOD(FHiveChat, GetChannelInfo, (const FString& channelId, const FHiveChatOnGetChannelInfoDelegate& Delegate), (channelId, Delegate))
HIVE_CALL_IMPL_VOID_METHOD(FHiveChat, GetChannelMembers, (const FString& channelId, const FHiveChatOnGetChannelMembersDelegate& Delegate), (channelId, Delegate))
HIVE_CALL_IMPL_VOID_METHOD(FHiveChat, DeleteChannel, (const FString& channelId, const FHiveChatOnResultDelegate& Delegate), (channelId, Delegate))
HIVE_CALL_IMPL_VOID_METHOD(FHiveChat, EnterChannel, (const FHiveEnterChannelParams& params, const FHiveChatOnResultDelegate& Delegate), (params, Delegate))
HIVE_CALL_IMPL_VOID_METHOD(FHiveChat, ExitChannel, (const FString& channelId, const FHiveChatOnResultDelegate& Delegate), (channelId, Delegate))
HIVE_CALL_IMPL_VOID_METHOD(FHiveChat, GetChannelsByUser, (const FHiveChatOnGetChannelsByUserDelegate& Delegate), (Delegate))
HIVE_CALL_IMPL_VOID_METHOD(FHiveChat, GetBlockMembers, (const FHiveChatOnGetBlockMembersDelegate& Delegate), (Delegate))
HIVE_CALL_IMPL_VOID_METHOD(FHiveChat, BlockMember, (int64 blockPlayerId, const FHiveChatOnResultDelegate& Delegate), (blockPlayerId, Delegate))
HIVE_CALL_IMPL_VOID_METHOD(FHiveChat, UnblockMember, (int64 blockPlayerId, const FHiveChatOnResultDelegate& Delegate), (blockPlayerId, Delegate))
HIVE_CALL_IMPL_VOID_METHOD(FHiveChat, Connect, (const FString& extraData, const FHiveChatOnResultDelegate& Delegate), (Delegate))
HIVE_CALL_IMPL_VOID_METHOD(FHiveChat, Connect, (const FHiveChatOnResultDelegate& Delegate), (Delegate))
HIVE_CALL_IMPL_VOID_METHOD(FHiveChat, Reconnect, (const FHiveChatOnReconnectDelegate& Delegate), (Delegate))
HIVE_CALL_IMPL_VOID_METHOD(FHiveChat, Disconnect, (const FHiveChatOnResultDelegate& Delegate), (Delegate))

HIVE_CALL_IMPL_VOID_METHOD(FHiveChat, SendMessageWithChannelSendMessageParams, (FHiveChannelSendMessageParams const & params, const FHiveChatOnResultDelegate& Delegate), (params, Delegate))
HIVE_CALL_IMPL_VOID_METHOD(FHiveChat, SendMessageWithDirectSendMessageParams, (FHiveDirectSendMessageParams const & params, const FHiveChatOnResultDelegate& Delegate), (params, Delegate))
HIVE_CALL_IMPL_VOID_METHOD(FHiveChat, SendMessageWithChannelSendMessageParams, (FHiveChannelSendMessageParams const & params), (params))
HIVE_CALL_IMPL_VOID_METHOD(FHiveChat, SendMessageWithDirectSendMessageParams, (FHiveDirectSendMessageParams const & params), (params))

HIVE_CALL_IMPL_VOID_METHOD(FHiveChat, Translate, (FHiveTranslateParams const & params, const FHiveChatOnTranslateDelegate& Delegate), (params, Delegate))

HIVE_CALL_IMPL_VOID_METHOD(FHiveChat, AddChannelListener, (const FString& uniqueKey, FHiveChannelListener* listener), (uniqueKey, listener))
HIVE_CALL_IMPL_VOID_METHOD(FHiveChat, AddDirectMessageListener, (const FString& uniqueKey, FHiveDirectMessageListener* listener), (uniqueKey, listener))
HIVE_CALL_IMPL_VOID_METHOD(FHiveChat, AddConnectionListener, (const FString& uniqueKey, FHiveConnectionListener* listener), (uniqueKey, listener))
HIVE_CALL_IMPL_VOID_METHOD(FHiveChat, AddUserListener, (const FString& uniqueKey, FHiveUserListener* listener), (uniqueKey, listener))
HIVE_CALL_IMPL_VOID_METHOD(FHiveChat, AddCustomDataListener, (const FString& uniqueKey, FHiveCustomDataListener* listener), (uniqueKey, listener))
HIVE_CALL_IMPL_VOID_METHOD(FHiveChat, RemoveChannelListener, (const FString& uniqueKey), (uniqueKey))
HIVE_CALL_IMPL_VOID_METHOD(FHiveChat, RemoveDirectMessageListener, (const FString& uniqueKey), (uniqueKey))
HIVE_CALL_IMPL_VOID_METHOD(FHiveChat, RemoveConnectionListener, (const FString& uniqueKey), (uniqueKey))
HIVE_CALL_IMPL_VOID_METHOD(FHiveChat, RemoveUserListener, (const FString& uniqueKey), (uniqueKey))
HIVE_CALL_IMPL_VOID_METHOD(FHiveChat, RemoveCustomDataListener, (const FString& uniqueKey), (uniqueKey))

HIVE_CALL_IMPL_RETURN_METHOD(FHiveChat, bool, IsConnected, (), ())

void FHiveChat::GetChannels(TOptional<FHiveGetChannelsParams> params, const FHiveChatOnGetChannelsDelegate& Delegate)
{
    if (params.IsSet())
    {
        GetInstance()->GetChannels(params.GetValue(), Delegate);
    }
    else {
        GetInstance()->GetChannels(TOptional<FHiveGetChannelsParams>(), Delegate);
    }
}
