/* Copyright © 2024 Com2uS Platform Corp. All Rights Reserved. */
#include "HiveResultAPI.h"

FHiveResultAPI::FHiveResultAPI()
: ErrorCode(EErrorCode::SUCCESS)
, Code(ECode::CommonUnknown)
, ErrorMessage(TEXT("success"))
, Message(TEXT("success"))
, LatencyMs(0)
{ }

FHiveResultAPI::FHiveResultAPI(EErrorCode ErrorCode, FString ErrorMessage)
: ErrorCode(ErrorCode)
, Code(ECode::CommonUnknown)
, ErrorMessage(ErrorMessage)
, Message(TEXT("success"))
, LatencyMs(0)
{ }

FHiveResultAPI::FHiveResultAPI(EErrorCode ErrorCode, ECode Code, FString ErrorMessage)
: ErrorCode(ErrorCode)
, Code(Code)
, ErrorMessage(ErrorMessage)
, Message(TEXT("success"))
, LatencyMs(0)
{ }

FHiveResultAPI::FHiveResultAPI(const hive::ResultAPI& Result)
: ErrorCode(static_cast<EErrorCode>(Result.errorCode))
, Code(static_cast<ECode>(Result.code))
, ErrorMessage(UTF8_TO_TCHAR(Result.errorMessage.c_str()))
, Message(UTF8_TO_TCHAR(Result.message.c_str()))
, LatencyMs(Result.latencyMs)
{ }

bool FHiveResultAPI::IsSuccess() const
{
    return (static_cast<int32>(this->ErrorCode) >= 0 || static_cast<int32>(this->Code) >= 0);
}

FString FHiveResultAPI::ToString() const
{
    return FString::Printf(
        TEXT("FHiveResultAPI { ErrorCode = %d, Code = %d, ErrorMessage = %s, Message = %s, LatencyMs = %lld }"),
        static_cast<int32>(ErrorCode),
        static_cast<int32>(Code),
        *ErrorMessage,
        *Message,
        LatencyMs);
}

bool FHiveResultAPI::NeedExit() const
{
    return (this->ErrorCode == EErrorCode::NEED_EXIT);
}
