/* Copyright © 2024 Com2uS Platform Corp. All Rights Reserved. */
#pragma once

#include "CoreMinimal.h"

DECLARE_LOG_CATEGORY_EXTERN(HIVE_LOG, Log, All);

#define LOG_CALLINFO (FString::Printf(TEXT("%s (line: %d)"), ANSI_TO_TCHAR(__FUNCTION__), __LINE__)) // ex. Setup (line: 27)

#define HIVE_LOG_WARNING(Format, ...) UE_LOG(HIVE_LOG, Warning, TEXT("%s %s"), *LOG_CALLINFO, *FString::Printf(Format, ##__VA_ARGS__)) // ex. HIVE_LOG: Warning: Setup (line: 27) Message

#define HIVE_LOG_ERROR(Format, ...) UE_LOG(HIVE_LOG, Error, TEXT("%s %s"), *LOG_CALLINFO, *FString::Printf(Format, ##__VA_ARGS__)) // ex. HIVE_LOG: Error: Setup (line: 27) Message