/* Copyright © 2024 Com2uS Platform Corp. All Rights Reserved. */
#include "Impl/HiveAuthV4HelperImpl.h"
#include "HiveUELogger.h"

void IHiveAuthV4HelperImpl::SyncAccount(const EHiveProviderType& ProviderType, const FHiveAuthV4HelperDelegate& Delegate)
{
    hive::AuthV4::Helper::syncAccount(static_cast<hive::ProviderType>(ProviderType), [Delegate](hive::ResultAPI const & result, std::shared_ptr<hive::PlayerInfo> playerInfo) {
        if (Delegate.IsBound())
        {
            FHiveResultAPI Result(result);
            TOptional<FHivePlayerInfo> PlayerInfo;
            if (playerInfo)
            {
                PlayerInfo = TOptional<FHivePlayerInfo>(FHivePlayerInfo(*playerInfo));
            }

            Delegate.Execute(Result, PlayerInfo);
        }
        else
        {
            HIVE_LOG_WARNING(TEXT("Delegate is not bounded."));
        }
    });
}

void IHiveAuthV4HelperImpl::SignIn(const FHiveAuthV4HelperDelegate& Delegate)
{
    hive::AuthV4::Helper::signIn([Delegate](hive::ResultAPI const & result, std::shared_ptr<hive::PlayerInfo> playerInfo) {
        if (Delegate.IsBound())
        {
            FHiveResultAPI Result(result);
            TOptional<FHivePlayerInfo> PlayerInfo;
            if (playerInfo)
            {
                PlayerInfo = TOptional<FHivePlayerInfo>(FHivePlayerInfo(*playerInfo));
            }

            Delegate.Execute(Result, PlayerInfo);
        }
        else
        {
            HIVE_LOG_WARNING(TEXT("Delegate is not bounded."));
        }
    });
}

void IHiveAuthV4HelperImpl::SignOut(const FHiveAuthV4HelperDelegate& Delegate)
{
    hive::AuthV4::Helper::signOut([Delegate](hive::ResultAPI const & result, std::shared_ptr<hive::PlayerInfo> playerInfo) {
        if (Delegate.IsBound())
        {
            FHiveResultAPI Result(result);
            TOptional<FHivePlayerInfo> PlayerInfo;
            if (playerInfo)
            {
                PlayerInfo = TOptional<FHivePlayerInfo>(FHivePlayerInfo(*playerInfo));
            }

            Delegate.Execute(Result, PlayerInfo);
        }
        else
        {
            HIVE_LOG_WARNING(TEXT("Delegate is not bounded."));
        }
    });
}

void IHiveAuthV4HelperImpl::PlayerDelete(const FHiveAuthV4HelperDelegate& Delegate)
{
    hive::AuthV4::Helper::playerDelete([Delegate](hive::ResultAPI const & result, std::shared_ptr<hive::PlayerInfo> playerInfo) {
        if (Delegate.IsBound())
        {
            FHiveResultAPI Result(result);
            TOptional<FHivePlayerInfo> PlayerInfo;
            if (playerInfo)
            {
                PlayerInfo = TOptional<FHivePlayerInfo>(FHivePlayerInfo(*playerInfo));
            }

            Delegate.Execute(Result, PlayerInfo);
        }
        else
        {
            HIVE_LOG_WARNING(TEXT("Delegate is not bounded."));
        }
    });
}

void IHiveAuthV4HelperImpl::Connect(const EHiveProviderType& ProviderType, const FHiveAuthV4HelperDelegate& Delegate)
{
    hive::AuthV4::Helper::connect(static_cast<hive::ProviderType>(ProviderType), [Delegate](hive::ResultAPI const & result, std::shared_ptr<hive::PlayerInfo> playerInfo) {
        if (Delegate.IsBound())
        {
            FHiveResultAPI Result(result);
            TOptional<FHivePlayerInfo> PlayerInfo;
            if (playerInfo)
            {
                PlayerInfo = TOptional<FHivePlayerInfo>(FHivePlayerInfo(*playerInfo));
            }

            Delegate.Execute(Result, PlayerInfo);
        }
        else
        {
            HIVE_LOG_WARNING(TEXT("Delegate is not bounded."));
        }
    });
}

void IHiveAuthV4HelperImpl::Disconnect(const EHiveProviderType& ProviderType, const FHiveAuthV4HelperDelegate& Delegate)
{
    hive::AuthV4::Helper::disconnect(static_cast<hive::ProviderType>(ProviderType), [Delegate](hive::ResultAPI const & result, std::shared_ptr<hive::PlayerInfo> playerInfo) {
        if (Delegate.IsBound())
        {
            FHiveResultAPI Result(result);
            TOptional<FHivePlayerInfo> PlayerInfo;
            if (playerInfo)
            {
                PlayerInfo = TOptional<FHivePlayerInfo>(FHivePlayerInfo(*playerInfo));
            }

            Delegate.Execute(Result, PlayerInfo);
        }
        else
        {
            HIVE_LOG_WARNING(TEXT("Delegate is not bounded."));
        }
    });
}

void IHiveAuthV4HelperImpl::ShowAchievements(const FHiveAuthV4HelperDelegate& Delegate)
{
    hive::AuthV4::Helper::showAchievements([Delegate](hive::ResultAPI const & result, std::shared_ptr<hive::PlayerInfo> playerInfo) {
        if (Delegate.IsBound())
        {
            FHiveResultAPI Result(result);
            TOptional<FHivePlayerInfo> PlayerInfo;
            if (playerInfo)
            {
                PlayerInfo = TOptional<FHivePlayerInfo>(FHivePlayerInfo(*playerInfo));
            }

            Delegate.Execute(Result, PlayerInfo);
        }
        else
        {
            HIVE_LOG_WARNING(TEXT("Delegate is not bounded."));
        }
    });
}

void IHiveAuthV4HelperImpl::ShowLeaderboard(const FHiveAuthV4HelperDelegate& Delegate)
{
    hive::AuthV4::Helper::showLeaderboard([Delegate](hive::ResultAPI const & result, std::shared_ptr<hive::PlayerInfo> playerInfo) {
        if (Delegate.IsBound())
        {
            FHiveResultAPI Result(result);
            TOptional<FHivePlayerInfo> PlayerInfo;
            if (playerInfo)
            {
                PlayerInfo = TOptional<FHivePlayerInfo>(FHivePlayerInfo(*playerInfo));
            }

            Delegate.Execute(Result, PlayerInfo);
        }
        else
        {
            HIVE_LOG_WARNING(TEXT("Delegate is not bounded."));
        }
    });
}

void IHiveAuthV4HelperImpl::AchievementsReveal(const FString& AchievementId, const FHiveAuthV4HelperDelegate& Delegate)
{
    std::string StrAchievementId(TCHAR_TO_UTF8(*AchievementId));
    hive::AuthV4::Helper::achievementsReveal(StrAchievementId, [Delegate](hive::ResultAPI const & result, std::shared_ptr<hive::PlayerInfo> playerInfo) {
        if (Delegate.IsBound())
        {
            FHiveResultAPI Result(result);
            TOptional<FHivePlayerInfo> PlayerInfo;
            if (playerInfo)
            {
                PlayerInfo = TOptional<FHivePlayerInfo>(FHivePlayerInfo(*playerInfo));
            }

            Delegate.Execute(Result, PlayerInfo);
        }
        else
        {
            HIVE_LOG_WARNING(TEXT("Delegate is not bounded."));
        }
    });
}

void IHiveAuthV4HelperImpl::AchievementsUnlock(const FString& AchievementId, const FHiveAuthV4HelperDelegate& Delegate)
{
    std::string StrAchievementId(TCHAR_TO_UTF8(*AchievementId));
    hive::AuthV4::Helper::achievementsUnlock(StrAchievementId, [Delegate](hive::ResultAPI const & result, std::shared_ptr<hive::PlayerInfo> playerInfo) {
        if (Delegate.IsBound())
        {
            FHiveResultAPI Result(result);
            TOptional<FHivePlayerInfo> PlayerInfo;
            if (playerInfo)
            {
                PlayerInfo = TOptional<FHivePlayerInfo>(FHivePlayerInfo(*playerInfo));
            }

            Delegate.Execute(Result, PlayerInfo);
        }
        else
        {
            HIVE_LOG_WARNING(TEXT("Delegate is not bounded."));
        }
    });
}

void IHiveAuthV4HelperImpl::AchievementsIncrement(const FString& AchievementId, int32 value, const FHiveAuthV4HelperDelegate& Delegate)
{
    std::string StrAchievementId(TCHAR_TO_UTF8(*AchievementId));
    hive::AuthV4::Helper::achievementsIncrement(StrAchievementId, value, [Delegate](hive::ResultAPI const & result, std::shared_ptr<hive::PlayerInfo> playerInfo) {
        if (Delegate.IsBound())
        {
            FHiveResultAPI Result(result);
            TOptional<FHivePlayerInfo> PlayerInfo;
            if (playerInfo)
            {
                PlayerInfo = TOptional<FHivePlayerInfo>(FHivePlayerInfo(*playerInfo));
            }

            Delegate.Execute(Result, PlayerInfo);
        }
        else
        {
            HIVE_LOG_WARNING(TEXT("Delegate is not bounded."));
        }
    });
}

void IHiveAuthV4HelperImpl::LeaderboardsSubmitScore(const FString& LeaderboardId, int64 value, const FHiveAuthV4HelperDelegate& Delegate)
{
    std::string StrLeaderboardId(TCHAR_TO_UTF8(*LeaderboardId));
    hive::AuthV4::Helper::leaderboardsSubmitScore(StrLeaderboardId, value, [Delegate](hive::ResultAPI const & result, std::shared_ptr<hive::PlayerInfo> playerInfo) {
        if (Delegate.IsBound())
        {
            FHiveResultAPI Result(result);
            TOptional<FHivePlayerInfo> PlayerInfo;
            if (playerInfo)
            {
                PlayerInfo = TOptional<FHivePlayerInfo>(FHivePlayerInfo(*playerInfo));
            }

            Delegate.Execute(Result, PlayerInfo);
        }
        else
        {
            HIVE_LOG_WARNING(TEXT("Delegate is not bounded."));
        }
    });
}

void IHiveAuthV4HelperImpl::ShowConflict(const FHiveAuthV4HelperDelegate& Delegate)
{
    hive::AuthV4::Helper::showConflict([Delegate](hive::ResultAPI const & result,std::shared_ptr<hive::PlayerInfo> playerInfo) {
        if (Delegate.IsBound())
        {
            FHiveResultAPI Result(result);
            TOptional<FHivePlayerInfo> PlayerInfo;
            if (playerInfo)
            {
                PlayerInfo = TOptional<FHivePlayerInfo>(FHivePlayerInfo(*playerInfo));
            }

            Delegate.Execute(Result, PlayerInfo);
        }
        else
        {
            HIVE_LOG_WARNING(TEXT("Delegate is not bounded."));
        }
    });
}

void IHiveAuthV4HelperImpl::ShowConflict(const FHiveConflictSingleViewData& ViewData, const FHiveAuthV4HelperDelegate& Delegate)
{
    const FString* StrConfictPlayerId = ViewData.ConflictPlayerData.Find(TEXT("player_id"));
    if (StrConfictPlayerId)
    {
        int64 ConflictPlayerId = FCString::Atoi64(*(*StrConfictPlayerId));

        hive::ConflictSingleViewInfo info = hive::ConflictSingleViewInfo(ConflictPlayerId);

        for(const auto& Pair : ViewData.ConflictPlayerData)
        {
            std::string StrKey(TCHAR_TO_UTF8(*(Pair.Key)));
            std::string StrValue(TCHAR_TO_UTF8(*(Pair.Value)));
            info.SetValue(StrKey, StrValue);
        }

        hive::AuthV4::Helper::showConflict(info, [Delegate](hive::ResultAPI const & result,std::shared_ptr<hive::PlayerInfo> playerInfo) {
            if (Delegate.IsBound())
            {
                FHiveResultAPI Result(result);
                TOptional<FHivePlayerInfo> PlayerInfo;
                if (playerInfo)
                {
                    PlayerInfo = TOptional<FHivePlayerInfo>(FHivePlayerInfo(*playerInfo));
                }

                Delegate.Execute(Result, PlayerInfo);
            }
            else
            {
                HIVE_LOG_WARNING(TEXT("Delegate is not bounded."));
            }
        });
    }
    else
    {
        HIVE_LOG_WARNING(TEXT("player_id is null."));
    }
}

void IHiveAuthV4HelperImpl::SwitchAccount(const FHiveAuthV4HelperDelegate& Delegate)
{
    hive::AuthV4::Helper::switchAccount([Delegate](hive::ResultAPI const & result, std::shared_ptr<hive::PlayerInfo> playerInfo) {
        if (Delegate.IsBound())
        {
            FHiveResultAPI Result(result);
            TOptional<FHivePlayerInfo> PlayerInfo;
            if (playerInfo)
            {
                PlayerInfo = TOptional<FHivePlayerInfo>(FHivePlayerInfo(*playerInfo));
            }

            Delegate.Execute(Result, PlayerInfo);
        }
        else
        {
            HIVE_LOG_WARNING(TEXT("Delegate is not bounded."));
        }
    });
}

void IHiveAuthV4HelperImpl::ResolveConflict(const FHiveAuthV4HelperDelegate& Delegate)
{
    hive::AuthV4::Helper::resolveConflict([Delegate](hive::ResultAPI const & result, std::shared_ptr<hive::PlayerInfo> playerInfo) {
        if (Delegate.IsBound())
        {
            FHiveResultAPI Result(result);
            TOptional<FHivePlayerInfo> PlayerInfo;
            if (playerInfo)
            {
                PlayerInfo = TOptional<FHivePlayerInfo>(FHivePlayerInfo(*playerInfo));
            }

            Delegate.Execute(Result, PlayerInfo);
        }
        else
        {
            HIVE_LOG_WARNING(TEXT("Delegate is not bounded."));
        }
    });
}

TArray<EHiveProviderType> IHiveAuthV4HelperImpl::GetIDPList()
{
    TArray<EHiveProviderType> IDPListArray;

    std::vector<hive::ProviderType> idpList = hive::AuthV4::Helper::getIDPList();

    if (idpList.size() > 0)
    {
        IDPListArray.Reserve(idpList.size());

        for(const auto& idp : idpList)
        {
            IDPListArray.Add(static_cast<EHiveProviderType>(idp));
        }
    }

    return IDPListArray;
}

void IHiveAuthV4HelperImpl::ShowGameCenterLoginCancelDialog(const FHiveAuthV4HelperOnDialogDismissDelegate& Delegate)
{
    hive::AuthV4::Helper::showGameCenterLoginCancelDialog([Delegate](bool isDismiss) {
        if (Delegate.IsBound())
        {
            Delegate.Execute(isDismiss);
        }
        else
        {
            HIVE_LOG_WARNING(TEXT("Delegate is not bounded."));
        }
    });
}