/* Copyright © 2024 Com2uS Platform Corp. All Rights Reserved. */
#include "Impl/HiveDataStoreImpl.h"
#include "HiveUELogger.h"

void IHiveDataStoreImpl::Set(const FString& Key, const FString& Value, const FHiveDataStoreOnSetDelegate& Delegate)
{
    std::string StrKey(TCHAR_TO_UTF8(*Key));
    std::string StrValue(TCHAR_TO_UTF8(*Value));
    hive::DataStore::set(StrKey, StrValue, [Delegate](hive::ResultAPI const & result) {
        if (Delegate.IsBound())
        {
            FHiveResultAPI Result(result);
            Delegate.Execute(Result);
        }
        else
        {
            HIVE_LOG_WARNING(TEXT("Delegate is not bounded."));
        }
    });
}

void IHiveDataStoreImpl::Set(const DataStoreData& Data, const FHiveDataStoreOnSetDelegate& Delegate)
{
    std::map<std::string, std::string> data;

    for(const auto& Pair : Data)
    {
        std::string Key(TCHAR_TO_UTF8(*Pair.Key));
        std::string Value(TCHAR_TO_UTF8(*Pair.Value));

        data.emplace(Key, Value);
    }

    hive::DataStore::set(data, [Delegate](hive::ResultAPI const & result){
        if (Delegate.IsBound())
        {
            FHiveResultAPI Result(result);
            Delegate.Execute(Result);
        }
        else
        {
            HIVE_LOG_WARNING(TEXT("Delegate is not bounded."));
        }
    });
}

void IHiveDataStoreImpl::Get(const FString& Key, const FHiveDataStoreOnGetDelegate& Delegate)
{
    std::string StrKey(TCHAR_TO_UTF8(*Key));
    hive::DataStore::get(StrKey, [Delegate](hive::ResultAPI const & result, std::string data) {
        if (Delegate.IsBound())
        {
            FHiveResultAPI Result(result);
            FString Data = FString(UTF8_TO_TCHAR(data.c_str()));
            Delegate.Execute(Result, Data);
        }
        else
        {
            HIVE_LOG_WARNING(TEXT("Delegate is not bounded."));
        }
    });
}

void IHiveDataStoreImpl::GetMyData(const FHiveDataStoreOnMyDataDelegate& Delegate)
{


    hive::DataStore::getMyData([Delegate](hive::ResultAPI const & result, std::map<std::string, std::string> const & myData) {
        if (Delegate.IsBound())
        {
            FHiveResultAPI Result(result);
            
            DataStoreData Data;
            for (const auto& Pair: myData)
            {
                FString Key = FString(UTF8_TO_TCHAR(Pair.first.c_str()));
                FString Value = FString(UTF8_TO_TCHAR(Pair.second.c_str()));
                Data.Emplace(Key, Value);
            }
            Delegate.Execute(Result, Data);
        }
        else
        {
            HIVE_LOG_WARNING(TEXT("Delegate is not bounded."));
        }
    });
}

void IHiveDataStoreImpl::GetUsersData(const FString& Key, const FHiveDataStoreOnUsersDataDelegate& Delegate)
{
    std::string StrKey(TCHAR_TO_UTF8(*Key));
    hive::DataStore::getUsersData(StrKey, [Delegate](hive::ResultAPI const & result, std::string const & key, std::map<long long, std::string> const & usersData) {
        if (Delegate.IsBound())
        {
            FHiveResultAPI Result(result);

            FString Key = FString(UTF8_TO_TCHAR(key.c_str()));
            
            DataStoreUsersData Data;
            for (const auto& Pair: usersData)
            {
                int64 UserDataKey = Pair.first;
                FString UserDataValue = FString(UTF8_TO_TCHAR(Pair.second.c_str()));
                Data.Emplace(UserDataKey, UserDataValue);
            }
            
            Delegate.Execute(Result, Key, Data);
        }
        else
        {
            HIVE_LOG_WARNING(TEXT("Delegate is not bounded."));
        }
    });
}
