/* Copyright © 2024 Com2uS Platform Corp. All Rights Reserved. */
#include "Impl/HiveSocialV4Impl.h"
#include "HiveUELogger.h"

void IHiveSocialV4Impl::ShowCommunity(ESocialV4ProviderType ProviderType, const FHiveSocialV4OnShowCommunityDelegate& Delegate)
{
    HIVESDKCEFImeEnable();

    hive::SocialV4::ProviderType providerType = static_cast<hive::SocialV4::ProviderType>(ProviderType);
    hive::SocialV4::showCommunity(providerType, [Delegate](hive::ResultAPI const & result) {
        HIVESDKCEFImeDisable();
        
        if (Delegate.IsBound())
        {
            FHiveResultAPI Result(result);
            Delegate.Execute(Result);
        }
        else
        {
            HIVE_LOG_WARNING(TEXT("Delegate is not bounded."));
        }
    });
}

void IHiveSocialV4Impl::ShowCommunity(ESocialV4ProviderType ProviderType, ESocialV4ViewType ViewType, const FHiveSocialV4OnShowCommunityDelegate& Delegate)
{
    HIVESDKCEFImeEnable();

    hive::SocialV4::ProviderType providerType = static_cast<hive::SocialV4::ProviderType>(ProviderType);
    hive::SocialV4::ViewType viewType = static_cast<hive::SocialV4::ViewType>(ViewType);
    hive::SocialV4::showCommunity(providerType, viewType, [Delegate](hive::ResultAPI const & result) {
        HIVESDKCEFImeDisable();
        if (Delegate.IsBound())
        {
            FHiveResultAPI Result(result);
            Delegate.Execute(Result);
        }
        else
        {
            HIVE_LOG_WARNING(TEXT("Delegate is not bounded."));
        }
    });
}

void IHiveSocialV4Impl::SharePhoto(ESocialV4ProviderType ProviderType, const FHiveSocialV4OnSharePhotoDelegate& Delegate)
{
    hive::SocialV4::ProviderType providerType = static_cast<hive::SocialV4::ProviderType>(ProviderType);
    hive::SocialV4::sharePhoto(providerType, [Delegate](hive::ResultAPI const & result) {
        if (Delegate.IsBound())
        {
            FHiveResultAPI Result(result);
            Delegate.Execute(Result);
        }
        else
        {
            HIVE_LOG_WARNING(TEXT("Delegate is not bounded."));
        }
    });
}