/* Copyright © 2024 Com2uS Platform Corp. All Rights Reserved. */
#include "Types/HiveIAPV4Types.h"

FString GetNameFromEHiveIAPV4Type(const EHiveIAPV4Type& IAPV4Type)
{
    switch(IAPV4Type) {
        case EHiveIAPV4Type::NotSelected:       return FString(TEXT("NotSelected"));
        case EHiveIAPV4Type::AppleAppStore:     return FString(TEXT("AppleAppStore"));
        case EHiveIAPV4Type::GooglePlayStore:   return FString(TEXT("GooglePlayStore"));
        case EHiveIAPV4Type::HIVELebi:          return FString(TEXT("HIVELebi"));
        case EHiveIAPV4Type::OneStore:          return FString(TEXT("OneStore"));
        case EHiveIAPV4Type::AmazonAppStore:    return FString(TEXT("AmazonAppStore"));
        case EHiveIAPV4Type::SamsungGalaxyStore: return FString(TEXT("SamsungGalaxyStore"));
        case EHiveIAPV4Type::HuaweiAppGallery:  return FString(TEXT("HuaweiAppGallery"));
        case EHiveIAPV4Type::Funtap:            return FString(TEXT("Funtap"));
        case EHiveIAPV4Type::OPPOAppMarket:     return FString(TEXT("OPPOAppMarket"));
        case EHiveIAPV4Type::VIVOAppStore:      return FString(TEXT("VIVOAppStore"));
        case EHiveIAPV4Type::TencentMyapp:      return FString(TEXT("TencentMyapp"));
        case EHiveIAPV4Type::XiaomiAppStore:        return FString(TEXT("XiaomiAppStore"));
        case EHiveIAPV4Type::HuaweiAppGalleryChina: return FString(TEXT("HuaweiAppGalleryChina"));
        case EHiveIAPV4Type::FacebookCloudGame:     return FString(TEXT("FacebookCloudGame"));
        case EHiveIAPV4Type::HiveStore:             return FString(TEXT("HiveStore"));
        case EHiveIAPV4Type::Steam:                 return FString(TEXT("Steam"));
        case EHiveIAPV4Type::Nowgg:                 return FString(TEXT("Nowgg"));
    }
    return FString(TEXT("NotSelected"));
}

EHiveIAPV4Type GetEHiveIAPV4TypeFromName(const FString& Name)
{
    static TMap<FString, EHiveIAPV4Type> EHiveIAPV4TypeMap = {
        {TEXT("NotSelected"), EHiveIAPV4Type::NotSelected},
        {TEXT("AppleAppStore"), EHiveIAPV4Type::AppleAppStore},
        {TEXT("GooglePlayStore"), EHiveIAPV4Type::GooglePlayStore},
        {TEXT("HIVELebi"), EHiveIAPV4Type::HIVELebi},
        {TEXT("OneStore"), EHiveIAPV4Type::OneStore},
        {TEXT("AmazonAppStore"), EHiveIAPV4Type::AmazonAppStore},
        {TEXT("SamsungGalaxyStore"), EHiveIAPV4Type::SamsungGalaxyStore},
        {TEXT("HuaweiAppGallery"), EHiveIAPV4Type::HuaweiAppGallery},
        {TEXT("Funtap"), EHiveIAPV4Type::Funtap},
        {TEXT("OPPOAppMarket"), EHiveIAPV4Type::OPPOAppMarket},
        {TEXT("VIVOAppStore"), EHiveIAPV4Type::VIVOAppStore},
        {TEXT("TencentMyapp"), EHiveIAPV4Type::TencentMyapp},
        {TEXT("XiaomiAppStore"), EHiveIAPV4Type::XiaomiAppStore},
        {TEXT("HuaweiAppGalleryChina"), EHiveIAPV4Type::HuaweiAppGalleryChina},
        {TEXT("FacebookCloudGame"), EHiveIAPV4Type::FacebookCloudGame},
        {TEXT("HiveStore"), EHiveIAPV4Type::HiveStore},
        {TEXT("Steam"), EHiveIAPV4Type::Steam},
        {TEXT("Nowgg"), EHiveIAPV4Type::Nowgg}
    };

    if (const EHiveIAPV4Type* IAPV4TypePtr = EHiveIAPV4TypeMap.Find(Name))
    {
        return *IAPV4TypePtr;
    }
    return EHiveIAPV4Type::NotSelected;
}

FHiveIAPV4Product::FHiveIAPV4Product(const hive::IAPV4Product& Product)
: ProductType(UTF8_TO_TCHAR(Product.productType.c_str()))
, MarketPid(UTF8_TO_TCHAR(Product.marketPid.c_str()))
, Currency(UTF8_TO_TCHAR(Product.currency.c_str()))
, Price(Product.price)
, DisplayPrice(UTF8_TO_TCHAR(Product.displayPrice.c_str()))
, Title(UTF8_TO_TCHAR(Product.title.c_str()))
, ProductDescription(UTF8_TO_TCHAR(Product.productDescription.c_str()))
, OriginalMarketJson(UTF8_TO_TCHAR(Product.originalMarketJson.c_str()))
, DisplayOriginalPrice(UTF8_TO_TCHAR(Product.displayOriginalPrice.c_str()))
, OriginalPrice(Product.originalPrice)
, IconUrl(UTF8_TO_TCHAR(Product.iconURL.c_str()))
, CoinsReward(Product.coinsReward)
{ }

FHiveIAPV4Receipt::FHiveIAPV4Receipt(const hive::IAPV4Receipt& Receipt)
: Type(static_cast<EHiveIAPV4Type>(Receipt.type))
, Product(FHiveIAPV4Product(Receipt.product))
, IapPayload(UTF8_TO_TCHAR(Receipt.iapPayload.c_str()))
, HiveIapReceipt(UTF8_TO_TCHAR(Receipt.hiveiapReceipt.c_str()))
, BypassInfo(UTF8_TO_TCHAR(Receipt.bypassInfo.c_str()))
, Quantity(Receipt.quantity)
{ }

FHiveIAPV4PurchaseParam::FHiveIAPV4PurchaseParam(const hive::IAPV4PurchaseParam& Param)
: MarketPid(UTF8_TO_TCHAR(Param.marketPid.c_str()))
, IapPayload(UTF8_TO_TCHAR(Param.iapPayload.c_str()))
, OldMarketPid(UTF8_TO_TCHAR(Param.oldMarketPid.c_str()))
, OfferToken(UTF8_TO_TCHAR(Param.offerToken.c_str()))
{ }

FHiveIAPV4ConsumeInfoUserAgreement::FHiveIAPV4ConsumeInfoUserAgreement()
: DidAgree(false)
, FirstAnsweredDate(0)
, LastAnsweredDate(0)
{ }

FHiveIAPV4ConsumeInfoUserAgreement::FHiveIAPV4ConsumeInfoUserAgreement(const hive::IAPV4ConsumeInfoUserAgreement& Info)
: DidAgree(Info.didAgree)
, FirstAnsweredDate(Info.firstAnsweredDate)
, LastAnsweredDate(Info.lastAnsweredDate)
{ }