/* Copyright © 2024 Com2uS Platform Corp. All Rights Reserved. */
#include "Types/HiveMatchMakingTypes.h"

FHiveMatchMakingData::FHiveMatchMakingData(const hive::MatchMakingData& MatchMakingData)
: requestPlayerId(MatchMakingData.requestPlayerId)
, requestGameIndex(MatchMakingData.requestGameIndex)
, requestMatchId(MatchMakingData.requestMatchId)
, requestStatus(UTF8_TO_TCHAR(MatchMakingData.requestStatus.c_str()))
, requestTimeUtc(UTF8_TO_TCHAR(MatchMakingData.requestTimeUtc.c_str()))
, requestPoint(MatchMakingData.requestPoint)
, requestExtraData(UTF8_TO_TCHAR(MatchMakingData.requestExtraData.c_str()))
, matchingStatus(UTF8_TO_TCHAR(MatchMakingData.matchingStatus.c_str()))
, matchingId(UTF8_TO_TCHAR(MatchMakingData.matchingId.c_str()))
, matchingType(UTF8_TO_TCHAR(MatchMakingData.matchingType.c_str()))
{ 
    for (const auto& PlayerInfo : MatchMakingData.matchingPlayerInfoList) {
        FHiveMatchingResultPlayerInfo MatchingResultPlayerInfo(PlayerInfo);
        this->matchingPlayerInfoList.Emplace(MatchingResultPlayerInfo);
    }

    for (const auto& TeamInfo : MatchMakingData.matchingTeamInfoList) {
        FHiveMatchingResultTeamInfo MatchingResultTeamInfo(TeamInfo);
        this->matchingTeamInfoList.Emplace(MatchingResultTeamInfo);
    }
}

FHiveMatchMakingGroupData::FHiveMatchMakingGroupData(const hive::MatchMakingGroupData& MatchMakingGroupData)
: groupCode(UTF8_TO_TCHAR(MatchMakingGroupData.groupCode.c_str()))
, ownerPlayerId(MatchMakingGroupData.ownerPlayerId)
, requestGameIndex(MatchMakingGroupData.requestGameIndex)
, requestMatchId(MatchMakingGroupData.requestMatchId)
, requestStatus(UTF8_TO_TCHAR(MatchMakingGroupData.requestStatus.c_str()))
, requestTimeUtc(UTF8_TO_TCHAR(MatchMakingGroupData.requestTimeUtc.c_str()))
, matchingStatus(UTF8_TO_TCHAR(MatchMakingGroupData.matchingStatus.c_str()))
, matchingId(UTF8_TO_TCHAR(MatchMakingGroupData.matchingId.c_str()))
, matchingType(UTF8_TO_TCHAR(MatchMakingGroupData.matchingType.c_str()))
{
    for (const auto& MemberInfo : MatchMakingGroupData.memberInfoList) {
        FHiveMatchingMemberInfo MatchingMemberInfo(MemberInfo);
        this->memberInfoList.Emplace(MatchingMemberInfo);
    } 

    for (const auto& TeamInfo : MatchMakingGroupData.matchingTeamInfoList) {
        FHiveMatchingResultTeamInfo MatchingResultTeamInfo(TeamInfo);
        this->matchingTeamInfoList.Emplace(MatchingResultTeamInfo);
    }
}

FHiveMatchingMemberInfo::FHiveMatchingMemberInfo(const hive::MatchingMemberInfo& MatchingMemberInfo)
: playerId(MatchingMemberInfo.playerId)
, ready(MatchingMemberInfo.ready)
, point(MatchingMemberInfo.point)
, extraData(UTF8_TO_TCHAR(MatchingMemberInfo.extraData.c_str()))
{ }

FHiveMatchingResultPlayerInfo::FHiveMatchingResultPlayerInfo(const hive::MatchingResultPlayerInfo& MatchingResultPlayerInfo)
: playerId(MatchingResultPlayerInfo.playerId)
, point(MatchingResultPlayerInfo.point)
, extraData(UTF8_TO_TCHAR(MatchingResultPlayerInfo.extraData.c_str()))
{ }

FHiveMatchingResultTeamInfo::FHiveMatchingResultTeamInfo(const hive::MatchingResultTeamInfo& MatchingResultTeamInfo)
: teamIndex(MatchingResultTeamInfo.teamIndex)
{ 
    for (const auto& PlayerInfo : MatchingResultTeamInfo.playerInfos) {
        FHiveMatchingResultPlayerInfo MatchingResultPlayerInfo(PlayerInfo);
        this->playerInfos.Emplace(MatchingResultPlayerInfo);
    }
}