#ifndef __HIVE_CPPPLUGIN_H__
#define  __HIVE_CPPPLUGIN_H__


#include "HIVE_CPP.h"

#define HIVE_SETVALUEFROMJSONSTRING(member,jsonObj,jsonName) do { \
auto jsonValue = jsonObj.get(jsonName); \
if(!jsonValue.is<picojson::null>()) \
member = jsonValue.get<std::string>(); \
} while(0)

#define HIVE_SETVALUEFROMJSONNUMBER(member,type,jsonObj,jsonName) do { \
auto jsonValue = jsonObj.get(jsonName); \
if(!jsonValue.is<picojson::null>()) \
member = static_cast<type>(jsonValue.get<double>()); \
} while(0)

NS_HIVE_BEGIN

std::string to_string(const long long value);
std::string to_string(const int value);
std::string to_string(const double value);
// C++ 플러그인 내부에서 사용하는 유틸성 클래스

class HIVESDK_DLLEXPORT HiveCppPlugin
{
public:

	static picojson::object createParam(std::string className, std::string methodName);


	static picojson::value callNative(picojson::object jsonParam);
    static picojson::value callNative(std::string jsonParam);


	static void callEngine(std::string jsonParamString);
};


NS_HIVE_END		// namespace hive


#endif		// __HIVE_CPPPLUGIN_H__



