/**
 * @file    HIVE_SocialV4.h
 *
 * @author  disker
 * @date		2016-2021
 * @copyright	Copyright © GAMEVIL COM2US PLATFORM Inc. All Right Reserved.
 *  \brief		\copydoc SocialV4
 */

/**
 * @defgroup SocialV4
 * @ingroup SocialV4
 * @addgroup SocialV4
 * @{
 */

#ifndef __HIVE_SOCIALV4_H__
#define  __HIVE_SOCIALV4_H__


#include "HIVE_ResultAPI.h"


NS_HIVE_BEGIN


class ResultAPI;


/**
 * @ingroup SocialV4
 * @author		disker
 * @since		4.15.4
 * \~korean SocialV4.<br/>
 *
 * \~english SocialV4.<br/>
 */
class HIVESDK_DLLEXPORT SocialV4
{
public:


    enum class ProviderType {
        HIVE = 1,
        FACEBOOK
    };

    enum class ViewType {
        FullScreen,
        Frame
    };


    /**
     * \~korean 커뮤니티 페이지 요청 결과 통지
     * 
     * @param result            API 호출 결과
     * \~english Community page request result callback
     * 
     * @param result            Result of API
     * \~
     * @ingroup SocialV4
     * 
     */
    typedef std::function<void(ResultAPI const & result)> onShowCommunity;

    
    /**
     * \~korean 사진 컨텐츠 공유 결과 통지
     * 
     * @param result            API 호출 결과
     * \~english Photo content sharing result callback
     * 
     * @param result            Result of API
     * \~
     * @ingroup SocialV4
     * 
     */
    typedef std::function<void(ResultAPI const & result)> onSharePhoto;


    /**
     * \~korean 커뮤니티 페이지 요청 API
     * 
     * @param providerType 요청 타입
     * @param listener showCommunity 결과 통지
     * \~english Request community page
     * 
     * @param providerType request type
	 * @param listener showCommunity result callback
     * \~
     * 
     * @ingroup SocialV4
     */
    static void showCommunity(ProviderType providerType, onShowCommunity listener);

    /**
     * \~korean 커뮤니티 페이지 요청 API
     *
     * @param providerType 요청 타입
     * @param viewType 요청 UI 타입
     * @param listener showCommunity 결과 통지
     * \~english Request community page
     *
     * @param providerType request type
     * @param viewType request UI type
     * @param listener showCommunity result callback
     * \~
     *
     * @ingroup SocialV4
     */
    static void showCommunity(ProviderType providerType, ViewType viewType, onShowCommunity listener);


    /**
     * \~korean 사진 공유 API
     * 
     * @param providerType 요청 타입
     * @param listener sharePhotoContent 결과 통지
     * \~english Photo Share API.
     * 
     * @param providerType request type
	 * @param listener sharePhotoContent result callback
     * \~
     * 
     * @ingroup SocialV4
     */
    static void sharePhoto(ProviderType providerType, onSharePhoto listener);
    
    // Native 영역에서 호출된 요청을 처리하기 위한 플러그인 내부 코드
    static void executeEngine(picojson::value jsonParam);

private:

    static std::string stringProviderType(ProviderType providerType);
    static std::string stringViewType(ViewType viewType);

};


NS_HIVE_END		// namespace hive


#endif		// __HIVE_SOCIALV4_H__


/** @} */



