#pragma once
#include "CoreMinimal.h"

template<typename T> /* <T> 구현체 타입(e.g. IHiveAuthV4Impl) */
class IHiveInterface {
public:
    static void SetPlatformImpl(TSharedPtr<T> PlatformImpl) {
        ImplInstance = PlatformImpl;
    }

protected:
    static TSharedPtr<T> GetInstance() {
        if (!ImplInstance.IsValid()) {
            ImplInstance = MakeShared<T>();
        }
        return ImplInstance;
    }

private:
    static TSharedPtr<T> ImplInstance;
};

template<typename T>
TSharedPtr<T> IHiveInterface<T>::ImplInstance = nullptr;