/**
 * @file        HiveLogger.h
 *
 * @date        2025
 * @copyright   Copyright © 2025 Com2uS Platform Corp. All Rights Reserved.
 * @defgroup FHiveLogger
 * @{
 * \~korean
 * 로그 정보를 기록하는 클래스<br>
 * (네이티브 영역을 호출하기 때문에 부하를 고려해서 로그를 기록해야 한다.)
 * 
 * \~english
 * Class that records log information<br/>
 * (Logs should be recorded taking into account the load, because you are calling the native code.)<br/>
 *
 * \~
 */
#pragma once

#include "CoreMinimal.h"
#include "HiveInterface.h"
#include "Impl/HiveLoggerImpl.h"

/**
 * @brief 로그 정보를 기록하는 클래스<br/>
 * (네이티브 영역을 호출하기 때문에 부하를 고려해서 로그를 기록해야 한다.)<br/><br/>
 *
 * @ingroup FHiveLogger
 */
class HIVESDK_API FHiveLogger : public IHiveInterface<IHiveLoggerImpl>
{
public:
    /**
     * 로그 메시지 발생 시 통지 받을 핸들러 설정
     * 
     * \~
     * @ingroup FHiveLogger
     */
    static void SetLoggerDelegate(const FHiveLoggerOnLogDelegate& Delegate);

    /**
     * \~korean 로그 정보 기록<br/>
     * 로그 출력에 대한 Base API
     * HIVE에서 리모트 로깅 활성화 시 원격지로 로그를 보내는 것이 가능하다.
     * 단, 네트워크 통신이 들어가는 만큼 과도하게 많은양의 로그나 반복적인 로그는 찍지 않도록 주의할것.
     * \~english Record log information<br/>
     * (Logs should be recorded taking into account the load, because you are calling the native code.)
     * \~
     * @ingroup FHiveLogger
     */
    static void Log(const FString& Message);

    /**
     * log 함수를 사용했을때 로그를 원격지 혹은 로컬에 출력하는지의 여부를 반환한다.
     *
     * @return 로그 활성화 여부
     * 
     * \~
     * @ingroup FHiveLogger
     */
    static bool IsActivateLogging();

    /**
     * Hive Core/Service 로그의 노출 타입을 조정한다.
     * 
     * \~
     * @ingroup FHiveLogger
     */
    static void SetLogFilter(const FHiveLogFilter& LogFilter);
};