/* Copyright © 2024 Com2uS Platform Corp. All Rights Reserved. */
#pragma once

/* Unreal Engine Header */
#include "CoreMinimal.h"
#include "Dom/JsonObject.h"
#include "Serialization/JsonSerializer.h"

/* Hive SDK Header */
#include "CPP/HIVE_CPP.h"
#include "HiveResultAPI.h"
#include "Types/HiveAnalyticsTypes.h"

DECLARE_DELEGATE_TwoParams(FHiveAnalyticsOnShowConsentModeDelegate, const FHiveResultAPI& /* Result */, const TArray<FHiveConsentStatus>& /* ConsentStatus */);

class HIVESDK_API IHiveAnalyticsImpl
{
public:
    virtual void SendAnalyticsLog(const TSharedPtr<FJsonObject>& LogData);
    virtual void SetEnableTracker(const FString& Name, bool IsEnable);
    virtual void SendEvent(const FString& EventName);
    virtual void SendEventWithAttributes(const FString& EventName, const FHiveAnalyticsAttributes& Attributes);
    virtual void SendAdRevenueEvent(const FHiveAnalyticsAdRevenue& AdRevenue);
    virtual void SendUserEntryFunnelsLogs(const FString& FunnelTrack, const FString& Tag);
    virtual void ShowConsentModeIfRequire(bool CheckCmp, const TOptional<FHiveConsentMode>& ConsentMode, const FHiveAnalyticsOnShowConsentModeDelegate& Delegate);
    virtual void ShowConsentMode(const TOptional<FHiveConsentMode>& ConsentMode, const FHiveAnalyticsOnShowConsentModeDelegate& Delegate);

    /* @NOTSUPPORT
     * - void SetConsent()
     * - void GetConsent()
     */ 

private:
    hive::AnalyticsAdRevenue ConvertAnalyticsAdRevenue(const FHiveAnalyticsAdRevenue& AdRevenue);
    hive::ConsentMode* CreateConsentMode(const FHiveConsentMode& ConsentMode);
};
