/* Copyright © 2024 Com2uS Platform Corp. All Rights Reserved. */
#pragma once

/* Unreal Engine Header */
#include "CoreMinimal.h"

/* Hive SDK Header */
#include "CPP/HIVE_CPP.h"
#include "HiveResultAPI.h"
#include "Types/HiveConfigurationTypes.h"

DECLARE_DELEGATE_TwoParams(FHiveConfigurationOnMetaDataDelegate, const FHiveResultAPI& /* Result */, const FString& /* Value */);

class HIVESDK_API IHiveConfigurationImpl
{
public:
    virtual FString GetConfiguration();
    virtual FString GetHiveSDKVersion();
    virtual FString GetReferenceSDKVersion();
    
    virtual FString GetAppId();
    virtual void SetAppId(const FString& AppId);

    virtual FString GetHiveCertificationKey();
    virtual void SetHiveCertificationKey(const FString& Key);

    virtual EHiveZoneType GetZone();
    virtual void SetZone(const EHiveZoneType& Type);

    virtual FString GetServerId();
    virtual void SetServerId(const FString& ServerId);
    virtual void UpdateServerId(const FString& ServerId);

    virtual FString GetGameLanguage();
    virtual void SetGameLanguage(const FString& Language);
    virtual void UpdateGameLanguage(const FString& Language);

    virtual bool GetUseLog();
    virtual void SetUseLog(bool bUseLog);

    virtual FString GetCompany();
    virtual void SetCompany(const FString& Company);

    virtual FString GetChannel();
    virtual void SetChannel(const FString& Channel);

    virtual int32 GetHttpConnectTimeout();
    virtual void SetHttpConnectTimeout(int32 second);
    virtual int32 GetHttpReadTimeout();
    virtual void SetHttpReadTimeout(int32 second);
    virtual int32 GetMaxGameLogSize();
    virtual void SetMaxGameLogSize(int32 size);

    virtual FString GetMarket();
    virtual void SetMarket(const FString& Market);

    virtual FString GetHiveCountry();
    virtual FString GetHiveTimeZone();

    virtual uint32 GetAnalyticsSendLimit();
    virtual void SetAnalyticsSendLimit(uint32 Limit);
    virtual uint32 GetAnalyticsQueueLimit();
    virtual void SetAnalyticsQueueLimit(uint32 Limit);
    virtual float GetAnalyticsSendCycleSeconds();
    virtual void SetAnalyticsSendCycleSeconds(float seconds);

    virtual bool GetAgeGateU13();
    virtual void SetAgeGateU13(bool bEnable);
    virtual EHiveThemeType GetHiveTheme();
    virtual void SetHiveTheme(EHiveThemeType Type);
    virtual void SetHiveOrientation(const FString& Orientation);
    virtual void SetConfigurations(EHiveConfigType Type, const FString& Value);
    virtual void GetMetaData(const FString& Key, bool bForceReload, const FHiveConfigurationOnMetaDataDelegate& Delegate);
    virtual void SetUseHercules(bool bEnable);
    virtual bool GetCrossPromotionBannerShowing();
    virtual void SetCrossPromotionBannerShowing(bool showing);
    virtual bool GetAgeGateU16Agree();
    virtual bool GetLegalGuardianConsentAgree();
    virtual void SetUsePrivateBrowsingForAuth(bool use);
    virtual bool GetEnableGameController();
    virtual void SetEnableGameController(bool enable);

    virtual void  SetChatConnectionTimeout(int32 Seconds);
    virtual int32 GetChatConnectionTimeout();

    /*
     * [NOT_SUPPORT]
     * - setHivePermissionViewOn()
     * - getPermissionViewData()
     * - setHiveCommunityUrl()
     */
};
