/* Copyright © 2024 Com2uS Platform Corp. All Rights Reserved. */
#pragma once

/* Unreal Engine Header */
#include "CoreMinimal.h"

/* Hive SDK Header */
#include "CPP/HIVE_CPP.h"
#include "HiveResultAPI.h"


using DataStoreData = TMap<FString, FString>;
using DataStoreUsersData = TMap<int64, FString>;

DECLARE_DELEGATE_OneParam(FHiveDataStoreOnSetDelegate, const FHiveResultAPI& /* Result */);
DECLARE_DELEGATE_TwoParams(FHiveDataStoreOnGetDelegate, const FHiveResultAPI& /* Result */, const FString& /* Data */);
DECLARE_DELEGATE_TwoParams(FHiveDataStoreOnMyDataDelegate, const FHiveResultAPI& /* Result */, const DataStoreData& /* MyData*/);
DECLARE_DELEGATE_ThreeParams(FHiveDataStoreOnUsersDataDelegate, const FHiveResultAPI& /* Result */, const FString& /* Key */, const DataStoreUsersData& /* UsersData */);

class HIVESDK_API IHiveDataStoreImpl
{
public:
    virtual void Set(const FString& Key, const FString& Value, const FHiveDataStoreOnSetDelegate& Delegate);
    virtual void Set(const DataStoreData& Data, const FHiveDataStoreOnSetDelegate& Delegate);
    virtual void Get(const FString& Key, const FHiveDataStoreOnGetDelegate& Delegate);
    virtual void GetMyData(const FHiveDataStoreOnMyDataDelegate& Delegate);
    virtual void GetUsersData(const FString& Key, const FHiveDataStoreOnUsersDataDelegate& Delegate);
};