/* Copyright © 2024 Com2uS Platform Corp. All Rights Reserved. */
#pragma once

/* Unreal Engine Header */
#include "CoreMinimal.h"

/* Hive SDK Header */
#include "CPP/HIVE_CPP.h"
#include "HiveResultAPI.h"
#include "Types/HiveIAPV4Types.h"

DECLARE_DELEGATE_TwoParams(FHiveIAPV4OnMarketConnectDelegate, const FHiveResultAPI& /* Result */, const TArray<EHiveIAPV4Type>& /* MarketIDs */);
DECLARE_DELEGATE_ThreeParams(FHiveIAPV4OnProductInfoDelegate, const FHiveResultAPI& /* Result */, const TArray<FHiveIAPV4Product>& /* IAPV4ProductList */, uint32 /* Balance */);
DECLARE_DELEGATE_TwoParams(FHiveIAPV4OnPurchaseDelegate, const FHiveResultAPI& /* Result */, const FHiveIAPV4Receipt& /* IAPV4Receipt */);
DECLARE_DELEGATE_TwoParams(FHiveIAPV4OnRestoreDelegate, const FHiveResultAPI& /* Result */, const TArray<FHiveIAPV4Receipt>& /* IAPV4ReceiptList */);
DECLARE_DELEGATE_TwoParams(FHiveIAPV4OnTransactionFinishDelegate, const FHiveResultAPI& /* Result */, const FString& /* MarketPid */);
DECLARE_DELEGATE_TwoParams(FHiveIAPV4OnTransactionMultiFinishDelegate, const TArray<FHiveResultAPI>&, const TArray<FString>& /* MarketPidList */);
DECLARE_DELEGATE_TwoParams(FHiveIAPV4OnBalanceDelegate, const FHiveResultAPI& /* Result */, int32 /* Balance */);
DECLARE_DELEGATE_TwoParams(FHiveIAPV4OnCheckPromotePurchaseDelegate, const FHiveResultAPI& /* Result */, const FString& /* MarketPid */);
DECLARE_DELEGATE_OneParam(FHiveIAPV4OnInAppMessagesDelegate, int32 /* ResponseCode */);
DECLARE_DELEGATE_TwoParams(FHiveIAPV4OnGetConsumeInfoAgreementDelegate, const FHiveResultAPI& /* Result */, const FHiveIAPV4ConsumeInfoUserAgreement& /* Info */);
DECLARE_DELEGATE_TwoParams(FHiveIAPV4OnShowConsumeInfoAgreementDelegate, const FHiveResultAPI& /* Result */, bool /* DidAgree */);


using FIAPV4OnMarketSelectionDelegate = FHiveIAPV4OnMarketConnectDelegate;

class HIVESDK_API IHiveIAPV4Impl
{
public:
    virtual void MarketConnect(const FHiveIAPV4OnMarketConnectDelegate& Delegate);
    virtual void GetMarketProductInfo(const TArray<FString>& MarketPidList, const FHiveIAPV4OnProductInfoDelegate& Delegate);
    virtual void GetProductInfo(const FHiveIAPV4OnProductInfoDelegate& Delegate);
    virtual void GetSubscriptionProductInfo(const FHiveIAPV4OnProductInfoDelegate& Delegate);
    virtual void Purchase(const FString& MarketPid, const FString& IapPayload, const FHiveIAPV4OnPurchaseDelegate& Delegate);
    virtual void Purchase(const FString& MarketPid, const FString& IapPayload, int quantity, const FHiveIAPV4OnPurchaseDelegate& Delegate);
    virtual void PurchaseSubscription(const FHiveIAPV4PurchaseParam& Param, const FHiveIAPV4OnPurchaseDelegate& Delegate);
    virtual void Restore(const FHiveIAPV4OnRestoreDelegate& Delegate);
    virtual void RestoreSubscription(const FHiveIAPV4OnRestoreDelegate& Delegate);
    virtual void TransactionFinish(const FString& MarketPid, const FHiveIAPV4OnTransactionFinishDelegate& Delegate);
    virtual void TransactionMultiFinish(const TArray<FString>& MarketPidList, const FHiveIAPV4OnTransactionMultiFinishDelegate& Delegate);
    virtual void ShowMarketSelection(const FIAPV4OnMarketSelectionDelegate& Delegate);
    virtual void GetBalanceInfo(const FHiveIAPV4OnBalanceDelegate& Delegate);
    virtual void ShowCharge(const FHiveIAPV4OnBalanceDelegate& Delegate);
    virtual void CheckPromotePurchase(const FHiveIAPV4OnCheckPromotePurchaseDelegate& Delegate);
    virtual TOptional<EHiveIAPV4Type> GetSelectedMarket();
    virtual FString GetAccountUuid();
    virtual void ShowInAppMessages(int32 CategoryId, const FHiveIAPV4OnInAppMessagesDelegate& Delegate);
    virtual void GetConsumeInfoAgreement(const FHiveIAPV4OnGetConsumeInfoAgreementDelegate& Delegate);
    virtual void ShowConsumeInfoAgreement(const FHiveIAPV4OnShowConsumeInfoAgreementDelegate& Delegate);
    

    /* @NOTSUPPORT
     * - void PurchaseSubscriptionUpdate()
     */ 

private:
    hive::IAPV4PurchaseParam ConvertIAPV4PurchaseParam(const FHiveIAPV4PurchaseParam& Param);
};
