/* Copyright © 2024 Com2uS Platform Corp. All Rights Reserved. */
#pragma once

/* Unreal Engine Header */
#include "CoreMinimal.h"

/* Hive SDK Header */
#include "CPP/HIVE_CPP.h"
#include "HiveResultAPI.h"
#include "Types/HiveLoggerTypes.h"

DECLARE_DELEGATE_ThreeParams(FHiveLoggerOnLogDelegate, const FString& /* Tag */, const FString& /* Level */, const FString& /* Message */);

class HIVESDK_API IHiveLoggerImpl
{
public:
    virtual void SetLoggerDelegate(const FHiveLoggerOnLogDelegate& Delegate);
    virtual void Log(const FString& Message);
    virtual bool IsActivateLogging();
    virtual void SetLogFilter(const FHiveLogFilter& LogFilter);
};
