/* Copyright © 2024 Com2uS Platform Corp. All Rights Reserved. */
#pragma once

/* Unreal Engine Header */
#include "CoreMinimal.h"

/* Hive SDK Header */
#include "CPP/HIVE_CPP.h"
#include "HiveResultAPI.h"
#include "Types/HiveMatchMakingTypes.h"

DECLARE_DELEGATE_OneParam(FHiveMatchMakingOnResultDelegate, const FHiveResultAPI& /* Result */);
DECLARE_DELEGATE_TwoParams(FHiveMatchMakingOnMatchMakingDataDelegate, const FHiveResultAPI& /* Result */, const FHiveMatchMakingData& /* MatchMakingData */);
DECLARE_DELEGATE_TwoParams(FHiveMatchMakingOnMatchMakingGroupDataDelegate, const FHiveResultAPI& /* Result */, const FHiveMatchMakingGroupData& /* GroupData */);

class HIVESDK_API IHiveMatchMakingImpl
{
    public:
    // Personal Matching
    virtual void RequestMatchMaking(int32 MatchId, int32 Point, const FString& ExtraData, const FHiveMatchMakingOnMatchMakingDataDelegate& Delegate);
    virtual void GetRequestingStatus(int32 MatchId, const FHiveMatchMakingOnMatchMakingDataDelegate& Delegate);
    virtual void DeleteRequesting(int32 MatchId, const FHiveMatchMakingOnResultDelegate& Delegate);

    // Group Matching
    virtual void CreateGroup(int32 MatchId, int32 Point, const FString& ExtraData, const FHiveMatchMakingOnMatchMakingGroupDataDelegate& Delegate);
    virtual void JoinGroup(int32 MatchId, const FString& GroupCode, int32 Point, const FString& ExtraData, const FHiveMatchMakingOnMatchMakingGroupDataDelegate& Delegate);
    virtual void LeaveGroup(int32 MatchId, const FHiveMatchMakingOnResultDelegate& Delegate);
    virtual void KickGroupUser(int32 MatchId, int64 TargetPlayerId, const FHiveMatchMakingOnMatchMakingGroupDataDelegate& Delegate);
    virtual void GetGroupInfoByUser(int32 MatchId, const FHiveMatchMakingOnMatchMakingGroupDataDelegate& Delegate);
    virtual void GetGroupInfoByGroupCode(const FString& GroupCode, const FHiveMatchMakingOnMatchMakingGroupDataDelegate& Delegate);
    virtual void UpdateGroupUser(int32 MatchId, bool Ready, int32 Point, const FString& ExtraData, const FHiveMatchMakingOnMatchMakingGroupDataDelegate& Delegate);
    virtual void RequestGroupMatching(int32 MatchId, const FHiveMatchMakingOnMatchMakingGroupDataDelegate& Delegate);
    virtual void DeleteGroupMatching(int32 MatchId, const FHiveMatchMakingOnMatchMakingGroupDataDelegate& Delegate);
};