/* Copyright © 2024 Com2uS Platform Corp. All Rights Reserved. */
#pragma once

/* Unreal Engine Header */
#include "CoreMinimal.h"

/* Hive SDK Header */
#include "CPP/HIVE_CPP.h"
#include "HiveResultAPI.h"
#include "Types/HivePlatformHelperTypes.h"

DECLARE_DELEGATE_ThreeParams(FHivePlatformHelperOnUserPermissionsDelegate, const FHiveResultAPI& /* Result */, const TArray<FString>& /* GrantedRequests */, const TArray<FString>& /* DeniedRequests */);
DECLARE_DELEGATE_OneParam(FHivePlatformHelperOnShowInAppBrowserDelegate, const FHiveResultAPI& /* Result */);
DECLARE_DELEGATE_OneParam(FHivePlatformHelperOnShowInAppWebViewDelegate, const FHiveResultAPI& /* Result */);
DECLARE_DELEGATE_TwoParams(FHivePlatformHelperOnGetLaunchParametersDelegate, const FHiveResultAPI& /* Result */, const FString& /* DeniedRequests */);

class HIVESDK_API IHivePlatformHelperImpl
{
public:
    virtual void RequestUserPermissions(const TArray<FString>& Requests, const FHivePlatformHelperOnUserPermissionsDelegate& Delegate);
    virtual void CompleteUpdate(int32 state);
    virtual void ShowInAppBrowser(const FHiveInAppBrowserParam& Param, const FHivePlatformHelperOnShowInAppBrowserDelegate& Delegate);
    virtual void OpenBrowser(const FHiveOpenBrowserParam& Param);
    virtual void ShowInAppWebView(const FHiveInAppWebViewParam& Param, const FHivePlatformHelperOnShowInAppWebViewDelegate& Delegate);
    virtual void GetLaunchParameters(const FHivePlatformHelperOnGetLaunchParametersDelegate& Delegate);

    /*
     * @NOT_SUPPORT
     * - void Share()
     */
};