/* Copyright © 2024 Com2uS Platform Corp. All Rights Reserved. */
#pragma once

/* Unreal Engine Header */
#include "CoreMinimal.h"

/* Hive SDK Header */
#include "CPP/HIVE_CPP.h"
#include "HiveResultAPI.h"
#include "Types/HiveProviderAppleTypes.h"

DECLARE_DELEGATE_OneParam(FHiveProviderAppleOnReportLeaderboard, const FHiveResultAPI& /* Result */);
DECLARE_DELEGATE_OneParam(FHiveProviderAppleOnShowLeaderboard, const FHiveResultAPI& /* Result */);
DECLARE_DELEGATE_TwoParams(FHiveProviderAppleOnLoadAchievements, const FHiveResultAPI& /* Result */, const TArray<FHiveProviderAppleAchievement>& /* Achievements */)
DECLARE_DELEGATE_OneParam(FHiveProviderAppleOnReportAchievement, const FHiveResultAPI& /* Result */);
DECLARE_DELEGATE_OneParam(FHiveProviderAppleOnShowAchievement, const FHiveResultAPI& /* Result */);
DECLARE_DELEGATE_OneParam(FHiveProviderAppleOnResetAchievement, const FHiveResultAPI& /* Result */);

class HIVESDK_API IHiveProviderAppleImpl
{
public:
    virtual void ReportScore(const FString& Score, const FString& LeaderboardIdentifier, const FHiveProviderAppleOnReportLeaderboard& Delegate);
    virtual void ShowLeaderboard(const FHiveProviderAppleOnShowLeaderboard& Delegate);
    virtual void LoadAchievements(const FHiveProviderAppleOnLoadAchievements& Delegate);
    virtual void ReportAchievement(const FString& Percent, bool ShowCompletionBanner, const FString& AchievementIdentifier, const FHiveProviderAppleOnReportAchievement& Delegate);
    virtual void ShowAchievements(const FHiveProviderAppleOnShowAchievement& Delegate);
    virtual void ResetAchievements(const FHiveProviderAppleOnResetAchievement& Delegate);
};
