/* Copyright © 2024 Com2uS Platform Corp. All Rights Reserved. */
#pragma once

/* Unreal Engine Header */
#include "CoreMinimal.h"

/* Hive SDK Header */
#include "CPP/HIVE_CPP.h"
#include "HiveResultAPI.h"
#include "Types/HivePushTypes.h"


DECLARE_DELEGATE_TwoParams(FHivePushOnRemotePushDelegate, const FHiveResultAPI& /* Result */, const FHiveRemotePush& /* RemotePush */)
DECLARE_DELEGATE_TwoParams(FHivePushOnLocalPushDelegate, const FHiveResultAPI& /* Result */, const FHiveLocalPush& /* LocalPush */)
DECLARE_DELEGATE_TwoParams(FHivePushOnPushSettingDelegate, const FHiveResultAPI& /* Result */, const FHivePushSetting& /* PushSetting */)

class HIVESDK_API IHivePushImpl
{
public:
    virtual void GetRemotePush(const FHivePushOnRemotePushDelegate& Delegate);
    virtual void SetRemotePush(const FHiveRemotePush& RemotePush, const FHivePushOnRemotePushDelegate& Delegate);
    virtual void RegisterLocalPush(const FHiveLocalPush& LocalPush, const FHivePushOnLocalPushDelegate& Delegate);
    virtual void UnregisterLocalPush(int32 NoticeId);
    virtual void UnregisterLocalPushes(TArray<int32> NoticeIds);
    virtual void UnregisterAllLocalPushes();
    virtual void SetForegroundPush(const FHivePushSetting& Setting, const FHivePushOnPushSettingDelegate& Delegate);
    virtual void GetForegroundPush(const FHivePushOnPushSettingDelegate& Delegate);
    virtual void RequestPushPermission();

};
