/* Copyright © 2024 Com2uS Platform Corp. All Rights Reserved. */
#pragma once

/* Unreal Engine Header */
#include "CoreMinimal.h"

/* Hive SDK Header */
#include "CPP/HIVE_CPP.h"
#include "HIVESDK.h"
#include "HiveResultAPI.h"
#include "Types/HiveSocialV4Types.h"

DECLARE_DELEGATE_OneParam(FHiveSocialV4OnShowCommunityDelegate, const FHiveResultAPI& /* Result */)
DECLARE_DELEGATE_OneParam(FHiveSocialV4OnSharePhotoDelegate, const FHiveResultAPI& /* Result */)

class HIVESDK_API IHiveSocialV4Impl
{
public:
    virtual void ShowCommunity(ESocialV4ProviderType ProviderType, const FHiveSocialV4OnShowCommunityDelegate& Delegate);
    virtual void ShowCommunity(ESocialV4ProviderType ProviderType, ESocialV4ViewType ViewType, const FHiveSocialV4OnShowCommunityDelegate& Delegate);
    virtual void SharePhoto(ESocialV4ProviderType ProviderType, const FHiveSocialV4OnSharePhotoDelegate& Delegate);
};
