/* Copyright © 2024 Com2uS Platform Corp. All Rights Reserved. */
#pragma once

/* Unreal Engine Header */
#include "CoreMinimal.h"

/* Hive SDK Header */
#include "CPP/HIVE_CPP.h"

class FHiveMatchMakingData;
class FHiveMatchMakingGroupData;
class FHiveMatchingMemberInfo;
class FHiveMatchingResultPlayerInfo;
class FHiveMatchingResultTeamInfo;

/**
 * @brief Match Making 콜백 데이터 정보<br/>
 *
 * @ingroup FHiveMatchMaking
 */
class HIVESDK_API FHiveMatchMakingData
{
public:
    int64 requestPlayerId;
    int requestGameIndex;
    int requestMatchId;

    FString requestStatus;
    FString requestTimeUtc;
    int requestPoint;
    FString requestExtraData;

    FString matchingStatus;
    FString matchingId;
    FString matchingType;

    TArray<FHiveMatchingResultPlayerInfo> matchingPlayerInfoList;
    TArray<FHiveMatchingResultTeamInfo> matchingTeamInfoList;

    FHiveMatchMakingData() {};
    FHiveMatchMakingData(const hive::MatchMakingData& MatchMakingData);
    virtual ~FHiveMatchMakingData() = default;
};

/**
 * @brief 매치 메이킹 그룹 데이터 정보<br/>
 *
 * @ingroup FHiveMatchMaking
 */
class HIVESDK_API FHiveMatchMakingGroupData 
{
public:
    FString groupCode;
    int64 ownerPlayerId;

    TArray<FHiveMatchingMemberInfo> memberInfoList;
    
    int requestGameIndex;
    int requestMatchId;
    
    FString requestStatus;
    FString requestTimeUtc;
    
    FString matchingStatus;
    FString matchingId;
    FString matchingType;

    TArray<FHiveMatchingResultTeamInfo> matchingTeamInfoList;

    FHiveMatchMakingGroupData() {};
    FHiveMatchMakingGroupData(const hive::MatchMakingGroupData& MatchMakingGroupData);
    virtual ~FHiveMatchMakingGroupData() = default;
};

/**
 * @brief 매치 메이킹 그룹 멤버 정보<br/>
 *
 * @ingroup FHiveMatchMaking
 */
class HIVESDK_API FHiveMatchingMemberInfo {
public:
    int64 playerId;
    bool ready;
    int point;
    FString extraData;
    
    FHiveMatchingMemberInfo() {};
    FHiveMatchingMemberInfo(const hive::MatchingMemberInfo& MatchingMemberInfo);
    virtual ~FHiveMatchingMemberInfo() = default;
};

class HIVESDK_API FHiveMatchingResultPlayerInfo
{
public:
    int64 playerId;
    int point;
    FString extraData;

    FHiveMatchingResultPlayerInfo() {};
    FHiveMatchingResultPlayerInfo(const hive::MatchingResultPlayerInfo& MatchingResultPlayerInfo);
    virtual ~FHiveMatchingResultPlayerInfo() = default;
};

class HIVESDK_API FHiveMatchingResultTeamInfo
{
public:
    int teamIndex;
    TArray<FHiveMatchingResultPlayerInfo> playerInfos;

    FHiveMatchingResultTeamInfo() {};
    FHiveMatchingResultTeamInfo(const hive::MatchingResultTeamInfo& MatchingResultTeamInfo);
    virtual ~FHiveMatchingResultTeamInfo() = default;
};