/* Copyright © 2024 Com2uS Platform Corp. All Rights Reserved. */
#pragma once

/* Unreal Engine Header */
#include "CoreMinimal.h"

/* Hive SDK Header */

/**
 * @brief 인앱 브라우저 설정을 위한 파라미터
 *
 * @see Url: 연결 URL
 * @see ButtonColor: 버튼 색상 (hex color)
 * @see NavigationColor: 네비게이션 바 색상 (hex color)
 * @see UrlBarHiding: 페이지 스크롤시 네비게이션 바 영역 최소화. 디폴트 값 true
 * @see AutoRedirectToExternalBrowser: 외부 브라우저 자동 연결 기능 (Android only)
 * 
 * \~
 * @ingroup FHivePlatformHelper
*/
class HIVESDK_API FHiveInAppBrowserParam
{
public:
    FString Url;
    FString ButtonColor;
    FString NavigationColor;
    bool UrlBarHiding = true;
    bool AutoRedirectToExternalBrowser = true;

    FHiveInAppBrowserParam(const FString& Url);
    virtual ~FHiveInAppBrowserParam() = default;
};

/**
 * @brief 외부 브라우저를 열기 위한 클래스
 *
 * @see Url: 연결할 URL을 나타냅니다.
 * @see UseIncognito: 시크릿 모드 사용 여부를 나타냅니다. true일 경우 시크릿 모드로 브라우저를 엽니다.
 * 
 * \~
 * @ingroup FHivePlatformHelper
 */
class HIVESDK_API FHiveOpenBrowserParam {
public:
    FString Url;
    bool UseIncognitoMode = false;

    FHiveOpenBrowserParam(const FString& url);
    virtual ~FHiveOpenBrowserParam() = default;
};

/**
 * @brief 인앱 웹뷰 설정을 위한 파라미터
 *
 * @see Url: 연결 URL
 * @see PostData: 기본값은 empty. null or empty 일 경우 get 통신을 한다. 값이 있으면 post 통신을 한다.
 * @see UseUserSession: 기본값은 false. true 시 playerId, playerToken 을 포함한 json 데이터로 post 통신한다.
 * @see UseGameWindow: 안드로이드에서만 동작한다. true로 설정한 경우, 현재 window에 웹뷰를 노출한다. pause 상태가 되지 않으며 HiveTheme와 HiveOrientation이 무시된다. 기본값은 false 이다.
 * 
 * \~
 * @ingroup FHivePlatformHelper
*/
class HIVESDK_API FHiveInAppWebViewParam
{
public:
    FString Url;
    FString PostData;
    bool UseUserSession = false;
    bool UseGameWindow = false;

    FHiveInAppWebViewParam(const FString& Url);
    virtual ~FHiveInAppWebViewParam() = default;
};