// Copyright (C) 2024 Com2uS Platform Corporation

#include "HiveDependencyAndroidSettings.h"


UHiveDependencyAndroidSettings::UHiveDependencyAndroidSettings(const FObjectInitializer& ObjectInitializer)
: Super(ObjectInitializer)
/* Hive Module*/
,bEnableHivePromotion(true)
,bEnableGoogleInAppReview(true)
,bEnableDeviceManagement(true)
,bEnableRealNameVerification(false)
,bEnableHercules(true)
,bEnableReCaptcha(true)
,bEnableDataStore(true)
,bEnableGoogleInAppUpdate(true)
,bEnableAnalyticsConsentMode(true)
,bEnableMatchMaking(true)
,bEnableChat(true)
,bEnableAdultConfirm(true)
,bEnableIdentityVerification(true)
,bEnableAgeRangeGoogle(false)
/* Auth */
,bEnableHiveMembership(true)
,bEnableGoogleSignIn(true)
,bEnableGooglePlayGames(true)
,FacebookType(EHiveDependencyFacebookType::Facebook)
,bEnableAppleSignIn(true)
,bEnableLine(false)
,bEnableVK(false)
,bEnableQQ(false)
,bEnableWechat(false)
,bEnableWeverse(false)
,bEnableHuawei(false)
,bEnableSteam(false)
,bEnableX(false)
,bEnableTelegram(false)
,bEnableXiaomi(false)
/* Push */
,PushType(EHiveDependencyPushType::FCM)
/* Market(IAPv4) */
,MarketType(EHiveDependencyMarketType::PlayStore)
,bEnableLebi(false)
,bEnableHiveStore(false)
/* Analytics */
,bEnableAdjust(false)
,bEnableAppsFlyer(false)
,bEnableSingular(false)
,bEnableFirebase(false)
,bEnableAirbridge(false)
{ }

void UHiveDependencyAndroidSettings::PostEditChangeProperty(struct FPropertyChangedEvent& PropertyChangedEvent)
{
    const FName PropertyName = (PropertyChangedEvent.MemberProperty != NULL) ? PropertyChangedEvent.MemberProperty->GetFName() : NAME_None;
    
    
    // FFilePath UPROPERTY() value cannot be read by UPL (Unreal Plugin Language) (stored in .ini as "variable = (FilePath = PATH)")
    // so, store string properties and read them from UPL
    if (PropertyName == GET_MEMBER_NAME_CHECKED(UHiveDependencyAndroidSettings, FirebaseMetaFilePath))
    {
        
        sFirebaseMetaFilePath = FPaths::ConvertRelativePathToFull(FirebaseMetaFilePath.FilePath);
        
        UE_LOG(LogTemp, Log, TEXT("Hive::firebase meta-file(google-services.json) path = %s"), *sFirebaseMetaFilePath);
        
        UpdateSinglePropertyInConfigFile(GetClass()->FindPropertyByName(GET_MEMBER_NAME_CHECKED(UHiveDependencyAndroidSettings, sFirebaseMetaFilePath)), GetDefaultConfigFilename());
    }
    else if (PropertyName == GET_MEMBER_NAME_CHECKED(UHiveDependencyAndroidSettings, HuaweiMetaFilePath))
    {
        
        sHuaweiMetaFilePath = FPaths::ConvertRelativePathToFull(HuaweiMetaFilePath.FilePath);
        
        UE_LOG(LogTemp, Log, TEXT("Hive::huawei meta-file(agconnect-services.json) path = %s"), *sHuaweiMetaFilePath);
        
        UpdateSinglePropertyInConfigFile(GetClass()->FindPropertyByName(GET_MEMBER_NAME_CHECKED(UHiveDependencyAndroidSettings, sHuaweiMetaFilePath)), GetDefaultConfigFilename());
    }
    else if (PropertyName == GET_MEMBER_NAME_CHECKED(UHiveDependencyAndroidSettings, AmazonMetaFilePath))
    {
        
        sAmazonMetaFilePath = FPaths::ConvertRelativePathToFull(AmazonMetaFilePath.FilePath);
        
        UE_LOG(LogTemp, Log, TEXT("Hive::amazon meta-file(AppstoreAuthenticationKey.pem) path = %s"), *sAmazonMetaFilePath);
        
        UpdateSinglePropertyInConfigFile(GetClass()->FindPropertyByName(GET_MEMBER_NAME_CHECKED(UHiveDependencyAndroidSettings, sAmazonMetaFilePath)), GetDefaultConfigFilename());
    }
    
    Super::PostEditChangeProperty(PropertyChangedEvent);
}

void UHiveDependencyAndroidSettings::PostInitProperties()
{
    Super::PostInitProperties();
    
    TryUpdateDefaultConfigFile("", true);
}
