// Copyright (C) 2024 Com2uS Platform Corporation

#include "HiveDependencyIOSSettings.h"


UHiveDependencyIOSSettings::UHiveDependencyIOSSettings(const FObjectInitializer& ObjectInitializer)
: Super(ObjectInitializer)
/* Hive Module*/
,bEnableHivePromotion(true)
,bEnableDeviceManagement(true)
,bEnableRealNameVerification(false)
,bEnableHercules(true)
,bEnableReCaptcha(true)
,bEnableDataStore(true)
,bEnableAnalyticsConsentMode(true)
,bEnableMatchMaking(true)
,bEnableChat(true)
,bEnableAdultConfirm(true)
,bEnableIdentityVerification(true)
,bEnableAgeRangeApple(false)
/* Auth */
,bEnableHiveMembership(true)
,bEnableGoogleSignIn(true)
,bEnableFacebook(true)
,bEnableAppleGameCenter(true)
,bEnableAppleSignIn(true)
,bEnableLine(false)
,bEnableVK(false)
,bEnableQQ(false)
,bEnableWechat(false)
,bEnableWeverse(false)
,bEnableSteam(false)
,bEnableX(false)
,bEnableTelegram(false)
/* Market(IAPv4) */
,bEnableAppleAppStore(true)
/* Analytics */
,bEnableAdjust(false)
,bEnableAppsFlyer(false)
,bEnableSingular(false)
,bEnableFirebase(false)
,bEnableAirbridge(false)
{ }

void UHiveDependencyIOSSettings::PostInitProperties()
{
    Super::PostInitProperties();
    
    TryUpdateDefaultConfigFile("", true);
}
