// Copyright (C) 2024 Com2uS Platform Corporation

#pragma once

#include "CoreMinimal.h"
#include "HiveDependencyAndroidSettings.generated.h"


UENUM()
enum class EHiveDependencyFacebookType : uint8
{
    None,
    Facebook,
    FacebookCloud   UMETA(DisplayName = "Facebook Cloud", ToolTip = "Select this option to support Facebook Cloud Platform."),
};

UENUM()
enum class EHiveDependencyPushType : uint8
{
    None,
    FCM                 UMETA(DisplayName = "Google FCM"),
    FacebookCloudA2U    UMETA(DisplayName = "Facebook Cloud A2U"),
    ADM                 UMETA(DisplayName = "Amazon ADM")
};

UENUM()
enum class EHiveDependencyMarketType : uint8
{
    None,
    PlayStore           UMETA(DisplayName = "Google PlayStore"),
    OneStore            UMETA(DisplayName = "OneStore"),
    Amazon              UMETA(DisplayName = "Amazon AppStore"),
    FacebookCloud       UMETA(DisplayName = "Facebook Cloud"),
    GalaxyStore         UMETA(DisplayName = "Samsung GalaxyStore"),
    Huawei              UMETA(DisplayName = "Huawei AppGallery"),
    Xiaomi              UMETA(DisplayName = "Xiaomi(china)")
};

UCLASS(config=Engine, defaultconfig)
class UHiveDependencyAndroidSettings : public UObject
{
    GENERATED_UCLASS_BODY()
    
public:
    /* Hive Module*/
    UPROPERTY(config, EditAnywhere, Category = "Hive Module", Meta = (DisplayName = "Enable HivePromotion"))
    bool bEnableHivePromotion;

    UPROPERTY(config, EditAnywhere, Category = "Hive Module", Meta = (DisplayName = "Enable GoogleInAppReview", EditCondition = "bEnableHivePromotion"))
    bool bEnableGoogleInAppReview;

    UPROPERTY(config, EditAnywhere, Category = "Hive Module", Meta = (DisplayName = "Enable DeviceManagement"))
    bool bEnableDeviceManagement;

    UPROPERTY(config, EditAnywhere, Category = "Hive Module", Meta = (DisplayName = "Enable RealNameVerification", Tooltip = "Select this option to support real name authentication in China."))
    bool bEnableRealNameVerification;

    UPROPERTY(config, EditAnywhere, Category = "Hive Module", Meta = (DisplayName = "Enable Hercules"))
    bool bEnableHercules;

    UPROPERTY(config, EditAnywhere, Category = "Hive Module", Meta = (DisplayName = "Enable reCAPTCHA"))
    bool bEnableReCaptcha;

    UPROPERTY(config, EditAnywhere, Category = "Hive Module", Meta = (DisplayName = "Enable DataStore"))
    bool bEnableDataStore;

    UPROPERTY(config, EditAnywhere, Category = "Hive Module", Meta = (DisplayName = "Enable GoogleInAppUpdate"))
    bool bEnableGoogleInAppUpdate;
    
    UPROPERTY(config, EditAnywhere, Category = "Hive Module", Meta = (DisplayName = "Enable AnalyticsConsentMode"))
    bool bEnableAnalyticsConsentMode;

    UPROPERTY(config, EditAnywhere, Category = "Hive Module", Meta = (DisplayName = "Enable MatchMaking"))
    bool bEnableMatchMaking;

    UPROPERTY(config, EditAnywhere, Category = "Hive Module", Meta = (DisplayName = "Enable Chat"))
    bool bEnableChat;

    UPROPERTY(config, EditAnywhere, Category = "Hive Module", Meta = (DisplayName = "Enable AdultConfirm"))
    bool bEnableAdultConfirm;

    UPROPERTY(config, EditAnywhere, Category = "Hive Module", Meta = (DisplayName = "Enable IdentityVerification"))
    bool bEnableIdentityVerification;

    UPROPERTY(config, EditAnywhere, Category = "Hive Module", Meta = (DisplayName = "Enable AgeRangeGoogle"))
    bool bEnableAgeRangeGoogle;

    /* Auth */
    UPROPERTY(config, EditAnywhere, Category = "Auth", Meta = (DisplayName = "Enable Hive Membership"))
    bool bEnableHiveMembership;

    UPROPERTY(config, EditAnywhere, Category = "Auth", Meta = (DisplayName = "Enable Google Sign-In"))
    bool bEnableGoogleSignIn;
    
    UPROPERTY(config, EditAnywhere, Category = "Auth", Meta = (DisplayName = "Enable Google Play Games"))
    bool bEnableGooglePlayGames;

    UPROPERTY(config, EditAnywhere, Category = "Auth", Meta = (DisplayName = "Enable Facebook"))
    EHiveDependencyFacebookType FacebookType;

    UPROPERTY(config, EditAnywhere, Category = "Auth", Meta = (DisplayName = "Enable Apple Sign-In"))
    bool bEnableAppleSignIn;

    UPROPERTY(config, EditAnywhere, Category = "Auth", Meta = (DisplayName = "Enable Line"))
    bool bEnableLine;

    UPROPERTY(config, EditAnywhere, Category = "Auth", Meta = (DisplayName = "Enable VK"))
    bool bEnableVK;

    UPROPERTY(config, EditAnywhere, Category = "Auth", Meta = (DisplayName = "Enable QQ"))
    bool bEnableQQ;

    UPROPERTY(config, EditAnywhere, Category = "Auth", Meta = (DisplayName = "Enable Wechat"))
    bool bEnableWechat;

    UPROPERTY(config, EditAnywhere, Category = "Auth", Meta = (DisplayName = "Enable Weverse"))
    bool bEnableWeverse;

    UPROPERTY(config, EditAnywhere, Category = "Auth|Huawei")
    bool bEnableHuawei;
    
    UPROPERTY(config, EditAnywhere, Category = "Auth|Huawei", Meta = (DisplayName = "File(agconnect-services.json) Path", EditCondition = "bEnableHuawei", Tooltip = "Select the agconnect-services.json file path"))
    FFilePath HuaweiMetaFilePath;
    
    UPROPERTY(config)
    FString sHuaweiMetaFilePath;

    UPROPERTY(config, EditAnywhere, Category = "Auth", Meta = (DisplayName = "Enable Steam"))
    bool bEnableSteam;

    UPROPERTY(config, EditAnywhere, Category = "Auth", Meta = (DisplayName = "Enable X"))
    bool bEnableX;

    UPROPERTY(config, EditAnywhere, Category = "Auth", Meta = (DisplayName = "Enable Telegram"))
    bool bEnableTelegram;

    UPROPERTY(config, EditAnywhere, Category = "Auth|Xiaomi")
    bool bEnableXiaomi;

    UPROPERTY(config, EditAnywhere, Category = "Auth|Xiaomi", Meta = (DisplayName = "AppId", EditCondition = "bEnableXiaomi", Tooltip = "Input XiaomiAppId"))
    FString XiaomiAppId;

    UPROPERTY(config, EditAnywhere, Category = "Auth|Xiaomi", Meta = (DisplayName = "AppKey", EditCondition = "bEnableXiaomi", Tooltip = "Input XiaomiAppKey"))
    FString XiaomiAppKey;
    
    /* Push */
    UPROPERTY(config, EditAnywhere, Category = "Push")
    EHiveDependencyPushType PushType;


    /* Market(IAPv4) */
    UPROPERTY(config, EditAnywhere, Category = "Market", Meta = (DisplayName = "Market(IAPv4)"))
    EHiveDependencyMarketType MarketType;
    
    UPROPERTY(config, EditAnywhere, Category = "Market|Amazon", Meta = (DisplayName = "File(AppstoreAuthenticationKey.pem) Path", EditCondition = "MarketType == EHiveDependencyMarketType::Amazon", Tooltip = "Select the AppstoreAuthenticationKey.pem file path"))
    FFilePath AmazonMetaFilePath;
    
    UPROPERTY(config)
    FString sAmazonMetaFilePath;

    UPROPERTY(config, EditAnywhere, Category = "Market", Meta = (DisplayName = "Enable Lebi"))
    bool bEnableLebi;
    
    UPROPERTY(config, EditAnywhere, Category = "Market", Meta = (DisplayName = "Enable HiveStore(Hive PG)"))
    bool bEnableHiveStore;

    /* Analytics */
    UPROPERTY(config, EditAnywhere, Category = "Analytics", Meta = (DisplayName = "Enable Adjust"))
    bool bEnableAdjust;

    UPROPERTY(config, EditAnywhere, Category = "Analytics", Meta = (DisplayName = "Enable AppsFlyer"))
    bool bEnableAppsFlyer;

    UPROPERTY(config, EditAnywhere, Category = "Analytics", Meta = (DisplayName = "Enable Singular"))
    bool bEnableSingular;
    
    UPROPERTY(config, EditAnywhere, Category = "Analytics|FirebaseAnalytics")
    bool bEnableFirebase;
    
    UPROPERTY(config, EditAnywhere, Category = "Analytics|FirebaseAnalytics", Meta = (DisplayName = "File(google-services.json) Path", EditCondition = "bEnableFirebase", Tooltip = "Select the google-services.json file path"))
    FFilePath FirebaseMetaFilePath;
    
    UPROPERTY(config)
    FString sFirebaseMetaFilePath;

    UPROPERTY(config, EditAnywhere, Category = "Analytics", Meta = (DisplayName = "Enable Airbridge"))
    bool bEnableAirbridge;

    void PostEditChangeProperty(struct FPropertyChangedEvent& PropertyChangedEvent);
    
private:
    virtual void PostInitProperties() override;
};
