// Copyright (C) 2024 Com2uS Platform Corporation

#pragma once

#include "CoreMinimal.h"
#include "HiveDependencyIOSSettings.generated.h"

UCLASS(config=Engine, defaultconfig)
class UHiveDependencyIOSSettings : public UObject
{
    GENERATED_UCLASS_BODY()
    
public:
    /* Hive Module*/
    UPROPERTY(config, EditAnywhere, Category = "Hive Module", Meta = (DisplayName = "Enable HivePromotion"))
    bool bEnableHivePromotion;

    UPROPERTY(config, EditAnywhere, Category = "Hive Module", Meta = (DisplayName = "Enable DeviceManagement"))
    bool bEnableDeviceManagement;

    UPROPERTY(config, EditAnywhere, Category = "Hive Module", Meta = (DisplayName = "Enable RealNameVerification", Tooltip = "Select this option to support real name authentication in China."))
    bool bEnableRealNameVerification;

    UPROPERTY(config, EditAnywhere, Category = "Hive Module", Meta = (DisplayName = "Enable Hercules"))
    bool bEnableHercules;

    UPROPERTY(config, EditAnywhere, Category = "Hive Module", Meta = (DisplayName = "Enable reCAPTCHA"))
    bool bEnableReCaptcha;

    UPROPERTY(config, EditAnywhere, Category = "Hive Module", Meta = (DisplayName = "Enable DataStore"))
    bool bEnableDataStore;
    
    UPROPERTY(config, EditAnywhere, Category = "Hive Module", Meta = (DisplayName = "Enable AnalyticsConsentMode"))
    bool bEnableAnalyticsConsentMode;

    UPROPERTY(config, EditAnywhere, Category = "Hive Module", Meta = (DisplayName = "Enable MatchMaking"))
    bool bEnableMatchMaking;

    UPROPERTY(config, EditAnywhere, Category = "Hive Module", Meta = (DisplayName = "Enable Chat"))
    bool bEnableChat;

    UPROPERTY(config, EditAnywhere, Category = "Hive Module", Meta = (DisplayName = "Enable AdultConfirm"))
    bool bEnableAdultConfirm;

    UPROPERTY(config, EditAnywhere, Category = "Hive Module", Meta = (DisplayName = "Enable IdentityVerification"))
    bool bEnableIdentityVerification;

    UPROPERTY(config, EditAnywhere, Category = "Hive Module", Meta = (DisplayName = "Enable AgeRangeApple"))
    bool bEnableAgeRangeApple;

    /* Auth */
    UPROPERTY(config, EditAnywhere, Category = "Auth", Meta = (DisplayName = "Enable Hive Membership"))
    bool bEnableHiveMembership;

    UPROPERTY(config, EditAnywhere, Category = "Auth", Meta = (DisplayName = "Enable Google Sign-In"))
    bool bEnableGoogleSignIn;

    UPROPERTY(config, EditAnywhere, Category = "Auth", Meta = (DisplayName = "Enable Facebook"))
    bool bEnableFacebook;

    UPROPERTY(config, EditAnywhere, Category = "Auth", Meta = (DisplayName = "Enable Apple GameCenter"))
    bool bEnableAppleGameCenter;

    UPROPERTY(config, EditAnywhere, Category = "Auth", Meta = (DisplayName = "Enable Apple Sign-In"))
    bool bEnableAppleSignIn;

    UPROPERTY(config, EditAnywhere, Category = "Auth", Meta = (DisplayName = "Enable Line"))
    bool bEnableLine;

    UPROPERTY(config, EditAnywhere, Category = "Auth", Meta = (DisplayName = "Enable VK"))
    bool bEnableVK;

    UPROPERTY(config, EditAnywhere, Category = "Auth", Meta = (DisplayName = "Enable QQ"))
    bool bEnableQQ;

    UPROPERTY(config, EditAnywhere, Category = "Auth", Meta = (DisplayName = "Enable Wechat"))
    bool bEnableWechat;

    UPROPERTY(config, EditAnywhere, Category = "Auth", Meta = (DisplayName = "Enable Weverse"))
    bool bEnableWeverse;

    UPROPERTY(config, EditAnywhere, Category = "Auth", Meta = (DisplayName = "Enable Steam"))
    bool bEnableSteam;

    UPROPERTY(config, EditAnywhere, Category = "Auth", Meta = (DisplayName = "Enable X"))
    bool bEnableX;

    UPROPERTY(config, EditAnywhere, Category = "Auth", Meta = (DisplayName = "Enable Telegram"))
    bool bEnableTelegram;

    
    /* Push NOT_SUPPORT*/
    // UPROPERTY(config, EditAnywhere, Category = "Push", Meta = (DisplayName = "Enable APNs"))
    // bool bEnableAPNs;


    /* Market(IAPv4) */
    UPROPERTY(config, EditAnywhere, Category = "Market", Meta = (DisplayName = "Enable Apple AppStore"))
    bool bEnableAppleAppStore;


    /* Analytics */
    UPROPERTY(config, EditAnywhere, Category = "Analytics", Meta = (DisplayName = "Enable Adjust"))
    bool bEnableAdjust;

    UPROPERTY(config, EditAnywhere, Category = "Analytics", Meta = (DisplayName = "Enable AppsFlyer"))
    bool bEnableAppsFlyer;

    UPROPERTY(config, EditAnywhere, Category = "Analytics", Meta = (DisplayName = "Enable Singular"))
    bool bEnableSingular;
    
    UPROPERTY(config, EditAnywhere, Category = "Analytics|FirebaseAnalytics")
    bool bEnableFirebase;

    UPROPERTY(config, EditAnywhere, Category = "Analytics", Meta = (DisplayName = "Enable Airbridge"))
    bool bEnableAirbridge;

    
private:
    virtual void PostInitProperties() override;
};
