// Copyright 1998-2016 Epic Games, Inc. All Rights Reserved.

using UnrealBuildTool;

using System.Collections.Generic;
using System.IO;
using System;
using System.Linq;
using System.Text;

#if UE_5_0_OR_LATER
using EpicGames.Core;
#else
using Tools.DotNETCommon;
#endif

public class HiveSDKWindows : ModuleRules
{
	private void AddRunTimeDependencyRecursively(string strRootDirectory, string subDirectory, string[] excludedFolder)
	{
		foreach (string targetExcludeFolder in excludedFolder) {
			if(subDirectory.Contains(targetExcludeFolder))
			{
				//System.Console.WriteLine("=============		AddRunTimeDependencyRecursively Found Exclude Folder : " + targetExcludeFolder + "	=========================");
				//Exclude Folder Founded. end recursive. do not copy this direcotry!.
				return;
			}
		}
		string rootDirectory = Path.GetFullPath(strRootDirectory);
		DirectoryInfo dir = new DirectoryInfo(rootDirectory + subDirectory);

		if (!dir.Exists)
		{
			throw new DirectoryNotFoundException(
				"assets/additional directory does not exist or could not be found: ");
		}

		DirectoryInfo[] dirs = dir.GetDirectories("*", SearchOption.TopDirectoryOnly);    //  for recursively
		FileInfo[] files = dir.GetFiles("*.*", SearchOption.TopDirectoryOnly);
		foreach (FileInfo file in files)
		{
			if (!file.Name.EndsWith(".meta"))
			{
				RuntimeDependencies.Add("$(TargetOutputDir)/" + subDirectory + file.Name, file.FullName);
			}
		}

		foreach (DirectoryInfo foundedSubdir in dirs)
		{
			String rootDirecotryName = (new DirectoryInfo(rootDirectory)).Name;
			int rootDirecotryNameLength = rootDirecotryName.Length;
			string subDirSubString = foundedSubdir.FullName.Substring(foundedSubdir.FullName.IndexOf(rootDirecotryName) + rootDirecotryNameLength);
			AddRunTimeDependencyRecursively(rootDirectory, subDirSubString + "\\", excludedFolder);
		}
		
	}

	public HiveSDKWindows(ReadOnlyTargetRules Target) : base(Target)
	{
		System.Console.WriteLine("Module Type : " + Type);

		// UE 5.6 호환성을 위한 필수 설정
		PCHUsage = ModuleRules.PCHUsageMode.UseExplicitOrSharedPCHs;
		
		// Add search path
		PublicIncludePaths.AddRange(
			new string[] {
				"Runtime/Launch/Public",

				ModuleDirectory + "/Public",                // Plugins/HIVESDK/Source/HIVESDK/Public
				ModuleDirectory + "/Public/CPP",
			}
		);

		PrivateIncludePaths.AddRange(
			new string[] {
				ModuleDirectory + "/Private",
			}
		);

		PublicDependencyModuleNames.AddRange(
			new string[] {
				"Core",             // for argument
				"CoreUObject",
                "Json",
                "JsonUtilities",
                "ApplicationCore",
				"HIVESDK"
			}
		);
        
		
		if (Target.Platform == UnrealTargetPlatform.Win64)
		{
			PublicDependencyModuleNames.AddRange(
			new string[]
			{
						"Core",
						"Projects"
				// ... add other public dependencies that you statically link with here ...

			}
			);
			PrivateDependencyModuleNames.AddRange(
			new string[]
			{
						// ... add private dependencies that you statically link with here ...
						"Core",
						"CoreUObject",
						"Engine",
						"InputCore",
						"Slate", "SlateCore", "Json", "JsonUtilities"
				//"UnrealEd"
			}
			);
			//	this will copy to same directory which is excutebale files location.
			string[] excludedDirecotry = new string[] {
				"hercules"
			};
			//PublicAdditionalLibraries.Add(ModuleDirectory + "/assets/lib/Hercules.lib");    //    Use Hercules. Enable This.

			if (Target.Type == TargetType.Editor)
			{
				//	Do nothing when Editor Environment. SDK Dll will be not loaded. Dummy API on HIVE_OtherPlatformEmptyImpl.cpp
			}
			else
			{
                PublicAdditionalLibraries.Add(ModuleDirectory + "/assets/lib/HIVE_PLUGIN_CPP.lib");
                PublicDelayLoadDLLs.Add("HIVE_PLUGIN_CPP.dll");

                //	Copy windows Library, Resources.
                AddRunTimeDependencyRecursively(ModuleDirectory + "/assets/additional/", "", excludedDirecotry);

				string herculesDir = ModuleDirectory + "/assets/additional/hivePlugins/hercules";
				if (Directory.Exists(herculesDir))
				{
					// Copy windows Library where is located in excludedDirecotry. only exception 'hiveSecurity'.
					foreach (string FilePath in Directory.EnumerateFiles(herculesDir, "*", SearchOption.AllDirectories))
					{
						string targetResourceFilePath = FilePath.Substring(FilePath.IndexOf("/hercules") + 9);
						RuntimeDependencies.Add("$(TargetOutputDir)/" + targetResourceFilePath, FilePath);
					}
				}

				// 	Resource HiveConfig Copy.
				foreach (string FilePath in Directory.EnumerateFiles(ModuleDirectory + "/assets/config", "*", SearchOption.AllDirectories))
				{
					string targetResourceFilePath = FilePath.Substring(FilePath.IndexOf("/assets/config") + 14);
					RuntimeDependencies.Add("$(TargetOutputDir)/Resources/" + targetResourceFilePath, FilePath);
				}
			}
		}
	}
}
